/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.sop.evaluation;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.faces.model.SelectItem;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.util.MessageResources;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.InfoRoom;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.faces.bean.teacher.evaluation.EvaluationManagementBackingBean;
import org.fenixedu.academic.ui.faces.components.util.CalendarLink;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.fenixedu.spaces.domain.occupation.Occupation;

public class WrittenEvaluationsByRoomBackingBean
extends EvaluationManagementBackingBean {
    private static final MessageResources messages = MessageResources.getMessageResources((String)"resources.ResourceAllocationManagerResources");
    private String name;
    private String building;
    private String floor;
    private String type;
    private String normalCapacity;
    private String examCapacity;
    private String academicInterval = AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER).getResumedRepresentationInStringFormat();
    private String startDate;
    private String endDate;
    private Boolean includeEntireYear;
    private boolean submittedForm = false;
    private Collection<InfoRoom> allRooms = null;
    private Set<String> selectedRoomIDs = null;
    private static final Comparator<SelectItem> SELECT_ITEM_LABEL_COMPARATOR = new Comparator<SelectItem>(){

        @Override
        public int compare(SelectItem o1, SelectItem o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    };

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String building) {
        this.building = building;
    }

    public String getExamCapacity() {
        return this.examCapacity;
    }

    public void setExamCapacity(String examCapacity) {
        this.examCapacity = examCapacity;
    }

    public String getFloor() {
        return this.floor;
    }

    public void setFloor(String floor) {
        this.floor = floor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNormalCapacity() {
        return this.normalCapacity;
    }

    public void setNormalCapacity(String normalCapacity) {
        this.normalCapacity = normalCapacity;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAcademicInterval() {
        return this.academicInterval == null ? (this.academicInterval = this.getAndHoldStringParameter("academicInterval")) : this.academicInterval;
    }

    public void setAcademicInterval(String academicInterval) {
        this.academicInterval = academicInterval;
    }

    protected AcademicInterval getAcademicIntervalObject() {
        return this.getAcademicInterval() == null ? null : AcademicInterval.getAcademicIntervalFromResumedString(this.getAcademicInterval());
    }

    public boolean getSubmittedForm() {
        return this.submittedForm;
    }

    public WrittenEvaluationsByRoomBackingBean() {
        if (this.getRequestParameter("submittedForm") != null) {
            this.submittedForm = true;
        }
        this.getExecutionCourseID();
    }

    private Collection<InfoRoom> getAllRooms() throws FenixServiceException {
        if (this.allRooms == null) {
            this.allRooms = SpaceUtils.allocatableSpacesForEducation().map(s -> new InfoRoom((Space)s)).collect(Collectors.toList());
        }
        return this.allRooms;
    }

    public Set<String> getSelectedRoomIDs() {
        if (this.selectedRoomIDs == null) {
            String[] selectedRoomIDStrings = this.getRequest().getParameterValues("selectedRoomIDs");
            if (selectedRoomIDStrings != null) {
                this.selectedRoomIDs = new HashSet<String>(selectedRoomIDStrings.length);
                for (String roomIDString : selectedRoomIDStrings) {
                    this.selectedRoomIDs.add(roomIDString);
                }
            } else if (this.getRequest().getParameter("selectedRoomID") != null) {
                String roomID = this.getRequest().getParameter("selectedRoomID");
                this.selectedRoomIDs = new HashSet<String>(1);
                this.selectedRoomIDs.add(roomID);
            }
        }
        return this.selectedRoomIDs;
    }

    private Collection<InfoRoom> searchRooms() throws FenixServiceException {
        String name = this.getName();
        String building = this.getBuilding() != null && this.getBuilding().length() > 0 ? this.getBuilding() : null;
        Integer floor = this.getFloor() != null && this.getFloor().length() > 0 ? Integer.valueOf(this.getFloor()) : null;
        String type = this.getType();
        Integer normalCapacity = this.getNormalCapacity() != null && this.getNormalCapacity().length() > 0 ? Integer.valueOf(this.getNormalCapacity()) : null;
        Integer examCapacity = this.getExamCapacity() != null && this.getExamCapacity().length() > 0 ? Integer.valueOf(this.getExamCapacity()) : null;
        Collection<InfoRoom> rooms = this.getAllRooms();
        ArrayList<InfoRoom> selectedRooms = new ArrayList<InfoRoom>();
        for (InfoRoom room : rooms) {
            boolean matchesCriteria = true;
            if (name != null && name.length() > 0 && !room.getName().equalsIgnoreCase(name)) {
                matchesCriteria = false;
            } else if (building != null && !room.getSpaceBuilding().getExternalId().equals(building)) {
                matchesCriteria = false;
            } else if (floor != null && !floor.equals(room.getPiso())) {
                matchesCriteria = false;
            } else if (!(type == null || type.length() <= 0 || room.getClassification() != null && room.getClassification().getExternalId().toString().equals(type))) {
                matchesCriteria = false;
            } else if (normalCapacity != null && room.getCapacidadeNormal() < normalCapacity) {
                matchesCriteria = false;
            } else if (examCapacity != null && room.getCapacidadeExame() < examCapacity) {
                matchesCriteria = false;
            }
            if (!matchesCriteria || StringUtils.isEmpty((String)room.getName())) continue;
            selectedRooms.add(room);
        }
        return selectedRooms;
    }

    public Collection<InfoRoom> getRooms() throws FenixServiceException {
        return this.getSubmittedForm() ? this.searchRooms() : null;
    }

    public Collection<Space> getBuildings() throws FenixServiceException {
        return SpaceUtils.buildings();
    }

    public Collection<InfoRoom> getRoomsToDisplayMap() throws FenixServiceException {
        Set<String> selectedRoomIDs = this.getSelectedRoomIDs();
        if (selectedRoomIDs != null) {
            return this.filterRooms(this.getAllRooms(), selectedRoomIDs);
        }
        Collection<InfoRoom> rooms = this.getRooms();
        return rooms != null && rooms.size() == 1 ? this.getRooms() : null;
    }

    private Collection<InfoRoom> filterRooms(Collection<InfoRoom> allRooms, Set<String> selectedRoomIDs) {
        ArrayList<InfoRoom> rooms = new ArrayList<InfoRoom>(selectedRoomIDs.size());
        for (InfoRoom room : allRooms) {
            if (!selectedRoomIDs.contains(room.getExternalId())) continue;
            rooms.add(room);
        }
        return rooms;
    }

    public Collection<SelectItem> getBuildingSelectItems() throws FenixServiceException {
        List buildings = (List)this.getBuildings();
        ArrayList<SelectItem> buildingSelectItems = new ArrayList<SelectItem>();
        for (Space building : buildings) {
            buildingSelectItems.add(new SelectItem((Object)building.getExternalId().toString(), building.getName()));
        }
        Collections.sort(buildingSelectItems, SELECT_ITEM_LABEL_COMPARATOR);
        return buildingSelectItems;
    }

    public Collection<SelectItem> getAcademicIntervals() throws FenixServiceException {
        List<AcademicInterval> intervals = AcademicInterval.readAcademicIntervals(AcademicPeriod.SEMESTER);
        Collections.sort(intervals, new ReverseComparator(AcademicInterval.COMPARATOR_BY_BEGIN_DATE));
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (AcademicInterval interval : intervals) {
            items.add(new SelectItem((Object)interval.getResumedRepresentationInStringFormat(), interval.getPathName()));
        }
        return items;
    }

    public Collection<SelectItem> getRoomTypeSelectItems() throws FenixServiceException {
        List roomClassificationsForEducation = SpaceClassification.all();
        ArrayList<SelectItem> roomTypeSelectItems = new ArrayList<SelectItem>();
        for (SpaceClassification classification : SpaceUtils.sortByRoomClassificationAndCode(roomClassificationsForEducation)) {
            if (classification.getParent() == null) continue;
            roomTypeSelectItems.add(new SelectItem((Object)String.valueOf(classification.getExternalId()), classification.getAbsoluteCode() + " - " + classification.getName().getContent(I18N.getLocale())));
        }
        return roomTypeSelectItems;
    }

    @Deprecated
    public ExecutionSemester getExecutionPeriod() throws FenixServiceException {
        return (ExecutionSemester)((Object)(this.getAcademicIntervalObject() != null ? ExecutionSemester.getExecutionInterval((AcademicInterval)this.getAcademicIntervalObject()) : null));
    }

    public Date getCalendarBegin() throws FenixServiceException, ParseException {
        if (this.getStartDate() != null && this.getStartDate().length() > 0) {
            return DateFormatUtil.parse("dd/MM/yyyy", this.getStartDate());
        }
        return this.getAcademicIntervalObject().getStart().toDate();
    }

    public Date getCalendarEnd() throws FenixServiceException, ParseException {
        if (this.getEndDate() != null && this.getEndDate().length() > 0) {
            return DateFormatUtil.parse("dd/MM/yyyy", this.getEndDate());
        }
        return this.getAcademicIntervalObject().getEnd().toDate();
    }

    public Map<InfoRoom, List<CalendarLink>> getWrittenEvaluationCalendarLinks() throws FenixServiceException {
        Collection<InfoRoom> rooms = this.getRoomsToDisplayMap();
        if (rooms != null) {
            AcademicInterval interval = this.getAcademicIntervalObject();
            Boolean includeEntireYear = this.getIncludeEntireYear();
            AcademicInterval otherAcademicInterval = includeEntireYear != null && includeEntireYear != false ? interval.getPreviousAcademicInterval() : null;
            HashMap<InfoRoom, List<CalendarLink>> calendarLinksMap = new HashMap<InfoRoom, List<CalendarLink>>();
            for (InfoRoom infoRoom : rooms) {
                Space room = infoRoom.getRoom();
                ArrayList<CalendarLink> calendarLinks = new ArrayList<CalendarLink>();
                for (Occupation roomOccupation : room.getOccupationSet()) {
                    if (!(roomOccupation instanceof WrittenEvaluationSpaceOccupation)) continue;
                    Set writtenEvaluations = ((WrittenEvaluationSpaceOccupation)roomOccupation).getWrittenEvaluationsSet();
                    for (WrittenEvaluation writtenEvaluation : writtenEvaluations) {
                        if (!this.verifyWrittenEvaluationExecutionPeriod(writtenEvaluation, interval, otherAcademicInterval)) continue;
                        ExecutionCourse executionCourse = (ExecutionCourse)((Object)writtenEvaluation.getAssociatedExecutionCoursesSet().iterator().next());
                        CalendarLink calendarLink = new CalendarLink(executionCourse, writtenEvaluation, I18N.getLocale());
                        calendarLink.setLinkParameters(this.constructLinkParameters(executionCourse, writtenEvaluation));
                        calendarLinks.add(calendarLink);
                    }
                }
                calendarLinksMap.put(infoRoom, calendarLinks);
            }
            return calendarLinksMap;
        }
        return null;
    }

    protected boolean verifyWrittenEvaluationExecutionPeriod(WrittenEvaluation writtenEvaluation, AcademicInterval interval, AcademicInterval otherAcademicInterval) {
        for (ExecutionCourse executionCourse : writtenEvaluation.getAssociatedExecutionCoursesSet()) {
            if (!executionCourse.getAcademicInterval().equals(interval) && (otherAcademicInterval == null || !executionCourse.getAcademicInterval().equals(otherAcademicInterval))) continue;
            return true;
        }
        return false;
    }

    public List<Map.Entry<InfoRoom, List<CalendarLink>>> getWrittenEvaluationCalendarLinksEntryList() throws FenixServiceException {
        Map<InfoRoom, List<CalendarLink>> calendarLinks = this.getWrittenEvaluationCalendarLinks();
        return calendarLinks != null ? new ArrayList<Map.Entry<InfoRoom, List<CalendarLink>>>(calendarLinks.entrySet()) : null;
    }

    private Map<String, String> constructLinkParameters(ExecutionCourse executionCourse, WrittenEvaluation writtenEvaluation) {
        ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
        ExecutionDegree executionDegree = this.findExecutionDegree(executionCourse);
        Integer year = this.findCurricularYear(executionCourse);
        CurricularYear curricularYear = CurricularYear.readByYear(year);
        HashMap<String, String> linkParameters = new HashMap<String, String>();
        linkParameters.put("executionCourseID", executionCourse.getExternalId().toString());
        linkParameters.put("evaluationID", writtenEvaluation.getExternalId().toString());
        linkParameters.put("executionPeriodID", executionSemester.getExternalId().toString());
        linkParameters.put("executionDegreeID", executionDegree.getExternalId().toString());
        if (curricularYear != null) {
            linkParameters.put("curricularYearID", curricularYear.getExternalId().toString());
        }
        linkParameters.put("evaluationTypeClassname", ((Object)((Object)writtenEvaluation)).getClass().getName());
        linkParameters.put("academicInterval", this.getAcademicInterval());
        return linkParameters;
    }

    private ExecutionDegree findExecutionDegree(ExecutionCourse executionCourse) {
        ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
        ExecutionYear executionYear = executionSemester.getExecutionYear();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                if (executionDegree.getExecutionYear() != executionYear) continue;
                return executionDegree;
            }
        }
        return null;
    }

    private Integer findCurricularYear(ExecutionCourse executionCourse) {
        ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            for (DegreeModuleScope degreeModuleScope : curricularCourse.getDegreeModuleScopes()) {
                if (!degreeModuleScope.isActiveForExecutionPeriod(executionSemester)) continue;
                return degreeModuleScope.getCurricularYear();
            }
        }
        return null;
    }

    protected String constructEvaluationCalendarPresentarionString(WrittenEvaluation writtenEvaluation, ExecutionCourse executionCourse) {
        StringBuilder stringBuilder = new StringBuilder();
        if (writtenEvaluation instanceof WrittenTest) {
            stringBuilder.append(messages.getMessage("label.evaluation.shortname.test"));
        } else if (writtenEvaluation instanceof Exam) {
            stringBuilder.append(messages.getMessage("label.evaluation.shortname.exam"));
        }
        stringBuilder.append(" ");
        stringBuilder.append(executionCourse.getSigla());
        stringBuilder.append(" (");
        stringBuilder.append(DateFormatUtil.format("HH:mm", writtenEvaluation.getBeginning().getTime()));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getEndDate() {
        return this.endDate == null ? (this.endDate = this.getAndHoldStringParameter("endDate")) : this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getStartDate() {
        return this.startDate == null ? (this.startDate = this.getAndHoldStringParameter("startDate")) : this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public Boolean getIncludeEntireYear() {
        return this.includeEntireYear == null ? (this.includeEntireYear = this.getAndHoldBooleanParameter("includeEntireYear")) : this.includeEntireYear;
    }

    public void setIncludeEntireYear(Boolean includeEntireYear) {
        this.includeEntireYear = includeEntireYear;
    }
}

