/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.strategy.groupEnrolment.strategys;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.IGroupEnrolmentStrategy;

public abstract class GroupEnrolmentStrategy
implements IGroupEnrolmentStrategy {
    @Override
    public boolean checkNumberOfGroups(Grouping grouping, Shift shift) {
        Integer maximumGroupCapacity = grouping.getGroupMaximumNumber();
        if (shift != null && grouping.getDifferentiatedCapacity().booleanValue()) {
            maximumGroupCapacity = shift.getShiftGroupingProperties().getCapacity();
        } else if (maximumGroupCapacity == null) {
            return true;
        }
        int numberOfGroups = 0;
        numberOfGroups = shift != null ? grouping.readAllStudentGroupsBy(shift).size() : grouping.getStudentGroupsWithoutShift().size();
        return maximumGroupCapacity == null || numberOfGroups < maximumGroupCapacity;
    }

    @Override
    public boolean checkEnrolmentDate(Grouping grouping, Calendar actualDate) {
        Long actualDateInMills = new Long(actualDate.getTimeInMillis());
        Long enrolmentBeginDayInMills = null;
        Long enrolmentEndDayInMills = null;
        if (grouping.getEnrolmentBeginDay() != null) {
            enrolmentBeginDayInMills = new Long(grouping.getEnrolmentBeginDay().getTimeInMillis());
        }
        if (grouping.getEnrolmentEndDay() != null) {
            enrolmentEndDayInMills = new Long(grouping.getEnrolmentEndDay().getTimeInMillis());
        }
        if (enrolmentBeginDayInMills == null && enrolmentEndDayInMills == null) {
            return true;
        }
        if (enrolmentBeginDayInMills != null && enrolmentEndDayInMills == null && actualDateInMills.compareTo(enrolmentBeginDayInMills) > 0) {
            return true;
        }
        if (enrolmentBeginDayInMills == null && enrolmentEndDayInMills != null && actualDateInMills.compareTo(enrolmentEndDayInMills) < 0) {
            return true;
        }
        return actualDateInMills.compareTo(enrolmentBeginDayInMills) > 0 && actualDateInMills.compareTo(enrolmentEndDayInMills) < 0;
    }

    @Override
    public boolean checkShiftType(Grouping grouping, Shift shift) {
        if (shift != null) {
            return shift.containsType(grouping.getShiftType());
        }
        return grouping.getShiftType() == null;
    }

    @Override
    public List checkShiftsType(Grouping grouping, List shifts) {
        ArrayList<Shift> result = new ArrayList<Shift>();
        if (grouping.getShiftType() != null) {
            for (Shift shift : shifts) {
                if (!shift.containsType(grouping.getShiftType())) continue;
                result.add(shift);
            }
        }
        return result;
    }

    @Override
    public boolean checkAlreadyEnroled(Grouping grouping, String studentUsername) {
        Attends studentAttend = grouping.getStudentAttend(studentUsername);
        if (studentAttend != null) {
            Set<StudentGroup> groupingStudentGroups = grouping.getStudentGroupsSet();
            for (StudentGroup studentGroup : groupingStudentGroups) {
                Set studentGroupAttends = studentGroup.getAttendsSet();
                for (Attends attend : studentGroupAttends) {
                    if (attend != studentAttend) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean checkNotEnroledInGroup(Grouping grouping, StudentGroup studentGroup, String studentUsername) {
        Attends studentAttend = grouping.getStudentAttend(studentUsername);
        if (studentAttend != null) {
            Set studentGroupAttends = studentGroup.getAttendsSet();
            for (Attends attend : studentGroupAttends) {
                if (attend != studentAttend) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkPossibleToEnrolInExistingGroup(Grouping grouping, StudentGroup studentGroup) {
        int numberOfElements = studentGroup.getAttendsSet().size();
        Integer maximumCapacity = grouping.getMaximumCapacity();
        if (maximumCapacity == null) {
            return true;
        }
        return numberOfElements < maximumCapacity;
    }

    @Override
    public boolean checkIfStudentGroupIsEmpty(Attends attend, StudentGroup studentGroup) {
        Set allStudentGroupAttends = studentGroup.getAttendsSet();
        return allStudentGroupAttends.size() == 1 && allStudentGroupAttends.contains((Object)attend);
    }

    @Override
    public boolean checkStudentInGrouping(Grouping grouping, String username) {
        Attends attend = grouping.getStudentAttend(username);
        return attend != null;
    }

    @Override
    public boolean checkStudentsUserNamesInGrouping(List<String> studentUsernames, Grouping grouping) {
        for (String studentUsername : studentUsernames) {
            if (grouping.getStudentAttend(studentUsername) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkHasShift(Grouping grouping) {
        return grouping.getShiftType() != null;
    }

    @Override
    public abstract Integer enrolmentPolicyNewGroup(Grouping var1, int var2, Shift var3);

    @Override
    public abstract boolean checkNumberOfGroupElements(Grouping var1, StudentGroup var2);
}

