/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.accounting;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.service.services.accounting.CreatePaymentsForEvents$callable$run;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreatePaymentsForEvents {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static Receipt run(User user, Collection<EntryDTO> collection, PaymentMode paymentMode, boolean bl, DateTime dateTime, Person person, String string, String string2, String string3) {
        return (Receipt)((Object)advice$run.perform((Callable)new CreatePaymentsForEvents$callable$run(user, collection, paymentMode, bl, dateTime, person, string, string2, string3)));
    }

    static /* synthetic */ Receipt advised$run(User responsibleUser, Collection<EntryDTO> entryDTOs, PaymentMode paymentMode, boolean differedPayment, DateTime whenRegistered, Person person, String contributorName, String contributorNumber, String contributorAddress) {
        DateTime dateToSet = differedPayment ? whenRegistered : new DateTime();
        List<Entry> createdEntries = CreatePaymentsForEvents.createEntries(responsibleUser, entryDTOs, paymentMode, dateToSet);
        return Receipt.create(responsibleUser.getPerson(), person, contributorName, contributorNumber, contributorAddress, dateToSet.getYear(), createdEntries);
    }

    private static List<Entry> createEntries(User responsibleUser, Collection<EntryDTO> entryDTOs, PaymentMode paymentMode, DateTime whenRegistered) {
        Map<Event, Collection<EntryDTO>> entryDTOsByEvent = CreatePaymentsForEvents.splitEntryDTOsByEvent(entryDTOs);
        ArrayList<Entry> resultingEntries = new ArrayList<Entry>();
        for (Map.Entry<Event, Collection<EntryDTO>> entry : entryDTOsByEvent.entrySet()) {
            resultingEntries.addAll(entry.getKey().process(responsibleUser, entry.getValue(), new AccountingTransactionDetailDTO(whenRegistered, paymentMode)));
        }
        return resultingEntries;
    }

    private static Map<Event, Collection<EntryDTO>> splitEntryDTOsByEvent(Collection<EntryDTO> entryDTOs) {
        HashMap<Event, Collection<EntryDTO>> result = new HashMap<Event, Collection<EntryDTO>>();
        for (EntryDTO entryDTO : entryDTOs) {
            ArrayList<EntryDTO> entryDTOsByEvent = (ArrayList<EntryDTO>)result.get((Object)entryDTO.getEvent());
            if (entryDTOsByEvent == null) {
                entryDTOsByEvent = new ArrayList<EntryDTO>();
                result.put(entryDTO.getEvent(), entryDTOsByEvent);
            }
            entryDTOsByEvent.add(entryDTO);
        }
        return result;
    }
}

