/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.bennu.core.domain.User;

public class StudentsSearchBean
implements Serializable {
    private Integer number;
    private String identificationNumber;
    private IDDocumentType documentType;
    private String name;
    private String username;

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public IDDocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(IDDocumentType documentType) {
        this.documentType = documentType;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean hasSearchParameters() {
        return this.getNumber() != null || !StringUtils.isEmpty((String)this.getIdentificationNumber()) && this.getDocumentType() != null || !StringUtils.isEmpty((String)this.getName()) || !StringUtils.isEmpty((String)this.getUsername());
    }

    public Set<Student> search() {
        User user;
        HashSet<Student> students = new HashSet<Student>();
        if (this.getNumber() != null) {
            for (Registration registration : Registration.readByNumber(this.getNumber())) {
                students.add(registration.getStudent());
            }
            Student student = Student.readStudentByNumber(this.getNumber());
            if (student != null) {
                students.add(student);
            }
        } else if (!StringUtils.isEmpty((String)this.getIdentificationNumber()) && this.getDocumentType() != null) {
            Person person = Person.readByDocumentIdNumberAndIdDocumentType(this.getIdentificationNumber(), this.getDocumentType());
            if (person != null && person.getStudent() != null) {
                students.add(person.getStudent());
            }
        } else if (!StringUtils.isEmpty((String)this.getName())) {
            students.addAll(Person.findPersonStream(this.getName(), Integer.MAX_VALUE).map(p -> p.getStudent()).filter(Objects::nonNull).collect(Collectors.toSet()));
        } else if (!StringUtils.isEmpty((String)this.getUsername()) && (user = User.findByUsername((String)this.getUsername())) != null && user.getPerson().getStudent() != null) {
            students.add(user.getPerson().getStudent());
        }
        return students;
    }

    public Set<Student> searchForPrograms(Set<AcademicProgram> programs) {
        TreeSet<Student> students = new TreeSet<Student>(Student.NUMBER_COMPARATOR);
        for (Student student : this.search()) {
            if (student == null) continue;
            if (student.getRegistrationsSet().isEmpty()) {
                students.add(student);
            }
            for (Registration registration : student.getRegistrationsSet()) {
                if (!programs.contains(registration.getDegree())) continue;
                students.add(student);
            }
        }
        return students;
    }

    public Set<Student> getSearch() {
        return this.search();
    }
}

