/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonPlanning;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.dto.teacher.executionCourse.NextPossibleSummaryLessonsAndDatesBean;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.Partial;
import org.joda.time.YearMonthDay;

public class SummariesManagementBean
implements Serializable {
    private ExecutionCourse executionCourseReference;
    private SummaryType summaryType;
    private ShiftType lessonType;
    private Lesson lessonReference;
    private Shift shiftReference;
    private YearMonthDay summaryDate;
    private Partial summaryTime;
    private Professorship professorshipReference;
    private Teacher teacherReference;
    private String teacherName;
    private Space roomReference;
    private Integer studentsNumber;
    private MultiLanguageString title;
    private MultiLanguageString summaryText;
    private LessonPlanning lessonPlannigReference;
    private Summary lastSummaryReference;
    private Summary summaryReference;
    private Professorship professorshipLoggedReference;
    private Boolean taught;
    private List<NextPossibleSummaryLessonsAndDatesBean> nextPossibleSummaryLessonsAndDatesBean;

    protected SummariesManagementBean() {
    }

    public SummariesManagementBean(SummaryType summaryType, ExecutionCourse executionCourse, Professorship professorship, List<NextPossibleSummaryLessonsAndDatesBean> nextPossibleSummaryLessonsAndDatesBean) {
        this.setSummaryType(summaryType);
        this.setExecutionCourse(executionCourse);
        this.setProfessorship(professorship);
        this.setProfessorshipLogged(professorship);
        this.setNextPossibleSummaryLessonsAndDatesBean(nextPossibleSummaryLessonsAndDatesBean);
        this.setTaught(true);
    }

    public SummariesManagementBean(MultiLanguageString title, MultiLanguageString summaryText, Integer studentsNumber, SummaryType summaryType, Professorship professorship, String teacherName, Teacher teacher, Shift shift, Lesson lesson, YearMonthDay summaryDate, Space summaryRoom, Partial summaryTime, Summary summary, Professorship professorshipLogged, ShiftType lessonType, Boolean taught) {
        this.setTitle(title);
        this.setSummaryText(summaryText);
        this.setSummaryType(summaryType);
        this.setShift(shift);
        this.setLesson(lesson);
        this.setProfessorship(professorship);
        this.setTeacher(teacher);
        this.setTeacherName(teacherName);
        this.setSummary(summary);
        this.setSummaryDate(summaryDate);
        this.setSummaryRoom(summaryRoom);
        this.setSummaryTime(summaryTime);
        this.setStudentsNumber(studentsNumber);
        this.setExecutionCourse(shift.getExecutionCourse());
        this.setProfessorshipLogged(professorshipLogged);
        this.setLessonType(lessonType);
        this.setTaught(taught);
    }

    public String getTeacherName() {
        return this.teacherName;
    }

    public void setTeacherName(String teacherName) {
        this.teacherName = teacherName;
    }

    public Integer getStudentsNumber() {
        return this.studentsNumber;
    }

    public void setStudentsNumber(Integer studentsNumber) {
        this.studentsNumber = studentsNumber;
    }

    public Summary getSummary() {
        return this.summaryReference;
    }

    public void setSummary(Summary summary) {
        this.summaryReference = summary;
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourseReference;
    }

    public void setExecutionCourse(ExecutionCourse executionCourse) {
        this.executionCourseReference = executionCourse;
    }

    public Teacher getTeacher() {
        return this.teacherReference;
    }

    public void setTeacher(Teacher teacher) {
        this.teacherReference = teacher;
    }

    public Professorship getProfessorshipLogged() {
        return this.professorshipLoggedReference;
    }

    public void setProfessorshipLogged(Professorship professorship) {
        this.professorshipLoggedReference = professorship;
    }

    public Summary getLastSummary() {
        return this.lastSummaryReference;
    }

    public void setLastSummary(Summary summary) {
        this.lastSummaryReference = summary;
    }

    public LessonPlanning getLessonPlanning() {
        return this.lessonPlannigReference;
    }

    public void setLessonPlanning(LessonPlanning lessonPlanning) {
        this.lessonPlannigReference = lessonPlanning;
    }

    public Professorship getProfessorship() {
        return this.professorshipReference;
    }

    public void setProfessorship(Professorship professorship) {
        this.professorshipReference = professorship;
    }

    public Lesson getLesson() {
        return this.lessonReference;
    }

    public void setLesson(Lesson lesson) {
        this.lessonReference = lesson;
    }

    public Shift getShift() {
        return this.shiftReference;
    }

    public void setShift(Shift shift) {
        this.shiftReference = shift;
    }

    public Space getSummaryRoom() {
        return this.roomReference;
    }

    public void setSummaryRoom(Space room) {
        this.roomReference = room;
    }

    public SummaryType getSummaryType() {
        return this.summaryType;
    }

    public void setSummaryType(SummaryType summaryType) {
        this.summaryType = summaryType;
    }

    public YearMonthDay getSummaryDate() {
        return this.summaryDate;
    }

    public void setSummaryDate(YearMonthDay date) {
        this.summaryDate = date;
    }

    public MultiLanguageString getSummaryText() {
        return this.summaryText;
    }

    public void setSummaryText(MultiLanguageString summary) {
        this.summaryText = summary;
    }

    public MultiLanguageString getTitle() {
        return this.title;
    }

    public void setTitle(MultiLanguageString title) {
        this.title = title;
    }

    public Partial getSummaryTime() {
        return this.summaryTime;
    }

    public void setSummaryTime(Partial hour) {
        this.summaryTime = hour;
    }

    public String getTeacherChoose() {
        if (this.getProfessorship() != null) {
            return this.getProfessorship().getExternalId().toString();
        }
        if (!StringUtils.isEmpty((String)this.getTeacherName())) {
            return "-1";
        }
        if (this.getTeacher() != null) {
            return "0";
        }
        return "";
    }

    public boolean isNewSummary() {
        return this.getSummary() == null;
    }

    public List<NextPossibleSummaryLessonsAndDatesBean> getNextPossibleSummaryLessonsAndDatesBean() {
        return this.nextPossibleSummaryLessonsAndDatesBean;
    }

    public void setNextPossibleSummaryLessonsAndDatesBean(List<NextPossibleSummaryLessonsAndDatesBean> nextPossibleSummaryLessonsAndDatesBean) {
        this.nextPossibleSummaryLessonsAndDatesBean = nextPossibleSummaryLessonsAndDatesBean;
    }

    public ShiftType getLessonType() {
        return this.lessonType;
    }

    public void setLessonType(ShiftType lessonType) {
        this.lessonType = lessonType;
    }

    public void setTaught(Boolean taught) {
        this.taught = taught;
    }

    public Boolean getTaught() {
        return this.taught;
    }

    public static enum SummaryType {
        NORMAL_SUMMARY,
        EXTRA_SUMMARY;


        public String getName() {
            return this.name();
        }
    }
}

