/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.Guide;
import org.fenixedu.academic.domain.masterDegree.GuideRequester;
import org.fenixedu.academic.domain.transactions.PaymentType;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoGuideEntry;
import org.fenixedu.academic.dto.InfoGuideSituation;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoPerson;
import pt.ist.fenixframework.DomainObject;

public class InfoGuide
extends InfoObject {
    private Integer number;
    private Integer year;
    private Double total;
    private String remarks;
    private InfoPerson infoPerson;
    private List<InfoGuideEntry> infoGuideEntries;
    private GuideRequester guideRequester;
    private InfoExecutionDegree infoExecutionDegree;
    private PaymentType paymentType;
    private Date creationDate;
    private Integer version;
    private List infoGuideSituations;
    private InfoGuideSituation infoGuideSituation;
    private Date paymentDate;
    private List infoReimbursementGuides;

    public InfoGuide() {
    }

    public InfoGuide(Integer number, Integer year, Double total, String remarks, InfoPerson infoPerson, GuideRequester guideRequester, InfoExecutionDegree infoExecutionDegree, PaymentType paymentType, Date creationDate, Integer version) {
        this.number = number;
        this.year = year;
        this.total = total;
        this.remarks = remarks;
        this.infoPerson = infoPerson;
        this.guideRequester = guideRequester;
        this.infoExecutionDegree = infoExecutionDegree;
        this.paymentType = paymentType;
        this.creationDate = creationDate;
        this.version = version;
    }

    @Override
    public boolean equals(Object obj) {
        boolean resultado = false;
        if (obj instanceof InfoGuide) {
            InfoGuide guide = (InfoGuide)obj;
            resultado = this.getNumber().equals(guide.getNumber()) && this.getYear().equals(guide.getYear());
        }
        return resultado;
    }

    public String toString() {
        String result = "[INFO_GUIDE";
        result = result + ", number=" + this.number;
        result = result + ", year=" + this.year;
        result = result + ", person=" + this.infoPerson;
        result = result + ", total=" + this.total;
        result = result + ", remarks=" + this.remarks;
        result = result + ", infoGuideEntries=" + this.infoGuideEntries;
        result = result + ", guideRequester=" + (Object)((Object)this.guideRequester);
        result = result + ", infoExecutionDegree=" + this.infoExecutionDegree;
        result = result + ", paymentType=" + (Object)((Object)this.paymentType);
        result = result + ", creationDate=" + this.creationDate;
        result = result + ", version=" + this.version;
        result = result + ", infoGuideSituation=" + this.infoGuideSituation;
        result = result + ", payment Date=" + this.paymentDate;
        result = result + "]";
        return result;
    }

    public GuideRequester getGuideRequester() {
        return this.guideRequester;
    }

    public InfoExecutionDegree getInfoExecutionDegree() {
        return this.infoExecutionDegree;
    }

    public List<InfoGuideEntry> getInfoGuideEntries() {
        return this.infoGuideEntries;
    }

    public InfoPerson getInfoPerson() {
        return this.infoPerson;
    }

    public Integer getNumber() {
        return this.number;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public Double getTotal() {
        return this.total;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setGuideRequester(GuideRequester requester) {
        this.guideRequester = requester;
    }

    public void setInfoExecutionDegree(InfoExecutionDegree degree) {
        this.infoExecutionDegree = degree;
    }

    public void setInfoGuideEntries(List list) {
        this.infoGuideEntries = list;
    }

    public void setInfoPerson(InfoPerson person) {
        this.infoPerson = person;
    }

    public void setNumber(Integer integer) {
        this.number = integer;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    public void setTotal(Double double1) {
        this.total = double1;
    }

    public void setYear(Integer integer) {
        this.year = integer;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType type) {
        this.paymentType = type;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public void setVersion(Integer integer) {
        this.version = integer;
    }

    public List getInfoGuideSituations() {
        return this.infoGuideSituations;
    }

    public void setInfoGuideSituations(List list) {
        this.infoGuideSituations = list;
    }

    public InfoGuideSituation getInfoGuideSituation() {
        return this.infoGuideSituation;
    }

    public void setInfoGuideSituation(InfoGuideSituation situation) {
        this.infoGuideSituation = situation;
    }

    public Date getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(Date date) {
        this.paymentDate = date;
    }

    public List getInfoReimbursementGuides() {
        return this.infoReimbursementGuides;
    }

    public void setInfoReimbursementGuides(List reimbursementGuides) {
        this.infoReimbursementGuides = reimbursementGuides;
    }

    public void copyFromDomain(Guide guide) {
        super.copyFromDomain((DomainObject)guide);
        if (guide != null) {
            this.setCreationDate(guide.getCreationDate());
            this.setNumber(guide.getNumber());
            this.setPaymentDate(guide.getPaymentDate());
            this.setPaymentType(guide.getPaymentType());
            this.setRemarks(guide.getRemarks());
            this.setTotal(guide.getTotal());
            this.setVersion(guide.getVersion());
            this.setYear(guide.getYear());
            this.setGuideRequester(guide.getGuideRequester());
        }
    }

    public static InfoGuide newInfoFromDomain(Guide guide) {
        InfoGuide infoGuide = null;
        if (guide != null) {
            infoGuide = new InfoGuide();
            infoGuide.copyFromDomain(guide);
        }
        return infoGuide;
    }
}

