/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.dto.InfoCampus;
import org.fenixedu.academic.dto.InfoCoordinator;
import org.fenixedu.academic.dto.InfoDegreeCurricularPlan;
import org.fenixedu.academic.dto.InfoExecutionYear;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoPeriod;

public class InfoExecutionDegree
extends InfoObject {
    public static final Comparator<InfoExecutionDegree> COMPARATOR_BY_DEGREE_TYPE_AND_NAME = new Comparator<InfoExecutionDegree>(){

        @Override
        public int compare(InfoExecutionDegree o1, InfoExecutionDegree o2) {
            Degree degree1 = o1.getExecutionDegree().getDegree();
            Degree degree2 = o2.getExecutionDegree().getDegree();
            int c = degree1.getDegreeType().compareTo(degree2.getDegreeType());
            return c == 0 ? degree1.getNome().compareTo(degree2.getName()) : c;
        }
    };
    private final ExecutionDegree executionDegreeDomainReference;
    private String qualifiedName;
    private boolean getNextExecutionYear = false;

    public InfoExecutionDegree(ExecutionDegree executionDegree) {
        this.executionDegreeDomainReference = executionDegree;
    }

    public ExecutionDegree getExecutionDegree() {
        return this.executionDegreeDomainReference;
    }

    public InfoExecutionYear getInfoExecutionYear() {
        return InfoExecutionYear.newInfoFromDomain(this.getNextExecutionYear ? this.getExecutionDegree().getExecutionYear().getNextExecutionYear() : this.getExecutionDegree().getExecutionYear());
    }

    public InfoDegreeCurricularPlan getInfoDegreeCurricularPlan() {
        return InfoDegreeCurricularPlan.newInfoFromDomain(this.getExecutionDegree().getDegreeCurricularPlan());
    }

    public boolean isPublishedExam(ExecutionSemester executionSemester) {
        return this.getExecutionDegree().getPublishedExamMapsSet().contains(executionSemester);
    }

    public InfoCampus getInfoCampus() {
        return InfoCampus.newInfoFromDomain(this.getExecutionDegree().getCampus());
    }

    public List<InfoCoordinator> getCoordinatorsList() {
        ArrayList<InfoCoordinator> infoCoordinators = new ArrayList<InfoCoordinator>();
        for (Coordinator coordinator : this.getExecutionDegree().getCoordinatorsListSet()) {
            infoCoordinators.add(InfoCoordinator.newInfoFromDomain(coordinator));
        }
        return infoCoordinators;
    }

    public InfoPeriod getInfoPeriodExamsFirstSemester() {
        return InfoPeriod.newInfoFromDomain(this.getExecutionDegree().getPeriodExamsFirstSemester());
    }

    public InfoPeriod getInfoPeriodExamsSecondSemester() {
        return InfoPeriod.newInfoFromDomain(this.getExecutionDegree().getPeriodExamsSecondSemester());
    }

    public InfoPeriod getInfoPeriodLessonsFirstSemester() {
        return InfoPeriod.newInfoFromDomain(this.getExecutionDegree().getPeriodLessonsFirstSemester());
    }

    public InfoPeriod getInfoPeriodLessonsSecondSemester() {
        return InfoPeriod.newInfoFromDomain(this.getExecutionDegree().getPeriodLessonsSecondSemester());
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getExecutionDegree() == ((InfoExecutionDegree)obj).getExecutionDegree();
    }

    public String toString() {
        return this.getExecutionDegree().toString();
    }

    public static List buildLabelValueBeansForList(List executionDegrees, MessageResources messageResources) {
        ArrayList copyExecutionDegrees = new ArrayList();
        copyExecutionDegrees.addAll(executionDegrees);
        ArrayList<LabelValueBean> result = new ArrayList<LabelValueBean>();
        for (final InfoExecutionDegree infoExecutionDegree : executionDegrees) {
            String degreeType;
            List equalDegrees = (List)CollectionUtils.select(copyExecutionDegrees, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    InfoExecutionDegree infoExecutionDegreeElem = (InfoExecutionDegree)arg0;
                    return infoExecutionDegree.getInfoDegreeCurricularPlan().getInfoDegree().getSigla().equals(infoExecutionDegreeElem.getInfoDegreeCurricularPlan().getInfoDegree().getSigla());
                }
            });
            if (equalDegrees.size() == 1) {
                copyExecutionDegrees.remove(infoExecutionDegree);
                degreeType = null;
                if (messageResources != null) {
                    degreeType = messageResources.getMessage(infoExecutionDegree.getInfoDegreeCurricularPlan().getInfoDegree().getDegreeType().toString());
                }
                if (degreeType == null) {
                    degreeType = infoExecutionDegree.getInfoDegreeCurricularPlan().getInfoDegree().getDegreeType().toString();
                }
                result.add(new LabelValueBean(degreeType + "  " + infoExecutionDegree.getInfoDegreeCurricularPlan().getInfoDegree().getNome(), infoExecutionDegree.getExternalId().toString()));
                continue;
            }
            degreeType = null;
            if (messageResources != null) {
                degreeType = messageResources.getMessage(infoExecutionDegree.getInfoDegreeCurricularPlan().getInfoDegree().getDegreeType().toString());
            }
            if (degreeType == null) {
                degreeType = infoExecutionDegree.getInfoDegreeCurricularPlan().getInfoDegree().getDegreeType().toString();
            }
            result.add(new LabelValueBean(degreeType + "  " + infoExecutionDegree.getInfoDegreeCurricularPlan().getInfoDegree().getNome() + " - " + infoExecutionDegree.getInfoDegreeCurricularPlan().getName(), infoExecutionDegree.getExternalId().toString()));
        }
        return result;
    }

    public static InfoExecutionDegree newInfoFromDomain(ExecutionDegree executionDegree) {
        return executionDegree == null ? null : new InfoExecutionDegree(executionDegree);
    }

    @Override
    public String getExternalId() {
        return this.getExecutionDegree().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }

    public void setGetNextExecutionYear(boolean getNextExecutionYear) {
        this.getNextExecutionYear = getNextExecutionYear;
    }

    public boolean isBolonhaDegree() {
        return this.getExecutionDegree().isBolonhaDegree();
    }
}

