/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.time.chronologies.durationFields;

import org.fenixedu.academic.domain.time.calendarStructure.AcademicSemesterCE;
import org.fenixedu.academic.domain.time.chronologies.AcademicChronology;
import org.fenixedu.academic.domain.time.chronologies.durationFields.AcademicSemestersDurationFieldType;
import org.joda.time.Chronology;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.FieldUtils;

public class AcademicSemestersDurationField
extends BaseDurationField {
    private final AcademicChronology chronology;

    public AcademicSemestersDurationField(AcademicChronology chronology_) {
        super(AcademicSemestersDurationFieldType.academicSemesters());
        this.chronology = chronology_;
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(AcademicSemestersDurationFieldType.academicSemesters() + " field is unsupported");
    }

    public long add(long instant, int value) {
        int academicSemester = this.chronology.getAcademicSemester(instant);
        if (academicSemester != 0) {
            AcademicSemesterCE academicSemesterCE = this.chronology.getAcademicSemesterIn(academicSemester);
            AcademicSemesterCE academicSemesterCEAfter = this.chronology.getAcademicSemesterIn(academicSemester + value);
            if (academicSemesterCEAfter != null) {
                long result = academicSemesterCEAfter.getBegin().getMillis() + new Duration(academicSemesterCE.getBegin().getMillis(), instant).getMillis();
                return result < academicSemesterCE.getEnd().getMillis() ? result : academicSemesterCE.getEnd().getMillis();
            }
        }
        throw this.unsupported();
    }

    public long add(long instant, long value) {
        return this.add(instant, FieldUtils.safeToInt((long)value));
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        int minuendAcademicSemester = this.chronology.getAcademicSemester(minuendInstant);
        int subtrahendAcademicSemester = this.chronology.getAcademicSemester(subtrahendInstant);
        if (minuendAcademicSemester != 0 && subtrahendAcademicSemester != 0) {
            return minuendAcademicSemester - subtrahendAcademicSemester;
        }
        throw this.unsupported();
    }

    public long getMillis(int value, long instant) {
        int academicSemester = this.chronology.getAcademicSemester(instant);
        if (academicSemester != 0) {
            AcademicSemesterCE academicSemesterCE = this.chronology.getAcademicSemesterIn(academicSemester);
            AcademicSemesterCE academicSemesterCEAfter = this.chronology.getAcademicSemesterIn(academicSemester + value);
            if (academicSemesterCEAfter != null) {
                long result = academicSemesterCEAfter.getBegin().getMillis() + new Duration(academicSemesterCE.getBegin().getMillis(), instant).getMillis();
                return result < academicSemesterCE.getEnd().getMillis() ? result - instant : academicSemesterCE.getEnd().getMillis() - instant;
            }
        }
        throw this.unsupported();
    }

    public long getMillis(long value, long instant) {
        return this.getMillis(FieldUtils.safeToInt((long)value), instant);
    }

    public long getUnitMillis() {
        return DurationFieldType.years().getField((Chronology)this.chronology).getUnitMillis() / 2L;
    }

    public long getValueAsLong(long duration, long instant) {
        int valueBegin = this.chronology.getAcademicSemester(instant);
        int valueEnd = this.chronology.getAcademicSemester(instant + duration);
        if (valueBegin != 0 && valueEnd != 0) {
            return valueEnd - valueBegin;
        }
        throw this.unsupported();
    }

    public boolean isPrecise() {
        return false;
    }
}

