/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.thesis;

import java.text.DecimalFormat;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.accessControl.ScientificCommissionGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisFile_Base;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.DynamicGroup;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.servlets.FileDownloadServlet;

public class ThesisFile
extends ThesisFile_Base {
    public ThesisFile(String filename, String displayName, byte[] content) {
        this.init(displayName, filename, content);
    }

    @Deprecated
    public String getDownloadUrl() {
        return FileDownloadServlet.getDownloadUrl((GenericFile)this);
    }

    public boolean isAccessible(User user) {
        Thesis thesis = this.getThesis();
        if (thesis.isEvaluated() && (thesis.getDocumentsAvailableAfter() == null || thesis.getDocumentsAvailableAfter().isBeforeNow()) && thesis.getVisibility() != null) {
            switch (thesis.getVisibility()) {
                case INTRANET: {
                    return user != null;
                }
                case PUBLIC: {
                    return true;
                }
            }
        }
        return DynamicGroup.get((String)"scientificCouncil").or((Group)ScientificCommissionGroup.get(this.getThesis().getDegree())).isMember(user) || this.getThesisMembers().contains(user);
    }

    private Thesis getThesis() {
        return this.getDissertationThesis() != null ? this.getDissertationThesis() : this.getAbstractThesis();
    }

    private Set<User> getThesisMembers() {
        Set<User> members = this.getThesis().getParticipationsSet().stream().filter(p -> p.getPerson() != null).map(p -> p.getPerson().getUser()).collect(Collectors.toSet());
        members.add(this.getThesis().getStudent().getPerson().getUser());
        return members;
    }

    public void delete() {
        if (!this.getThesis().isWaitingConfirmation()) {
            throw new DomainException("thesis.file.delete.notAllowed", new String[0]);
        }
        this.deleteWithoutStateCheck();
    }

    public void deleteWithoutStateCheck() {
        this.setDissertationThesis(null);
        this.setAbstractThesis(null);
        super.delete();
    }

    public String getPrettyFileSize() {
        long size = this.getSize();
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }
}

