/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcessVersion_Base;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;

public class ConclusionProcessVersion
extends ConclusionProcessVersion_Base {
    private static final Comparator<ConclusionProcessVersion> COMPARATOR_BY_CREATION_DATE_TIME = new Comparator<ConclusionProcessVersion>(){

        @Override
        public int compare(ConclusionProcessVersion o1, ConclusionProcessVersion o2) {
            return o1.getCreationDateTime().compareTo((ReadableInstant)o2.getCreationDateTime());
        }
    };
    public static final Comparator<ConclusionProcessVersion> COMPARATOR_BY_CREATION_DATE_TIME_AND_ID = new Comparator<ConclusionProcessVersion>(){

        @Override
        public final int compare(ConclusionProcessVersion o1, ConclusionProcessVersion o2) {
            ComparatorChain chain = new ComparatorChain();
            chain.addComparator(COMPARATOR_BY_CREATION_DATE_TIME);
            chain.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
            return chain.compare((Object)o1, (Object)o2);
        }
    };

    protected ConclusionProcessVersion(RegistrationConclusionBean bean) {
        super.setRootDomainObject(Bennu.getInstance());
        super.setCreationDateTime(new DateTime());
        super.setResponsible(AccessControl.getPerson());
        YearMonthDay conclusion = bean.calculateConclusionDate();
        Grade finalGrade = bean.getCalculatedFinalGrade();
        Grade rawGrade = bean.getCalculatedRawGrade();
        Double ectsCredits = bean.calculateCredits();
        ExecutionYear ingressionYear = bean.calculateIngressionYear();
        ExecutionYear conclusionYear = bean.calculateConclusionYear();
        if (finalGrade == null || rawGrade == null || ectsCredits == null || ingressionYear == null || conclusionYear == null) {
            throw new DomainException("error.ConclusionProcessVersion.argument.must.not.be.null", new String[0]);
        }
        super.setConclusionDate(conclusion.toLocalDate());
        super.setFinalGrade(finalGrade);
        super.setRawGrade(rawGrade);
        super.setCredits(BigDecimal.valueOf(ectsCredits));
        super.setCurriculum(bean.getCurriculumForConclusion().toString());
        super.setIngressionYear(ingressionYear);
        super.setConclusionYear(conclusionYear);
        super.setActive(true);
    }

    protected void update(Person responsible, Grade finalGrade, Grade rawGrade, Grade descriptiveGrade, LocalDate conclusionDate, String notes) {
        if (finalGrade == null || rawGrade == null || conclusionDate == null) {
            throw new DomainException("error.ConclusionProcessVersion.argument.must.not.be.null", new String[0]);
        }
        super.setResponsible(responsible);
        super.setFinalGrade(finalGrade);
        super.setRawGrade(rawGrade);
        super.setDescriptiveGrade(descriptiveGrade);
        super.setConclusionDate(conclusionDate);
        super.setNotes(StringUtils.isEmpty((String)notes) ? null : notes);
    }

    public Enrolment getDissertationEnrolment() {
        return super.getDissertationEnrolment();
    }

    public Grade getRawGrade() {
        return super.getRawGrade();
    }

    public Grade getFinalGrade() {
        return super.getFinalGrade();
    }

    public Grade getDescriptiveGrade() {
        return super.getDescriptiveGrade();
    }

    public void setConclusionProcess(ConclusionProcess conclusionProcess) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public void setLastVersionConclusionProcess(ConclusionProcess lastVersionConclusionProcess) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public void setRootDomainObject(Bennu rootDomainObject) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public void setResponsible(Person responsible) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public void setConclusionDate(LocalDate conclusionDate) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public void setCredits(BigDecimal credits) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public void setCurriculum(String curriculum) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public void setIngressionYear(ExecutionYear ingressionYear) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public void setConclusionYear(ExecutionYear conclusionYear) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public void setNotes(String notes) {
        throw new DomainException("error.ConclusionProcessVersion.method.not.allowed", new String[0]);
    }

    public boolean isActive() {
        return super.getActive();
    }

    public void setActive(boolean active) {
        super.setActive(active);
    }

    @Deprecated
    public Date getCreation() {
        DateTime dt = this.getCreationDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setCreation(Date date) {
        if (date == null) {
            this.setCreationDateTime(null);
        } else {
            this.setCreationDateTime(new DateTime(date.getTime()));
        }
    }
}

