/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.reports.EctsLabelCurricularCourseReportFile_Base;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class EctsLabelCurricularCourseReportFile
extends EctsLabelCurricularCourseReportFile_Base {
    public String getJobName() {
        return "Listagem para ECTS LABEL Disciplinas";
    }

    protected String getPrefix() {
        return "ectsLabel_Disciplinas";
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        this.createEctsLabelCurricularCoursesHeader(spreadsheet);
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!EctsLabelCurricularCourseReportFile.checkDegreeType((DegreeType)this.getDegreeType(), (Degree)degree)) continue;
            for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
                if (!EctsLabelCurricularCourseReportFile.checkExecutionYear((ExecutionYear)this.getExecutionYear(), (DegreeCurricularPlan)degreeCurricularPlan)) continue;
                for (CurricularCourse curricularCourse : degreeCurricularPlan.getAllCurricularCourses()) {
                    if (!EctsLabelCurricularCourseReportFile.checkExecutionYear((ExecutionYear)this.getExecutionYear(), (CurricularCourse)curricularCourse) || curricularCourse.isOptionalCurricularCourse()) continue;
                    for (Context context : curricularCourse.getParentContextsByExecutionYear(this.getExecutionYear())) {
                        this.addEctsLabelContextRow(spreadsheet, context, this.getExecutionYear());
                    }
                }
            }
        }
    }

    private void createEctsLabelCurricularCoursesHeader(Spreadsheet spreadsheet) {
        spreadsheet.setHeader("Tipo Curso");
        spreadsheet.setHeader("Nome Curso");
        spreadsheet.setHeader("Sigla Curso");
        spreadsheet.setHeader("Nome Disciplina");
        spreadsheet.setHeader("Nome Disciplina (ingl\u00eas)");
        spreadsheet.setHeader("C\u00f3digo Disciplina");
        spreadsheet.setHeader("Ano curricular");
        spreadsheet.setHeader("Semestre");
        spreadsheet.setHeader("Dura\u00e7\u00e3o");
        spreadsheet.setHeader("Tipo");
        spreadsheet.setHeader("Cr\u00e9ditos ECTS");
        spreadsheet.setHeader("Idioma");
        spreadsheet.setHeader("Docentes");
        spreadsheet.setHeader("Horas de contacto");
        spreadsheet.setHeader("Objectivos");
        spreadsheet.setHeader("Objectivos (ingl\u00eas)");
        spreadsheet.setHeader("Programa");
        spreadsheet.setHeader("Programa (ingl\u00eas)");
        spreadsheet.setHeader("Bibliografia Principal");
        spreadsheet.setHeader("Bibliografia Secund\u00e1ria (ingl\u00eas)");
        spreadsheet.setHeader("Avalia\u00e7\u00e3o");
        spreadsheet.setHeader("Avalia\u00e7\u00e3o (ingl\u00eas)");
        spreadsheet.setHeader("Estimativa total de trabalho");
    }

    private void addEctsLabelContextRow(Spreadsheet spreadsheet, Context context, ExecutionYear executionYear) {
        Spreadsheet.Row row = spreadsheet.addRow();
        ExecutionSemester executionSemester = this.getExecutionSemester(context, executionYear);
        CurricularCourse curricular = (CurricularCourse)((Object)context.getChildDegreeModule());
        row.setCell(curricular.getDegree().getDegreeType().getName().getContent());
        row.setCell(curricular.getDegree().getNameFor(executionSemester).getContent());
        row.setCell(curricular.getDegree().getSigla());
        row.setCell(curricular.getName(executionSemester));
        row.setCell(curricular.getNameEn(executionSemester));
        CompetenceCourse competenceCourse = curricular.getCompetenceCourse();
        if (competenceCourse != null) {
            row.setCell(competenceCourse.getAcronym(executionSemester));
        } else {
            row.setCell("");
        }
        row.setCell(context.getCurricularYear());
        this.setSemesterAndDuration(row, context);
        row.setCell(curricular.hasCompetenceCourseLevel() ? curricular.getCompetenceCourseLevel().getLocalizedName() : "");
        row.setCell(curricular.getEctsCredits(executionSemester));
        row.setCell(this.getLanguage(curricular));
        row.setCell(this.getTeachers(curricular, executionSemester));
        row.setCell(curricular.getContactLoad(context.getCurricularPeriod(), executionSemester));
        row.setCell(this.normalize(curricular.getObjectives(executionSemester)));
        row.setCell(this.normalize(curricular.getObjectivesEn(executionSemester)));
        row.setCell(this.normalize(curricular.getProgram(executionSemester)));
        row.setCell(this.normalize(curricular.getProgramEn(executionSemester)));
        BibliographicReferences references = this.getBibliographicReferences(curricular, executionSemester);
        if (references == null) {
            row.setCell(" ");
            row.setCell(" ");
        } else {
            row.setCell(this.normalize(this.getBibliographicReferences(references.getMainBibliographicReferences())));
            row.setCell(this.normalize(this.getBibliographicReferences(references.getSecondaryBibliographicReferences())));
        }
        row.setCell(this.normalize(curricular.getEvaluationMethod(executionSemester)));
        row.setCell(this.normalize(curricular.getEvaluationMethodEn(executionSemester)));
        row.setCell(curricular.getTotalLoad(context.getCurricularPeriod(), executionSemester));
    }

    private String getLanguage(CurricularCourse curricularCourse) {
        DegreeType degreeType = curricularCourse.getDegreeType();
        if (degreeType.hasExactlyOneCycleType() && degreeType.getCycleType() == CycleType.FIRST_CYCLE) {
            return "Portugu\u00eas";
        }
        return "Portugu\u00eas/Ingl\u00eas";
    }

    private String getTeachers(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        StringBuilder builder = new StringBuilder();
        for (ExecutionCourse executionCourse : curricularCourse.getExecutionCoursesByExecutionPeriod(executionSemester)) {
            for (Professorship professorship : executionCourse.getProfessorshipsSortedAlphabetically()) {
                builder.append(professorship.getPerson().getName()).append("; ");
            }
        }
        return builder.toString();
    }

    private BibliographicReferences getBibliographicReferences(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
        return competenceCourse == null ? null : competenceCourse.getBibliographicReferences(executionSemester);
    }

    private String getBibliographicReferences(List<BibliographicReferences.BibliographicReference> references) {
        Collections.sort(references);
        StringBuilder stringBuilder = new StringBuilder();
        for (BibliographicReferences.BibliographicReference bibliographicReference : references) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(bibliographicReference.getTitle());
            stringBuilder.append(", ");
            stringBuilder.append(bibliographicReference.getAuthors());
            stringBuilder.append(", ");
            stringBuilder.append(bibliographicReference.getYear());
            stringBuilder.append(", ");
            stringBuilder.append(bibliographicReference.getReference());
        }
        return stringBuilder.toString();
    }

    private ExecutionSemester getExecutionSemester(Context context, ExecutionYear executionYear) {
        CurricularPeriod curricularPeriod = context.getCurricularPeriod();
        if (curricularPeriod.getAcademicPeriod().getName().equals("SEMESTER")) {
            return curricularPeriod.getChildOrder() == 1 ? executionYear.getFirstExecutionPeriod() : executionYear.getLastExecutionPeriod();
        }
        return executionYear.getFirstExecutionPeriod();
    }

    private void setSemesterAndDuration(Spreadsheet.Row row, Context context) {
        CurricularPeriod curricularPeriod = context.getCurricularPeriod();
        if (curricularPeriod.getAcademicPeriod().getName().equals("SEMESTER")) {
            row.setCell(curricularPeriod.getChildOrder());
            row.setCell("Semestral");
        } else {
            row.setCell(" ");
            row.setCell("Anual");
        }
    }
}

