/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixWebFramework.rendererExtensions.util.IPresentableEnum;

public enum PhdThesisFinalGrade implements IPresentableEnum
{
    NOT_APPROVED(true, false),
    APPROVED(true, true),
    APPROVED_WITH_PLUS(true, true),
    APPROVED_WITH_PLUS_PLUS(true, true),
    PRE_BOLONHA_NOT_APPROVED(true, false),
    PRE_BOLONHA_APPROVED(false, true),
    PRE_BOLONHA_APPROVED_WITH_PLUS(false, true),
    PRE_BOLONHA_APPROVED_WITH_PLUS_PLUS(false, true);

    private boolean forBolonha;
    private boolean approved;

    private PhdThesisFinalGrade(boolean forBolonha, boolean approved) {
        this.forBolonha = forBolonha;
        this.approved = approved;
    }

    public String getName() {
        return this.name();
    }

    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    public String getQualifiedName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
    }

    public boolean isForBolonha() {
        return this.forBolonha;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public static List<PhdThesisFinalGrade> getGradesForBolonha() {
        ArrayList<PhdThesisFinalGrade> values = new ArrayList<PhdThesisFinalGrade>();
        for (PhdThesisFinalGrade grade : PhdThesisFinalGrade.values()) {
            if (!grade.isForBolonha()) continue;
            values.add(grade);
        }
        return values;
    }

    public static List<PhdThesisFinalGrade> getGradesForPreBolonha() {
        ArrayList<PhdThesisFinalGrade> values = new ArrayList<PhdThesisFinalGrade>();
        for (PhdThesisFinalGrade grade : PhdThesisFinalGrade.values()) {
            if (grade.isForBolonha()) continue;
            values.add(grade);
        }
        return values;
    }
}

