/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdCandidacyProcessState;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProcessState;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.PhdProgramProcess_Base;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;

public abstract class PhdProgramProcess
extends PhdProgramProcess_Base {
    public static final Predicate<PhdProgramProcess> IS_ALLOWED_TO_MANAGE_PROCESS_PREDICATE = new Predicate<PhdProgramProcess>(){

        public boolean apply(PhdProgramProcess process2) {
            return process2.isAllowedToManageProcess(Authenticate.getUser());
        }
    };

    protected PhdProgramProcess() {
    }

    public PhdProgramProcessDocument addDocument(PhdProgramDocumentUploadBean each, Person responsible) {
        return new PhdProgramProcessDocument(this, each.getType(), each.getRemarks(), each.getFileContent(), each.getFilename(), responsible);
    }

    protected void addDocuments(List<PhdProgramDocumentUploadBean> documents, Person responsible) {
        for (PhdProgramDocumentUploadBean each : documents) {
            this.addDocument(each, responsible);
        }
    }

    private Set<PhdProgramProcessDocument> getDocumentsByType(PhdIndividualProgramDocumentType type) {
        HashSet<PhdProgramProcessDocument> result = new HashSet<PhdProgramProcessDocument>();
        for (PhdProgramProcessDocument document : this.getDocumentsSet()) {
            if (document.getDocumentType() != type) continue;
            result.add(document);
        }
        return result;
    }

    protected Set<PhdProgramProcessDocument> filterLatestDocumentVersions(Collection<PhdProgramProcessDocument> documentsToFilter) {
        HashSet<PhdProgramProcessDocument> result = new HashSet<PhdProgramProcessDocument>();
        for (PhdProgramProcessDocument document : documentsToFilter) {
            if (!document.getDocumentAccepted().booleanValue()) continue;
            result.add(document.getLastVersion());
        }
        return result;
    }

    public Set<PhdProgramProcessDocument> getLatestDocumentsByType(PhdIndividualProgramDocumentType type) {
        HashSet<PhdProgramProcessDocument> documents = new HashSet<PhdProgramProcessDocument>();
        for (PhdProgramProcessDocument document : this.getDocumentsSet()) {
            if (document.getDocumentType() != type) continue;
            documents.add(document);
        }
        return this.filterLatestDocumentVersions(documents);
    }

    public Integer getLastVersionNumber(PhdIndividualProgramDocumentType type) {
        Set<PhdProgramProcessDocument> documentsByType = this.getDocumentsByType(type);
        return documentsByType.isEmpty() ? 0 : documentsByType.size();
    }

    public Set<PhdProgramProcessDocument> getAllDocumentVersionsOfType(PhdIndividualProgramDocumentType type) {
        return this.getDocumentsByType(type);
    }

    public PhdProgramProcessDocument getLatestDocumentVersionFor(PhdIndividualProgramDocumentType type) {
        if (!type.isVersioned()) {
            throw new DomainException("error.PhdProgramProcess.latest.document.version.method.only.for.versioned.types", new String[0]);
        }
        TreeSet<PhdProgramProcessDocument> documents = new TreeSet<PhdProgramProcessDocument>(PhdProgramProcessDocument.COMPARATOR_BY_VERSION);
        for (PhdProgramProcessDocument document : this.getDocumentsByType(type)) {
            if (!document.getDocumentAccepted().booleanValue()) continue;
            documents.add(document);
        }
        return documents.isEmpty() ? null : (PhdProgramProcessDocument)((Object)documents.iterator().next());
    }

    public Set<PhdProgramProcessDocument> getLatestDocumentVersions() {
        return this.filterLatestDocumentVersions(this.getDocumentsSet());
    }

    public Set<PhdProgramProcessDocument> getLatestDocumentVersionsAvailableToStudent() {
        Collection<PhdIndividualProgramDocumentType> documentTypesVisibleToStudent = PhdIndividualProgramDocumentType.getDocumentTypesVisibleToStudent();
        HashSet<PhdProgramProcessDocument> documents = new HashSet<PhdProgramProcessDocument>();
        for (PhdProgramProcessDocument document : this.getDocumentsSet()) {
            if (!documentTypesVisibleToStudent.contains((Object)document.getDocumentType())) continue;
            documents.add(document);
        }
        return this.filterLatestDocumentVersions(documents);
    }

    public static boolean isParticipant(PhdProgramProcess process2, User userView) {
        return process2.isAllowedToManageProcess(userView) || process2.getIndividualProgramProcess().isCoordinatorForPhdProgram(userView.getPerson()) || process2.getIndividualProgramProcess().isGuiderOrAssistentGuider(userView.getPerson()) || process2.getIndividualProgramProcess().getPerson() == userView.getPerson() || process2.getIndividualProgramProcess().isParticipant(userView.getPerson());
    }

    public PhdProcessState getMostRecentState() {
        return this.hasAnyStates() ? Collections.max(this.getStates(), PhdProcessState.COMPARATOR_BY_DATE) : null;
    }

    public abstract boolean hasAnyStates();

    public abstract Collection<? extends PhdProcessState> getStates();

    public Collection<? extends PhdProcessState> getOrderedStates() {
        ArrayList<? extends PhdProcessState> states = new ArrayList<PhdProcessState>(this.getStates());
        Collections.sort(states, PhdProcessState.COMPARATOR_BY_DATE);
        return states;
    }

    public List<PhdProcessState> getOrderedStatesByType(PhdProcessStateType type) {
        ArrayList<PhdProcessState> result = new ArrayList<PhdProcessState>();
        Collection<? extends PhdProcessState> orderedStates = this.getOrderedStates();
        for (PhdProcessState phdProcessState : orderedStates) {
            if (!type.equals(phdProcessState.getType())) continue;
            result.add(phdProcessState);
        }
        return result;
    }

    public PhdProcessState getMostRecentStateByType(PhdProcessStateType type) {
        List<PhdProcessState> orderedStatesByType = this.getOrderedStatesByType(type);
        Collections.reverse(orderedStatesByType);
        if (orderedStatesByType.isEmpty()) {
            return null;
        }
        return orderedStatesByType.iterator().next();
    }

    public PhdProcessStateType getActiveState() {
        PhdProcessState state = this.getMostRecentState();
        return state != null ? state.getType() : null;
    }

    public String getActiveStateRemarks() {
        return this.getMostRecentState().getRemarks();
    }

    public boolean hasState(PhdProcessStateType type) {
        ArrayList<? extends PhdProcessState> states = new ArrayList<PhdProcessState>(this.getStates());
        Collections.sort(states, PhdCandidacyProcessState.COMPARATOR_BY_DATE);
        for (PhdProcessState phdProcessState : states) {
            if (!phdProcessState.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    protected abstract PhdIndividualProgramProcess getIndividualProgramProcess();

    protected abstract Person getPerson();

    protected abstract boolean isAllowedToManageProcess(User var1);

    public boolean isProcessCandidacy() {
        return false;
    }

    public boolean isProcessIndividualProgram() {
        return false;
    }

    public boolean isProcessThesis() {
        return false;
    }

    public boolean isProcessPublicPresentationSeminar() {
        return false;
    }
}

