/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExternalCurricularCourse;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitName;
import org.fenixedu.bennu.core.domain.Bennu;

public abstract class AcademicalInstitutionUnit
extends AcademicalInstitutionUnit_Base {
    public boolean isAcademicalUnit() {
        return true;
    }

    public void setAcronym(String acronym) {
        if (StringUtils.isEmpty((String)acronym)) {
            throw new DomainException("error.unit.empty.acronym", new String[0]);
        }
        super.setAcronym(acronym);
    }

    public List<ExternalCurricularCourse> getAllExternalCurricularCourses() {
        ArrayList<ExternalCurricularCourse> result = new ArrayList<ExternalCurricularCourse>(this.getExternalCurricularCoursesSet());
        for (Unit subUnit : this.getSubUnits()) {
            if (!subUnit.isDepartmentUnit()) continue;
            result.addAll(subUnit.getExternalCurricularCoursesSet());
        }
        return result;
    }

    public Boolean isOfficial() {
        return this.getOfficial() != null && this.getOfficial().equals(Boolean.TRUE);
    }

    public Boolean isOfficialAndIsType(AcademicalInstitutionType type) {
        return this.isOfficial() != false && this.getInstitutionType() != null && this.getInstitutionType().equals((Object)type);
    }

    protected static List<AcademicalInstitutionUnit> readOfficialUnits() {
        ArrayList<AcademicalInstitutionUnit> officialUnits = new ArrayList<AcademicalInstitutionUnit>();
        for (UnitName unitName : Bennu.getInstance().getUnitNameSet()) {
            if (!unitName.getUnit().isOfficial().booleanValue()) continue;
            officialUnits.add((AcademicalInstitutionUnit)((Object)unitName.getUnit()));
        }
        return officialUnits;
    }

    public static List<AcademicalInstitutionUnit> readOfficialParentUnitsByType(AcademicalInstitutionType type) {
        ArrayList<AcademicalInstitutionUnit> parentUnits = new ArrayList<AcademicalInstitutionUnit>();
        CountryUnit countryUnit = CountryUnit.getDefault();
        for (AcademicalInstitutionUnit unit : AcademicalInstitutionUnit.readOfficialUnits()) {
            if (!unit.hasParentUnit((Unit)((Object)countryUnit)).booleanValue() || !unit.isOfficialAndIsType(type).booleanValue()) continue;
            parentUnits.add(unit);
        }
        return parentUnits;
    }

    public static List<Unit> readOfficialChildUnits(AcademicalInstitutionUnit parentUnit) {
        ArrayList<Unit> childUnits = new ArrayList<Unit>();
        for (AcademicalInstitutionUnit unit : AcademicalInstitutionUnit.readOfficialUnits()) {
            if (!unit.hasParentUnit((Unit)((Object)parentUnit)).booleanValue()) continue;
            childUnits.add((Unit)((Object)unit));
        }
        return childUnits;
    }

    public static List<AcademicalInstitutionUnit> readOtherAcademicUnits() {
        ArrayList<AcademicalInstitutionUnit> otherUnits = new ArrayList<AcademicalInstitutionUnit>();
        for (UnitName unitName : Bennu.getInstance().getUnitNameSet()) {
            if (!unitName.getUnit().isAcademicalUnit() || unitName.getUnit().isOfficial().booleanValue()) continue;
            otherUnits.add((AcademicalInstitutionUnit)((Object)unitName.getUnit()));
        }
        return otherUnits;
    }

    public Boolean hasAnyOfficialChilds() {
        for (AcademicalInstitutionUnit unit : AcademicalInstitutionUnit.readOfficialUnits()) {
            if (!unit.hasParentUnit((Unit)((Object)this)).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public abstract String getFullPresentationName();
}

