/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusApplyForSemesterType;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.TypeOfProgramme;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.TypeOfProgrammeList;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityStudentData;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.joda.time.LocalDate;

public class MobilityStudentDataBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String homeInstitutionName;
    private String homeInstitutionAddress;
    private String homeInstitutionExchangeCoordinatorName;
    private String homeInstitutionPhone;
    private String homeInstitutionFax;
    private String homeInstitutionEmail;
    private Country countryWhereFinishedHighSchoolLevel;
    private SchoolLevelType currentSchoolLevel;
    private String currentOtherSchoolLevel;
    private Boolean hasDiplomaOrDegree;
    private Integer diplomaConclusionYear;
    private String diplomaName;
    private Boolean experienceCarryingOutProject;
    private LocalDate dateOfArrival;
    private LocalDate dateOfDeparture;
    List<TypeOfProgramme> typesOfProgramme;
    private String mainSubjectThesis;
    private Boolean hasContactedOtherStaff;
    private String nameOfContact;
    private UniversityUnit selectedUniversity;
    private Country selectedCountry;
    private MobilityProgram selectedMobilityProgram;
    private MobilityAgreement mobilityAgreement;
    private SchoolLevelType schoolLevel;
    private String otherSchoolLevel;
    private CandidacyProcess parentProcess;
    private Boolean ptStudyingLanguage;
    private Boolean ptAbleFollowLecures;
    private Boolean ptAbleToFollowLectureWithExtraPreparation;
    private Boolean enStudyingLanguage;
    private Boolean enAbleFollowLecures;
    private Boolean enAbleToFollowLectureWithExtraPreparation;
    private Boolean intensivePortugueseCourseSeptember;
    private Boolean intensivePortugueseCourseFebruary;
    private ErasmusApplyForSemesterType applyFor;

    public MobilityStudentDataBean(CandidacyProcess process2, ErasmusApplyForSemesterType applyFor) {
        this.setParentProcess(process2);
        this.setApplyFor(applyFor);
    }

    public MobilityStudentDataBean(MobilityStudentData erasmusStudentData) {
        this.setDateOfArrival(erasmusStudentData.getDateOfArrival());
        this.setDateOfDeparture(erasmusStudentData.getDateOfDeparture());
        this.setDiplomaConclusionYear(erasmusStudentData.getDiplomaConclusionYear());
        this.setDiplomaName(erasmusStudentData.getDiplomaName());
        this.setExperienceCarryingOutProject(erasmusStudentData.getExperienceCarryingOutProject());
        this.setHasContactedOtherStaff(erasmusStudentData.getHasContactedOtherStaff());
        this.setCurrentSchoolLevel(erasmusStudentData.getCurrentSchoolLevel());
        this.setCurrentOtherSchoolLevel(erasmusStudentData.getCurrentOtherSchoolLevel());
        this.setHasDiplomaOrDegree(erasmusStudentData.getHasDiplomaOrDegree());
        this.setHomeInstitutionAddress(erasmusStudentData.getHomeInstitutionAddress());
        this.setHomeInstitutionEmail(erasmusStudentData.getHomeInstitutionEmail());
        this.setHomeInstitutionExchangeCoordinatorName(erasmusStudentData.getHomeInstitutionCoordinatorName());
        this.setHomeInstitutionFax(erasmusStudentData.getHomeInstitutionFax());
        this.setHomeInstitutionName(erasmusStudentData.getHomeInstitutionName());
        this.setHomeInstitutionPhone(erasmusStudentData.getHomeInstitutionPhone());
        this.setCountryWhereFinishedHighSchoolLevel(erasmusStudentData.getMobilityCountryHighSchool());
        this.setMainSubjectThesis(erasmusStudentData.getMainSubjectThesis());
        this.setNameOfContact(erasmusStudentData.getNameOfContact());
        this.setTypesOfProgramme(erasmusStudentData.getTypesOfProgramme());
        this.setSelectedUniversity(erasmusStudentData.getSelectedOpening() != null ? erasmusStudentData.getSelectedOpening().getMobilityAgreement().getUniversityUnit() : null);
        this.setSelectedCountry(erasmusStudentData.getSelectedOpening() != null ? erasmusStudentData.getSelectedOpening().getMobilityAgreement().getUniversityUnit().getCountry() : null);
        this.setParentProcess(erasmusStudentData.getMobilityIndividualApplication().getCandidacyProcess().getCandidacyProcess());
        this.setSelectedMobilityProgram(erasmusStudentData.getSelectedOpening().getMobilityAgreement().getMobilityProgram());
        this.setPtStudyingLanguage(erasmusStudentData.getPtStudyingLanguage());
        this.setPtAbleFollowLecures(erasmusStudentData.getPtAbleFollowLecures());
        this.setPtAbleToFollowLectureWithExtraPreparation(erasmusStudentData.getPtAbleToFollowLectureWithExtraPreparation());
        this.setEnStudyingLanguage(erasmusStudentData.getEnStudyingLanguage());
        this.setEnAbleFollowLecures(erasmusStudentData.getEnAbleFollowLecures());
        this.setEnAbleToFollowLectureWithExtraPreparation(erasmusStudentData.getEnAbleToFollowLectureWithExtraPreparation());
        this.setIntensivePortugueseCourseSeptember(erasmusStudentData.getIntensivePortugueseCourseSeptember());
        this.setIntensivePortugueseCourseFebruary(erasmusStudentData.getIntensivePortugueseCourseFebruary());
        this.setApplyFor(erasmusStudentData.getApplyFor());
    }

    private void setTypesOfProgramme(TypeOfProgrammeList typesOfProgramme) {
        this.typesOfProgramme = new ArrayList<TypeOfProgramme>(typesOfProgramme.getTypes());
    }

    public String getHomeInstitutionName() {
        return this.homeInstitutionName;
    }

    public void setHomeInstitutionName(String homeInstitutionName) {
        this.homeInstitutionName = homeInstitutionName;
    }

    public String getHomeInstitutionAddress() {
        return this.homeInstitutionAddress;
    }

    public void setHomeInstitutionAddress(String homeInstitutionAddress) {
        this.homeInstitutionAddress = homeInstitutionAddress;
    }

    public String getHomeInstitutionExchangeCoordinatorName() {
        return this.homeInstitutionExchangeCoordinatorName;
    }

    public void setHomeInstitutionExchangeCoordinatorName(String homeInstitutionExchangeCoordinatorName) {
        this.homeInstitutionExchangeCoordinatorName = homeInstitutionExchangeCoordinatorName;
    }

    public String getHomeInstitutionPhone() {
        return this.homeInstitutionPhone;
    }

    public void setHomeInstitutionPhone(String homeInstitutionPhone) {
        this.homeInstitutionPhone = homeInstitutionPhone;
    }

    public String getHomeInstitutionFax() {
        return this.homeInstitutionFax;
    }

    public void setHomeInstitutionFax(String homeInstitutionFax) {
        this.homeInstitutionFax = homeInstitutionFax;
    }

    public String getHomeInstitutionEmail() {
        return this.homeInstitutionEmail;
    }

    public void setHomeInstitutionEmail(String homeInstitutionEmail) {
        this.homeInstitutionEmail = homeInstitutionEmail;
    }

    public Country getCountryWhereFinishedHighSchoolLevel() {
        return this.countryWhereFinishedHighSchoolLevel;
    }

    public void setCountryWhereFinishedHighSchoolLevel(Country countryHighSchool) {
        this.countryWhereFinishedHighSchoolLevel = countryHighSchool;
    }

    public SchoolLevelType getCurrentSchoolLevel() {
        return this.currentSchoolLevel;
    }

    public void setCurrentSchoolLevel(SchoolLevelType currentSchoolLevel) {
        this.currentSchoolLevel = currentSchoolLevel;
    }

    public String getCurrentOtherSchoolLevel() {
        return this.currentOtherSchoolLevel;
    }

    public void setCurrentOtherSchoolLevel(String currentOtherSchoolLevel) {
        this.currentOtherSchoolLevel = currentOtherSchoolLevel;
    }

    public Boolean getHasDiplomaOrDegree() {
        return this.hasDiplomaOrDegree;
    }

    public void setHasDiplomaOrDegree(Boolean hasDiplomaOrDegree) {
        this.hasDiplomaOrDegree = hasDiplomaOrDegree;
    }

    public Integer getDiplomaConclusionYear() {
        return this.diplomaConclusionYear;
    }

    public void setDiplomaConclusionYear(Integer diplomaConclusionYear) {
        this.diplomaConclusionYear = diplomaConclusionYear;
    }

    public String getDiplomaName() {
        return this.diplomaName;
    }

    public void setDiplomaName(String diplomaName) {
        this.diplomaName = diplomaName;
    }

    public Boolean getExperienceCarryingOutProject() {
        return this.experienceCarryingOutProject;
    }

    public void setExperienceCarryingOutProject(Boolean experienceCarryingOutProject) {
        this.experienceCarryingOutProject = experienceCarryingOutProject;
    }

    public LocalDate getDateOfArrival() {
        return this.dateOfArrival;
    }

    public void setDateOfArrival(LocalDate dateOfArrival) {
        this.dateOfArrival = dateOfArrival;
    }

    public LocalDate getDateOfDeparture() {
        return this.dateOfDeparture;
    }

    public void setDateOfDeparture(LocalDate dateOfDeparture) {
        this.dateOfDeparture = dateOfDeparture;
    }

    public List<TypeOfProgramme> getTypesOfProgramme() {
        return this.typesOfProgramme;
    }

    public void setTypesOfProgramme(List<TypeOfProgramme> typesOfProgramme) {
        this.typesOfProgramme = typesOfProgramme;
    }

    public TypeOfProgrammeList getTypeOfProgrammeList() {
        return new TypeOfProgrammeList(this.typesOfProgramme);
    }

    public String getMainSubjectThesis() {
        return this.mainSubjectThesis;
    }

    public void setMainSubjectThesis(String mainSubjectThesis) {
        this.mainSubjectThesis = mainSubjectThesis;
    }

    public Boolean getHasContactedOtherStaff() {
        return this.hasContactedOtherStaff;
    }

    public void setHasContactedOtherStaff(Boolean hasContactedOtherStaff) {
        this.hasContactedOtherStaff = hasContactedOtherStaff;
    }

    public String getNameOfContact() {
        return this.nameOfContact;
    }

    public void setNameOfContact(String nameOfContact) {
        this.nameOfContact = nameOfContact;
    }

    public UniversityUnit getSelectedUniversity() {
        return this.selectedUniversity;
    }

    public void setSelectedUniversity(UniversityUnit unit) {
        this.selectedUniversity = unit;
    }

    public Country getSelectedCountry() {
        return this.selectedCountry;
    }

    public void setSelectedCountry(Country selectedCountry) {
        this.selectedCountry = selectedCountry;
    }

    public MobilityProgram getSelectedMobilityProgram() {
        return this.selectedMobilityProgram;
    }

    public void setSelectedMobilityProgram(MobilityProgram selectedMobilityProgram) {
        this.selectedMobilityProgram = selectedMobilityProgram;
        this.setMobilityAgreement();
    }

    public MobilityAgreement getMobilityAgreement() {
        return this.mobilityAgreement;
    }

    public void setMobilityAgreement() {
        if (this.selectedMobilityProgram == null || this.selectedUniversity == null) {
            this.mobilityAgreement = null;
            return;
        }
        for (MobilityAgreement agreement : this.selectedMobilityProgram.getMobilityAgreementsSet()) {
            if (agreement.getUniversityUnit() != this.getSelectedUniversity()) continue;
            this.mobilityAgreement = agreement;
            return;
        }
        this.mobilityAgreement = null;
    }

    public CandidacyProcess getParentProcess() {
        return this.parentProcess;
    }

    public void setParentProcess(CandidacyProcess parentProcess) {
        this.parentProcess = parentProcess;
    }

    public Boolean getPtStudyingLanguage() {
        return this.ptStudyingLanguage;
    }

    public void setPtStudyingLanguage(Boolean ptStudyingLanguage) {
        this.ptStudyingLanguage = ptStudyingLanguage;
    }

    public Boolean getPtAbleFollowLecures() {
        return this.ptAbleFollowLecures;
    }

    public void setPtAbleFollowLecures(Boolean ptAbleFollowLecures) {
        this.ptAbleFollowLecures = ptAbleFollowLecures;
    }

    public Boolean getPtAbleToFollowLectureWithExtraPreparation() {
        return this.ptAbleToFollowLectureWithExtraPreparation;
    }

    public void setPtAbleToFollowLectureWithExtraPreparation(Boolean ptAbleToFollowLectureWithExtraPreparation) {
        this.ptAbleToFollowLectureWithExtraPreparation = ptAbleToFollowLectureWithExtraPreparation;
    }

    public Boolean getEnStudyingLanguage() {
        return this.enStudyingLanguage;
    }

    public void setEnStudyingLanguage(Boolean enStudyingLanguage) {
        this.enStudyingLanguage = enStudyingLanguage;
    }

    public Boolean getEnAbleFollowLecures() {
        return this.enAbleFollowLecures;
    }

    public void setEnAbleFollowLecures(Boolean enAbleFollowLecures) {
        this.enAbleFollowLecures = enAbleFollowLecures;
    }

    public Boolean getEnAbleToFollowLectureWithExtraPreparation() {
        return this.enAbleToFollowLectureWithExtraPreparation;
    }

    public void setEnAbleToFollowLectureWithExtraPreparation(Boolean enAbleToFollowLectureWithExtraPreparation) {
        this.enAbleToFollowLectureWithExtraPreparation = enAbleToFollowLectureWithExtraPreparation;
    }

    public Boolean getIntensivePortugueseCourseSeptember() {
        return this.intensivePortugueseCourseSeptember;
    }

    public void setIntensivePortugueseCourseSeptember(Boolean intensivePortugueseCourseSeptember) {
        this.intensivePortugueseCourseSeptember = intensivePortugueseCourseSeptember;
    }

    public Boolean getIntensivePortugueseCourseFebruary() {
        return this.intensivePortugueseCourseFebruary;
    }

    public void setIntensivePortugueseCourseFebruary(Boolean intensivePortugueseCourseFebruary) {
        this.intensivePortugueseCourseFebruary = intensivePortugueseCourseFebruary;
    }

    public ErasmusApplyForSemesterType getApplyFor() {
        return this.applyFor;
    }

    public void setApplyFor(ErasmusApplyForSemesterType applyFor) {
        this.applyFor = applyFor;
    }

    public SchoolLevelType getSchoolLevel() {
        return this.schoolLevel;
    }

    public void setSchoolLevel(SchoolLevelType schoolLevel) {
        this.schoolLevel = schoolLevel;
    }

    public String getOtherSchoolLevel() {
        return this.otherSchoolLevel;
    }

    public void setOtherSchoolLevel(String otherSchoolLevel) {
        this.otherSchoolLevel = otherSchoolLevel;
    }

    public boolean isSchoolLevelDefined() {
        return this.getSchoolLevel() != SchoolLevelType.OTHER || !StringUtils.isEmpty((String)this.getOtherSchoolLevel());
    }
}

