/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.degreeTransfer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.events.candidacy.DegreeTransferIndividualCandidacyEvent;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacySeriesGrade;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.PrecedentDegreeInformationForIndividualCandidacyFactory;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacyResultBean;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacySeriesGrade;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacy_Base;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class DegreeTransferIndividualCandidacy
extends DegreeTransferIndividualCandidacy_Base {
    private DegreeTransferIndividualCandidacy() {
    }

    DegreeTransferIndividualCandidacy(DegreeTransferIndividualCandidacyProcess process2, DegreeTransferIndividualCandidacyProcessBean bean) {
        this();
        Person person = this.init(bean, (IndividualCandidacyProcess)((Object)process2));
        super.setSelectedDegree(bean.getSelectedDegree());
        DegreeTransferIndividualCandidacySeriesGrade newSCICSeriesGrade = new DegreeTransferIndividualCandidacySeriesGrade();
        newSCICSeriesGrade.setDegree(bean.getSelectedDegree());
        this.getIndividualCandidacySeriesGradeSet().add(newSCICSeriesGrade);
        if (bean.getInternalPersonCandidacy().booleanValue()) {
            this.createDebt(person);
        }
    }

    protected void checkParameters(Person person, IndividualCandidacyProcess process2, IndividualCandidacyProcessBean bean) {
        DegreeTransferIndividualCandidacyProcessBean transferProcessBean = (DegreeTransferIndividualCandidacyProcessBean)bean;
        DegreeTransferIndividualCandidacyProcess transferProcess = (DegreeTransferIndividualCandidacyProcess)((Object)process2);
        LocalDate candidacyDate = bean.getCandidacyDate();
        Degree selectedDegree = transferProcessBean.getSelectedDegree();
        PrecedentDegreeInformationBean precedentDegreeInformation = transferProcessBean.getPrecedentDegreeInformation();
        this.checkParameters(person, transferProcess, candidacyDate, selectedDegree, precedentDegreeInformation);
    }

    private void checkParameters(Person person, DegreeTransferIndividualCandidacyProcess process2, LocalDate candidacyDate, Degree selectedDegree, PrecedentDegreeInformationBean precedentDegreeInformation) {
        this.checkParameters(person, (IndividualCandidacyProcess)((Object)process2), candidacyDate);
        if (selectedDegree == null) {
            throw new DomainException("error.DegreeTransferIndividualCandidacy.invalid.degree", new String[0]);
        }
        if (precedentDegreeInformation == null) {
            throw new DomainException("error.DegreeTransferIndividualCandidacy.invalid.precedentDegreeInformation", new String[0]);
        }
    }

    protected void createDebt(Person person) {
        new DegreeTransferIndividualCandidacyEvent(this, person);
    }

    public DegreeTransferIndividualCandidacyProcess getCandidacyProcess() {
        return (DegreeTransferIndividualCandidacyProcess)((Object)super.getCandidacyProcess());
    }

    protected ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    public Registration createRegistration(DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        if (this.getRegistration() != null) {
            throw new DomainException("error.IndividualCandidacy.person.with.registration", degreeCurricularPlan.getPresentationName());
        }
        if (this.hasRegistration(degreeCurricularPlan)) {
            Registration registration = this.getMostRecentRegistration(degreeCurricularPlan);
            this.setRegistration(registration);
            if (!registration.isActive()) {
                RegistrationState.createRegistrationState(registration, AccessControl.getPerson(), new DateTime(), RegistrationStateType.REGISTERED);
            }
            this.createInternalAbandonStateInPreviousRegistration();
            return registration;
        }
        this.getPersonalDetails().ensurePersonInternalization();
        return this.createRegistration(this.getPersonalDetails().getPerson(), degreeCurricularPlan, cycleType, ingressionType);
    }

    private boolean hasRegistration(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getPersonalDetails().getPerson() != null && this.getPersonalDetails().getPerson().getStudent() != null && this.getPersonalDetails().getPerson().getStudent().hasRegistrationFor(degreeCurricularPlan);
    }

    private Registration getMostRecentRegistration(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getStudent().getMostRecentRegistration(degreeCurricularPlan);
    }

    protected Registration createRegistration(Person person, DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        Registration registration = super.createRegistration(person, degreeCurricularPlan, cycleType, ingressionType);
        registration.setRegistrationYear(this.getCandidacyExecutionInterval());
        this.createInternalAbandonStateInPreviousRegistration();
        return registration;
    }

    private void createInternalAbandonStateInPreviousRegistration() {
        PrecedentDegreeInformation information;
        Registration previousRegistration;
        if (this.getRefactoredPrecedentDegreeInformation().isCandidacyInternal() && (previousRegistration = (information = this.getRefactoredPrecedentDegreeInformation()).getStudentCurricularPlan().getRegistration()).isActive()) {
            ExecutionYear candidacyExecutionInterval = this.getCandidacyExecutionInterval();
            ExecutionYear previousExecutionYear = candidacyExecutionInterval.getPreviousExecutionYear();
            if (previousRegistration.hasAnyEnrolmentsIn(candidacyExecutionInterval)) {
                throw new DomainException("error.DegreeTransferIndividualCandidacy.cannot.create.abandon.state.due.enrolments", previousRegistration.getDegreeCurricularPlanName(), candidacyExecutionInterval.getQualifiedName());
            }
            RegistrationState.createRegistrationState(previousRegistration, AccessControl.getPerson(), previousExecutionYear.getEndDateYearMonthDay().toDateTimeAtMidnight(), RegistrationStateType.INTERNAL_ABANDON);
        }
    }

    void editCandidacyInformation(DegreeTransferIndividualCandidacyProcessBean bean) {
        this.checkParameters(bean.getCandidacyDate(), bean.getSelectedDegree(), bean.getPrecedentDegreeInformation());
        this.setCandidacyDate(bean.getCandidacyDate());
        this.setSelectedDegree(bean.getSelectedDegree());
        PrecedentDegreeInformationForIndividualCandidacyFactory.edit(bean);
    }

    private void checkParameters(LocalDate candidacyDate, Degree selectedDegree, PrecedentDegreeInformationBean precedentDegreeInformation) {
        this.checkParameters(this.getPersonalDetails().getPerson(), (IndividualCandidacyProcess)((Object)this.getCandidacyProcess()), candidacyDate);
        if (selectedDegree == null) {
            throw new DomainException("error.DegreeTransferIndividualCandidacy.invalid.degree", new String[0]);
        }
        if (this.personHasDegree(this.getPersonalDetails().getPerson(), selectedDegree)) {
            throw new DomainException("error.DegreeTransferIndividualCandidacy.existing.degree", selectedDegree.getNameFor(this.getCandidacyExecutionInterval()).getContent());
        }
        if (precedentDegreeInformation == null) {
            throw new DomainException("error.DegreeTransferIndividualCandidacy.invalid.precedentDegreeInformation", new String[0]);
        }
    }

    void editCandidacyResult(DegreeTransferIndividualCandidacyResultBean bean) {
        this.checkParameters(bean);
        this.setAffinity(bean.getAffinity());
        this.setDegreeNature(bean.getDegreeNature());
        this.setApprovedEctsRate(bean.getApprovedEctsRate());
        this.setGradeRate(bean.getGradeRate());
        this.setSeriesCandidacyGrade(bean.getSeriesCandidacyGrade());
        if (this.isCandidacyResultStateValid(bean.getState())) {
            this.setState(bean.getState());
        } else if (bean.getState() == null) {
            this.setState(IndividualCandidacyState.STAND_BY);
        }
    }

    private void checkParameters(DegreeTransferIndividualCandidacyResultBean bean) {
        if (this.isAccepted() && bean.getState() != IndividualCandidacyState.ACCEPTED && this.getRegistration() != null) {
            throw new DomainException("error.DegreeTransferIndividualCandidacy.cannot.change.state.from.accepted.candidacies", new String[0]);
        }
    }

    void editSelectedDegree(Degree selectedDegree) {
        this.setSelectedDegree(selectedDegree);
    }

    public void exportValues(StringBuilder result) {
        super.exportValues(result);
        Formatter formatter = new Formatter(result);
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"label.process.id", (String[])new String[0]), this.getCandidacyProcess().getProcessCode());
        PrecedentDegreeInformation precedentDegreeInformation = this.getCandidacyProcess().getPrecedentDegreeInformation();
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.previous.degree", (String[])new String[0]), precedentDegreeInformation.getPrecedentDegreeDesignation());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.institution", (String[])new String[0]), precedentDegreeInformation.getPrecedentInstitution().getName());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.numberOfEnroledCurricularCourses", (String[])new String[0]), precedentDegreeInformation.getNumberOfEnroledCurricularCourses());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.numberOfApprovedCurricularCourses", (String[])new String[0]), precedentDegreeInformation.getNumberOfApprovedCurricularCourses());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.gradeSum", (String[])new String[0]), precedentDegreeInformation.getGradeSum());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.approvedEcts", (String[])new String[0]), precedentDegreeInformation.getApprovedEcts());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.enroledEcts", (String[])new String[0]), precedentDegreeInformation.getEnroledEcts());
        formatter.format("\n", new Object[0]);
        formatter.format("%s: %f\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.affinity", (String[])new String[0]), this.getAffinity() != null ? this.getAffinity() : BigDecimal.ZERO);
        formatter.format("%s: %d\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.degreeNature", (String[])new String[0]), this.getDegreeNature() != null ? this.getDegreeNature() : 0);
        formatter.format("%s: %f\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.DegreeChangeIndividualCandidacy.approvedEctsRate", (String[])new String[0]), this.getApprovedEctsRate() != null ? this.getApprovedEctsRate() : BigDecimal.ZERO);
        formatter.format("%s: %f\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.DegreeChangeIndividualCandidacy.gradeRate", (String[])new String[0]), this.getGradeRate() != null ? this.getGradeRate() : BigDecimal.ZERO);
        formatter.format("%s: %f\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.seriesCandidacyGrade", (String[])new String[0]), this.getSeriesCandidacyGrade() != null ? this.getSeriesCandidacyGrade() : BigDecimal.ZERO);
    }

    public String getDescription() {
        return this.getCandidacyProcess().getDisplayName() + (this.getSelectedDegree() != null ? ": " + this.getSelectedDegree().getNameI18N() : "");
    }

    public boolean isDegreeTransfer() {
        return true;
    }

    public DegreeTransferIndividualCandidacySeriesGrade getDegreeTransferIndividualCandidacySeriesGradeForDegree(Degree degree) {
        for (IndividualCandidacySeriesGrade seriesGrade : this.getIndividualCandidacySeriesGradeSet()) {
            if (seriesGrade.getDegree() != degree) continue;
            return (DegreeTransferIndividualCandidacySeriesGrade)((Object)seriesGrade);
        }
        return null;
    }

    private DegreeTransferIndividualCandidacySeriesGrade getDegreeTransferIndividualCandidacySeriesGrade() {
        if (this.getIndividualCandidacySeriesGradeSet().size() == 0) {
            return null;
        }
        return this.getDegreeTransferIndividualCandidacySeriesGradeForDegree(this.getSelectedDegree());
    }

    public BigDecimal getAffinity() {
        if (this.getDegreeTransferIndividualCandidacySeriesGrade() != null) {
            return this.getDegreeTransferIndividualCandidacySeriesGrade().getAffinity();
        }
        return null;
    }

    public Integer getDegreeNature() {
        if (this.getDegreeTransferIndividualCandidacySeriesGrade() != null) {
            return this.getDegreeTransferIndividualCandidacySeriesGrade().getDegreeNature();
        }
        return null;
    }

    public BigDecimal getApprovedEctsRate() {
        if (this.getDegreeTransferIndividualCandidacySeriesGrade() != null) {
            return this.getDegreeTransferIndividualCandidacySeriesGrade().getApprovedEctsRate();
        }
        return null;
    }

    public BigDecimal getGradeRate() {
        if (this.getDegreeTransferIndividualCandidacySeriesGrade() != null) {
            return this.getDegreeTransferIndividualCandidacySeriesGrade().getGradeRate();
        }
        return null;
    }

    public BigDecimal getSeriesCandidacyGrade() {
        if (this.getDegreeTransferIndividualCandidacySeriesGrade() != null) {
            return this.getDegreeTransferIndividualCandidacySeriesGrade().getSeriesCandidacyGrade();
        }
        return null;
    }

    public Collection<Degree> getAllDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>();
        result.add(this.getSelectedDegree());
        return result;
    }

    public void setSelectedDegree(Degree selectedDegree) {
        this.getDegreeTransferIndividualCandidacySeriesGrade().setDegree(selectedDegree);
        super.setSelectedDegree(selectedDegree);
    }

    public void setAffinity(BigDecimal value) {
        this.getDegreeTransferIndividualCandidacySeriesGrade().setAffinity(value);
    }

    public void setDegreeNature(Integer value) {
        this.getDegreeTransferIndividualCandidacySeriesGrade().setDegreeNature(value);
    }

    public void setApprovedEctsRate(BigDecimal value) {
        this.getDegreeTransferIndividualCandidacySeriesGrade().setApprovedEctsRate(value);
    }

    public void setGradeRate(BigDecimal value) {
        this.getDegreeTransferIndividualCandidacySeriesGrade().setGradeRate(value);
    }

    public void setSeriesCandidacyGrade(BigDecimal value) {
        this.getDegreeTransferIndividualCandidacySeriesGrade().setSeriesCandidacyGrade(value);
    }
}

