/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import com.google.common.io.ByteStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class CandidacyProcessDocumentUploadBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    IndividualCandidacyProcess individualCandidacyProcess;
    protected IndividualCandidacyDocumentFileType type;
    protected transient InputStream stream;
    protected long fileSize;
    protected String fileName;
    protected Long id = System.currentTimeMillis();
    protected IndividualCandidacyDocumentFile documentFile;
    protected static final int MAX_FILE_SIZE = 3698688;

    public CandidacyProcessDocumentUploadBean() {
    }

    public CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType type) {
        this.type = type;
    }

    public IndividualCandidacyDocumentFileType getType() {
        return this.type;
    }

    public void setType(IndividualCandidacyDocumentFileType type) {
        this.type = type;
    }

    public InputStream getStream() throws FileNotFoundException {
        return this.stream;
    }

    public void setStream(InputStream stream) throws IOException {
        this.stream = stream;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public IndividualCandidacyProcess getIndividualCandidacyProcess() {
        return this.individualCandidacyProcess;
    }

    public void setIndividualCandidacyProcess(IndividualCandidacyProcess individualCandidacyProcess) {
        this.individualCandidacyProcess = individualCandidacyProcess;
    }

    public Long getId() {
        return this.id;
    }

    public IndividualCandidacyDocumentFile getDocumentFile() {
        return this.documentFile;
    }

    public void setDocumentFile(IndividualCandidacyDocumentFile documentFile) {
        this.documentFile = documentFile;
    }

    public IndividualCandidacyDocumentFile createIndividualCandidacyDocumentFile(Class<? extends Process> processType, String documentIdNumber) throws IOException {
        String fileName = this.getFileName();
        long fileLength = this.getFileSize();
        IndividualCandidacyDocumentFileType type = this.getType();
        if (fileLength > 3698688L) {
            throw new DomainException("error.file.to.big", new String[0]);
        }
        byte[] contents = this.readStreamContents();
        if (contents == null) {
            return null;
        }
        return IndividualCandidacyDocumentFile.createCandidacyDocument(contents, fileName, type, processType.getSimpleName(), documentIdNumber);
    }

    protected byte[] readStreamContents() throws IOException {
        try (InputStream stream = this.getStream();){
            if (stream == null || this.getFileSize() == 0L) {
                byte[] byArray = null;
                return byArray;
            }
            if (this.getFileSize() > 3698688L) {
                throw new DomainException("error.file.to.big", new String[0]);
            }
            byte[] byArray = ByteStreams.toByteArray((InputStream)stream);
            return byArray;
        }
    }
}

