/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventState;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.AnnualEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public abstract class AnnualEvent
extends AnnualEvent_Base {
    protected AnnualEvent() {
    }

    protected void init(EventType eventType, Person person, ExecutionYear executionYear) {
        this.init(null, eventType, person, executionYear);
    }

    protected void init(AdministrativeOffice administrativeOffice, EventType eventType, Person person, ExecutionYear executionYear) {
        super.init(administrativeOffice, eventType, person);
        this.checkParameters(executionYear);
        super.setExecutionYear(executionYear);
    }

    private void checkParameters(ExecutionYear executionYear) {
        if (executionYear == null) {
            throw new DomainException("error.accounting.events.AnnualEvent.executionYear.cannot.be.null", new String[0]);
        }
    }

    public DateTime getStartDate() {
        return this.getExecutionYear().getBeginDateYearMonthDay().toDateTimeAtMidnight();
    }

    public DateTime getEndDate() {
        return this.getExecutionYear().getEndDateYearMonthDay().toDateTimeAtMidnight();
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        throw new DomainException("error.accounting.events.AnnualEvent.cannot.modify.executionYear", new String[0]);
    }

    public PostingRule getPostingRule() {
        return this.getServiceAgreementTemplate().findPostingRuleBy(this.getEventType(), this.getStartDate(), this.getEndDate());
    }

    public boolean isFor(ExecutionYear executionYear) {
        return super.getExecutionYear() == executionYear;
    }

    protected void disconnect() {
        super.setExecutionYear(null);
        super.disconnect();
    }

    public boolean isAnnual() {
        return true;
    }

    private static List<AnnualEvent> readBy(ExecutionYear executionYear, EventState eventState) {
        ArrayList<AnnualEvent> result = new ArrayList<AnnualEvent>();
        for (Event event : executionYear.getAnnualEventsSet()) {
            if (!event.isInState(eventState)) continue;
            result.add((AnnualEvent)((Object)event));
        }
        return result;
    }

    public static List<AnnualEvent> readNotPayedBy(ExecutionYear executionYear) {
        return AnnualEvent.readBy(executionYear, EventState.OPEN);
    }

    public static Set<AccountingTransaction> readPaymentsFor(Class<? extends AnnualEvent> eventClass, YearMonthDay startDate, YearMonthDay endDate) {
        HashSet<AccountingTransaction> result = new HashSet<AccountingTransaction>();
        for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
            for (AnnualEvent each : executionYear.getAnnualEventsSet()) {
                if (!eventClass.equals(((Object)((Object)each)).getClass()) || each.isCancelled()) continue;
                for (AccountingTransaction transaction : each.getNonAdjustingTransactions()) {
                    if (!transaction.isInsidePeriod(startDate, endDate)) continue;
                    result.add(transaction);
                }
            }
        }
        return result;
    }

    protected abstract ServiceAgreementTemplate getServiceAgreementTemplate();

    public boolean isAdministrativeOfficeAndInsuranceEvent() {
        return false;
    }

    public boolean isInsuranceEvent() {
        return false;
    }
}

