/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.AccountingTransactionDetail;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.PostingRule_Base;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.accountingTransactions.detail.SibsTransactionDetail;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public abstract class PostingRule
extends PostingRule_Base {
    public static Comparator<PostingRule> COMPARATOR_BY_EVENT_TYPE = new Comparator<PostingRule>(){

        @Override
        public int compare(PostingRule leftPostingRule, PostingRule rightPostingRule) {
            int comparationResult = leftPostingRule.getEventType().compareTo(rightPostingRule.getEventType());
            return comparationResult == 0 ? leftPostingRule.getExternalId().compareTo(rightPostingRule.getExternalId()) : comparationResult;
        }
    };
    public static Comparator<PostingRule> COMPARATOR_BY_START_DATE = new Comparator<PostingRule>(){

        @Override
        public int compare(PostingRule leftPostingRule, PostingRule rightPostingRule) {
            int comparationResult = leftPostingRule.getStartDate().compareTo((ReadableInstant)rightPostingRule.getStartDate());
            return comparationResult == 0 ? leftPostingRule.getExternalId().compareTo(rightPostingRule.getExternalId()) : comparationResult;
        }
    };
    public static Comparator<PostingRule> COMPARATOR_BY_END_DATE = new Comparator<PostingRule>(){

        @Override
        public int compare(PostingRule left, PostingRule right) {
            int comparationResult;
            if (!left.hasEndDate() && !right.hasEndDate()) {
                comparationResult = 0;
            } else if (!left.hasEndDate()) {
                comparationResult = 1;
            } else {
                if (!right.hasEndDate()) {
                    int comparationResult2 = -1;
                    return -1;
                }
                comparationResult = left.getEndDate().compareTo((ReadableInstant)right.getEndDate());
            }
            return comparationResult == 0 ? left.getExternalId().compareTo(right.getExternalId()) : comparationResult;
        }
    };

    protected PostingRule() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setCreationDate(new DateTime());
    }

    protected void init(EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate) {
        this.checkParameters(eventType, startDate, serviceAgreementTemplate);
        super.setEventType(eventType);
        super.setStartDate(startDate);
        super.setEndDate(endDate);
        super.setServiceAgreementTemplate(serviceAgreementTemplate);
    }

    private void checkParameters(EventType eventType, DateTime startDate, ServiceAgreementTemplate serviceAgreementTemplate) {
        if (eventType == null) {
            throw new DomainException("error.accounting.agreement.postingRule.eventType.cannot.be.null", new String[0]);
        }
        if (startDate == null) {
            throw new DomainException("error.accounting.agreement.postingRule.startDate.cannot.be.null", new String[0]);
        }
        if (serviceAgreementTemplate == null) {
            throw new DomainException("error.accounting.agreement.postingRule.serviceAgreementTemplate.cannot.be.null", new String[0]);
        }
    }

    public Set<Entry> process(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.isEmpty()) {
            throw new DomainException("error.accounting.PostingRule.entries.to.process.cannot.be.empty", new String[0]);
        }
        for (EntryDTO entryDTO : entryDTOs) {
            if (!entryDTO.getAmountToPay().lessOrEqualThan(Money.ZERO)) continue;
            throw new DomainException("error.accounting.PostingRule.amount.to.pay.must.be.greater.than.zero", new String[0]);
        }
        Set<AccountingTransaction> resultingTransactions = this.internalProcess(user, entryDTOs, event, fromAccount, toAccount, transactionDetail);
        return this.getResultingEntries(resultingTransactions);
    }

    protected Set<Entry> getResultingEntries(Set<AccountingTransaction> resultingTransactions) {
        HashSet<Entry> result = new HashSet<Entry>();
        for (AccountingTransaction transaction : resultingTransactions) {
            result.add(transaction.getToAccountEntry());
        }
        return result;
    }

    public final List<EntryDTO> calculateEntries(Event event) {
        return this.calculateEntries(event, new DateTime());
    }

    public boolean isActiveForDate(DateTime when) {
        if (this.getStartDate().isAfter((ReadableInstant)when)) {
            return false;
        }
        return this.hasEndDate() ? !when.isAfter((ReadableInstant)this.getEndDate()) : true;
    }

    public boolean isActive() {
        return this.isActiveForDate(new DateTime());
    }

    public boolean hasEndDate() {
        return this.getEndDate() != null;
    }

    public boolean overlaps(PostingRule postingRule) {
        return this.overlaps(postingRule.getEventType(), postingRule.getStartDate(), postingRule.getEndDate());
    }

    public boolean overlaps(EventType eventType, DateTime startDate, DateTime endDate) {
        if (this.getEventType() == eventType) {
            if (this.hasEndDate() && endDate != null) {
                return this.isActiveForDate(startDate) || this.isActiveForDate(endDate);
            }
            if (this.hasEndDate()) {
                return !startDate.isAfter((ReadableInstant)this.getEndDate());
            }
            if (endDate != null) {
                return !this.getStartDate().isAfter((ReadableInstant)endDate);
            }
            return true;
        }
        return false;
    }

    public void setCreationDate(DateTime creationDate) {
        throw new DomainException("error.accounting.agreement.postingRule.cannot.modify.creationDate", new String[0]);
    }

    public void setEventType(EventType eventType) {
        throw new DomainException("error.accounting.agreement.postingRule.cannot.modify.eventType", new String[0]);
    }

    public void setEndDate(DateTime endDate) {
        if (this.hasEndDate()) {
            throw new DomainException("error.accounting.PostingRule.endDate.is.already.set", new String[0]);
        }
        super.setEndDate(endDate);
    }

    public void deactivate() {
        this.deactivate(new DateTime());
    }

    public void deactivate(DateTime when) {
        super.setEndDate(when.minus(10000L));
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        super.setServiceAgreementTemplate(null);
        this.setRootDomainObject(null);
        this.removeOtherRelations();
        this.deleteDomainObject();
    }

    protected void removeOtherRelations() {
    }

    public void setServiceAgreementTemplate(ServiceAgreementTemplate serviceAgreementTemplate) {
        throw new DomainException("error.accounting.agreement.postingRule.cannot.modify.serviceAgreementTemplate", new String[0]);
    }

    protected Entry makeEntry(EntryType entryType, Money amount, Account account) {
        return new Entry(entryType, amount, account);
    }

    protected AccountingTransaction makeAccountingTransaction(User responsibleUser, Event event, Account from, Account to, EntryType entryType, Money amount, AccountingTransactionDetailDTO transactionDetail) {
        return new AccountingTransaction(responsibleUser, event, this.makeEntry(entryType, amount.negate(), from), this.makeEntry(entryType, amount, to), this.makeAccountingTransactionDetail(transactionDetail));
    }

    protected AccountingTransactionDetail makeAccountingTransactionDetail(AccountingTransactionDetailDTO transactionDetailDTO) {
        if (transactionDetailDTO instanceof SibsTransactionDetailDTO) {
            SibsTransactionDetailDTO sibsTransactionDetailDTO = (SibsTransactionDetailDTO)transactionDetailDTO;
            return new SibsTransactionDetail(sibsTransactionDetailDTO.getWhenRegistered(), sibsTransactionDetailDTO.getSibsTransactionId(), sibsTransactionDetailDTO.getSibsCode(), sibsTransactionDetailDTO.getComments());
        }
        return new AccountingTransactionDetail(transactionDetailDTO.getWhenRegistered(), transactionDetailDTO.getPaymentMode(), transactionDetailDTO.getComments());
    }

    public boolean isVisible() {
        return true;
    }

    public final Money calculateTotalAmountToPay(Event event, DateTime when) {
        return this.calculateTotalAmountToPay(event, when, true);
    }

    public void addOtherPartyAmount(User responsibleUser, Event event, Account fromAcount, Account toAccount, Money amount, AccountingTransactionDetailDTO transactionDetailDTO) {
        if (!event.isOtherPartiesPaymentsSupported()) {
            throw new DomainException("error.accounting.PostingRule.event.does.not.support.other.party.payments", new String[0]);
        }
        this.checkRulesToAddOtherPartyAmount(event, amount);
        this.internalAddOtherPartyAmount(responsibleUser, event, fromAcount, toAccount, amount, transactionDetailDTO);
    }

    protected void checkRulesToAddOtherPartyAmount(Event event, Money amount) {
        if (amount.greaterThan(this.calculateTotalAmountToPay(event, event.getWhenOccured(), false))) {
            throw new DomainException("error.accounting.PostingRule.cannot.add.other.party.amount.that.exceeds.event.amount.to.pay", new String[0]);
        }
    }

    public void internalAddOtherPartyAmount(User responsibleUser, Event event, Account fromAcount, Account toAccount, Money amount, AccountingTransactionDetailDTO transactionDetailDTO) {
        throw new DomainException("error.accounting.PostingRule.does.not.implement.internal.other.party.amount", new String[0]);
    }

    public boolean isActiveForPeriod(DateTime startDate, DateTime endDate) {
        if (this.getStartDate().isAfter((ReadableInstant)endDate)) {
            return false;
        }
        return this.getEndDate() == null || !this.getEndDate().isBefore((ReadableInstant)startDate);
    }

    public AccountingTransaction depositAmount(User responsibleUser, Event event, Account fromAcount, Account toAccount, Money amount, AccountingTransactionDetailDTO transactionDetailDTO) {
        throw new DomainException("error.accounting.PostingRule.does.not.implement.deposit.amount", new String[0]);
    }

    public AccountingTransaction depositAmount(User responsibleUser, Event event, Account fromAcount, Account toAccount, Money amount, EntryType entryType, AccountingTransactionDetailDTO transactionDetailDTO) {
        this.checkEntryTypeForDeposit(event, entryType);
        return this.makeAccountingTransaction(responsibleUser, event, fromAcount, toAccount, entryType, amount, transactionDetailDTO);
    }

    protected void checkEntryTypeForDeposit(Event event, EntryType entryType) {
        if (!event.getPossibleEntryTypesForDeposit().contains((Object)entryType)) {
            throw new DomainException("error.accounting.PostingRule.entry.type.not.supported.for.deposit", new String[0]);
        }
    }

    public boolean isMostRecent() {
        return Collections.max(this.getServiceAgreementTemplate().getAllPostingRulesFor(this.getEventType()), COMPARATOR_BY_END_DATE).equals((Object)this);
    }

    public String getFormulaDescription() {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)(((Object)((Object)this)).getClass().getSimpleName() + ".formulaDescription"), (String[])new String[0]);
    }

    protected boolean has(EventType eventType) {
        return this.getEventType().equals((Object)eventType);
    }

    public final Money calculateTotalAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        Money amountToPay = this.doCalculationForAmountToPay(event, when, applyDiscount);
        if (!event.isExemptionAppliable()) {
            return amountToPay;
        }
        return this.subtractFromExemptions(event, when, applyDiscount, amountToPay);
    }

    protected abstract Money doCalculationForAmountToPay(Event var1, DateTime var2, boolean var3);

    protected abstract Money subtractFromExemptions(Event var1, DateTime var2, boolean var3, Money var4);

    public PaymentCodeType calculatePaymentCodeTypeFromEvent(Event event, DateTime when, boolean applyDiscount) {
        throw new DomainException("error.accounting.PostingRule.cannot.calculate.payment.code.type", new String[0]);
    }

    public abstract List<EntryDTO> calculateEntries(Event var1, DateTime var2);

    protected abstract Set<AccountingTransaction> internalProcess(User var1, Collection<EntryDTO> var2, Event var3, Account var4, Account var5, AccountingTransactionDetailDTO var6);

    public static Collection<PostingRule> findPostingRules(EventType eventType) {
        HashSet<PostingRule> result = new HashSet<PostingRule>();
        for (PostingRule postingRule : Bennu.getInstance().getPostingRulesSet()) {
            if (!postingRule.has(eventType)) continue;
            result.add(postingRule);
        }
        return result;
    }

    static {
        PostingRule.getRelationServiceAgreementTemplatePostingRule().addListener((RelationListener)new RelationAdapter<ServiceAgreementTemplate, PostingRule>(){

            public void beforeAdd(ServiceAgreementTemplate serviceAgreementTemplate, PostingRule postingRule) {
                this.checkIfPostingRuleOverlapsExisting(serviceAgreementTemplate, postingRule);
            }

            private void checkIfPostingRuleOverlapsExisting(ServiceAgreementTemplate serviceAgreementTemplate, PostingRule postingRule) {
                if (serviceAgreementTemplate != null) {
                    for (PostingRule existingPostingRule : serviceAgreementTemplate.getPostingRulesSet()) {
                        if (!postingRule.overlaps(existingPostingRule)) continue;
                        throw new DomainException("error.accounting.agreement.ServiceAgreementTemplate.postingRule.overlaps.existing.one", new String[0]);
                    }
                }
            }
        });
    }
}

