/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree_Base;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.OccupationPeriodReference;
import org.fenixedu.academic.domain.OccupationPeriodReference_Base;
import org.fenixedu.academic.domain.OccupationPeriodType;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.ScientificCommission;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.candidacy.CandidacySituationType;
import org.fenixedu.academic.domain.candidacy.DFACandidacy;
import org.fenixedu.academic.domain.candidacy.DegreeCandidacy;
import org.fenixedu.academic.domain.candidacy.IMDCandidacy;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.candidacy.degree.ShiftDistributionEntry;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ExecutionDegree
extends ExecutionDegree_Base
implements Comparable<ExecutionDegree> {
    public static final Comparator<ExecutionDegree> COMPARATOR_BY_DEGREE_CODE = new Comparator<ExecutionDegree>(){

        @Override
        public int compare(ExecutionDegree o1, ExecutionDegree o2) {
            int dcc = o1.getDegree().getSigla().compareTo(o2.getDegree().getSigla());
            return dcc == 0 ? o1.getExternalId().compareTo(o2.getExternalId()) : dcc;
        }
    };
    public static final Comparator<ExecutionDegree> COMPARATOR_BY_DEGREE_NAME = new Comparator<ExecutionDegree>(){

        @Override
        public int compare(ExecutionDegree o1, ExecutionDegree o2) {
            return o1.getDegree().getName().compareTo(o2.getDegree().getName());
        }
    };
    public static final Comparator<ExecutionDegree> EXECUTION_DEGREE_COMPARATORY_BY_YEAR = new Comparator<ExecutionDegree>(){

        @Override
        public int compare(ExecutionDegree o1, ExecutionDegree o2) {
            return o1.getExecutionYear().compareTo(o2.getExecutionYear());
        }
    };
    public static final Comparator<ExecutionDegree> REVERSE_EXECUTION_DEGREE_COMPARATORY_BY_YEAR = new Comparator<ExecutionDegree>(){

        @Override
        public int compare(ExecutionDegree o1, ExecutionDegree o2) {
            return o1.getExecutionYear().compareTo(o2.getExecutionYear());
        }
    };
    public static final Comparator<ExecutionDegree> EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME = new Comparator<ExecutionDegree>(){

        @Override
        public int compare(ExecutionDegree o1, ExecutionDegree o2) {
            return Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID.compare(o1.getDegree(), o2.getDegree());
        }
    };
    public static final Comparator<ExecutionDegree> EXECUTION_DEGREE_COMPARATOR_BY_DEGREE_TYPE_AND_DEGREE_NAME = new Comparator<ExecutionDegree>(){

        @Override
        public int compare(ExecutionDegree o1, ExecutionDegree o2) {
            return Degree.COMPARATOR_BY_DEGREE_TYPE_DEGREE_NAME_AND_ID.compare(o1.getDegree(), o2.getDegree());
        }
    };
    public static final Comparator<ExecutionDegree> EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME_AND_EXECUTION_YEAR = new Comparator<ExecutionDegree>(){

        @Override
        public int compare(ExecutionDegree o1, ExecutionDegree o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME);
            comparatorChain.addComparator(EXECUTION_DEGREE_COMPARATORY_BY_YEAR);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };
    private static Comparator<ExecutionDegree> COMPARATOR_BY_DEGREE_CURRICULAR_PLAN_ID_INTERNAL_DESC = new Comparator<ExecutionDegree>(){

        @Override
        public int compare(ExecutionDegree o1, ExecutionDegree o2) {
            return o2.getDegreeCurricularPlan().getExternalId().compareTo(o1.getDegreeCurricularPlan().getExternalId());
        }
    };

    private ExecutionDegree() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected ExecutionDegree(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, Space campus, Boolean publishedExamMap) {
        this();
        if (degreeCurricularPlan == null || executionYear == null || campus == null) {
            throw new DomainException("execution.degree.null.args.to.constructor", new String[0]);
        }
        this.setDegreeCurricularPlan(degreeCurricularPlan);
        this.setExecutionYear(executionYear);
        this.setCampus(campus);
        if (publishedExamMap.booleanValue()) {
            this.getPublishedExamMapsSet().addAll(executionYear.getExecutionPeriodsSet());
        }
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!(this.getSchoolClassesSet().isEmpty() && this.getGuidesSet().isEmpty() && this.getStudentCandidaciesSet().isEmpty() && this.getShiftDistributionEntriesSet().isEmpty())) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"execution.degree.cannot.be.deleted", (String[])new String[0]));
        }
    }

    public boolean isDeletable() {
        return this.getDeletionBlockers().isEmpty();
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        while (!this.getCoordinatorsListSet().isEmpty()) {
            ((Coordinator)((Object)this.getCoordinatorsListSet().iterator().next())).delete();
        }
        while (!this.getScientificCommissionMembersSet().isEmpty()) {
            ((ScientificCommission)((Object)this.getScientificCommissionMembersSet().iterator().next())).delete();
        }
        if (this.getGratuityValues() != null) {
            this.getGratuityValues().delete();
        }
        this.getPublishedExamMapsSet().clear();
        this.setExecutionYear(null);
        this.setDegreeCurricularPlan(null);
        this.setCampus(null);
        for (OccupationPeriodReference reference : this.getOccupationPeriodReferencesSet()) {
            reference.delete();
        }
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void edit(ExecutionYear executionYear, Space campus, Boolean publishedExamMap) {
        this.setExecutionYear(executionYear);
        this.setCampus(campus);
        for (ExecutionSemester executionSemester : this.getExecutionYear().getExecutionPeriodsSet()) {
            if (publishedExamMap.booleanValue()) {
                this.getPublishedExamMapsSet().add(executionSemester);
                continue;
            }
            this.getPublishedExamMapsSet().remove(executionSemester);
        }
    }

    public boolean isBolonhaDegree() {
        return this.getDegreeCurricularPlan().isBolonhaDegree();
    }

    @Override
    public int compareTo(ExecutionDegree executionDegree) {
        ExecutionYear executionYear = executionDegree.getExecutionYear();
        return this.getExecutionYear().compareTo(executionYear);
    }

    public boolean isAfter(ExecutionDegree executionDegree) {
        return this.compareTo(executionDegree) > 0;
    }

    public boolean isBefore(ExecutionDegree executionDegree) {
        return this.compareTo(executionDegree) < 0;
    }

    public boolean isFirstYear() {
        Set executionDegrees = this.getDegreeCurricularPlan().getExecutionDegreesSet();
        return this == Collections.min(executionDegrees, EXECUTION_DEGREE_COMPARATORY_BY_YEAR);
    }

    public Set<Shift> findAvailableShifts(CurricularYear curricularYear, ExecutionSemester executionSemester) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan();
        HashSet<Shift> shifts = new HashSet<Shift>();
        for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
            if (!curricularCourse.hasScopeInGivenSemesterAndCurricularYearInDCP(curricularYear, degreeCurricularPlan, executionSemester)) continue;
            for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                if (executionCourse.getExecutionPeriod() != executionSemester) continue;
                shifts.addAll(executionCourse.getAssociatedShifts());
            }
        }
        return shifts;
    }

    @Deprecated
    public Set<SchoolClass> findSchoolClassesByExecutionPeriod(ExecutionSemester executionSemester) {
        HashSet<SchoolClass> schoolClasses = new HashSet<SchoolClass>();
        for (SchoolClass schoolClass : this.getSchoolClassesSet()) {
            if (schoolClass.getExecutionPeriod() != executionSemester) continue;
            schoolClasses.add(schoolClass);
        }
        return schoolClasses;
    }

    public Set<SchoolClass> findSchoolClassesByAcademicInterval(AcademicInterval academicInterval) {
        HashSet<SchoolClass> schoolClasses = new HashSet<SchoolClass>();
        for (SchoolClass schoolClass : this.getSchoolClassesSet()) {
            if (!schoolClass.getExecutionPeriod().getAcademicInterval().equals(academicInterval)) continue;
            schoolClasses.add(schoolClass);
        }
        return schoolClasses;
    }

    @Deprecated
    public Set<SchoolClass> findSchoolClassesByExecutionPeriodAndCurricularYear(ExecutionSemester executionSemester, Integer curricularYear) {
        HashSet<SchoolClass> schoolClasses = new HashSet<SchoolClass>();
        for (SchoolClass schoolClass : this.getSchoolClassesSet()) {
            if (schoolClass.getExecutionPeriod() != executionSemester || !schoolClass.getAnoCurricular().equals(curricularYear)) continue;
            schoolClasses.add(schoolClass);
        }
        return schoolClasses;
    }

    public Set<SchoolClass> findSchoolClassesByAcademicIntervalAndCurricularYear(AcademicInterval academicInterval, Integer curricularYear) {
        HashSet<SchoolClass> schoolClasses = new HashSet<SchoolClass>();
        for (SchoolClass schoolClass : this.getSchoolClassesSet()) {
            if (!schoolClass.getExecutionPeriod().getAcademicInterval().equals(academicInterval) || !schoolClass.getAnoCurricular().equals(curricularYear)) continue;
            schoolClasses.add(schoolClass);
        }
        return schoolClasses;
    }

    public SchoolClass findSchoolClassesByExecutionPeriodAndName(ExecutionSemester executionSemester, String name) {
        for (SchoolClass schoolClass : this.getSchoolClassesSet()) {
            if (schoolClass.getExecutionPeriod() != executionSemester || !schoolClass.getNome().equalsIgnoreCase(name)) continue;
            return schoolClass;
        }
        return null;
    }

    public Coordinator getCoordinatorByTeacher(Person person) {
        for (Coordinator coordinator : this.getCoordinatorsListSet()) {
            if (coordinator.getPerson() != person) continue;
            return coordinator;
        }
        return null;
    }

    public static List<ExecutionDegree> getAllByExecutionYear(String year) {
        if (year == null) {
            return Collections.emptyList();
        }
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        for (ExecutionDegree executionDegree : Bennu.getInstance().getExecutionDegreesSet()) {
            if (!year.equals(executionDegree.getExecutionYear().getYear())) continue;
            result.add(executionDegree);
        }
        Collections.sort(result, COMPARATOR_BY_DEGREE_CURRICULAR_PLAN_ID_INTERNAL_DESC);
        return result;
    }

    public static List<ExecutionDegree> getAllByExecutionYear(ExecutionYear executionYear) {
        if (executionYear == null) {
            return Collections.emptyList();
        }
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        for (ExecutionDegree executionDegree : Bennu.getInstance().getExecutionDegreesSet()) {
            if (executionDegree.getExecutionYear() != executionYear) continue;
            result.add(executionDegree);
        }
        Collections.sort(result, COMPARATOR_BY_DEGREE_CURRICULAR_PLAN_ID_INTERNAL_DESC);
        return result;
    }

    public static List<ExecutionDegree> getAllByExecutionCourseAndTeacher(ExecutionCourse executionCourse, Person person) {
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        for (ExecutionDegree executionDegree : Bennu.getInstance().getExecutionDegreesSet()) {
            boolean matchExecutionCourse = false;
            for (CurricularCourse curricularCourse : executionDegree.getDegreeCurricularPlan().getCurricularCoursesSet()) {
                if (!curricularCourse.getAssociatedExecutionCoursesSet().contains((Object)executionCourse)) continue;
                matchExecutionCourse = true;
                break;
            }
            if (!matchExecutionCourse || executionDegree.getCoordinatorByTeacher(person) == null) continue;
            result.add(executionDegree);
        }
        return result;
    }

    public static List<ExecutionDegree> getAllCoordinatedByTeacher(Person person) {
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        if (person == null) {
            return result;
        }
        for (Coordinator coordinator : person.getCoordinatorsSet()) {
            result.add(coordinator.getExecutionDegree());
        }
        Comparator<ExecutionDegree> degreNameComparator = new Comparator<ExecutionDegree>(){

            @Override
            public int compare(ExecutionDegree o1, ExecutionDegree o2) {
                String name1 = o1.getDegreeCurricularPlan().getDegree().getName();
                String name2 = o2.getDegreeCurricularPlan().getDegree().getName();
                return String.CASE_INSENSITIVE_ORDER.compare(name1, name2);
            }
        };
        Comparator<ExecutionDegree> yearComparator = new Comparator<ExecutionDegree>(){

            @Override
            public int compare(ExecutionDegree o1, ExecutionDegree o2) {
                String year1 = o1.getExecutionYear().getYear();
                String year2 = o2.getExecutionYear().getYear();
                return String.CASE_INSENSITIVE_ORDER.compare(year1, year2);
            }
        };
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)degreNameComparator, false);
        comparatorChain.addComparator((Comparator)yearComparator, true);
        Collections.sort(result, comparatorChain);
        return result;
    }

    public static List<ExecutionDegree> getAllByExecutionYearAndDegreeType(String year, DegreeType ... typeOfCourse) {
        if (year == null || typeOfCourse == null) {
            return Collections.emptyList();
        }
        ExecutionYear executionYear = ExecutionYear.readExecutionYearByName(year);
        return ExecutionDegree.getAllByExecutionYearAndDegreeType(executionYear, typeOfCourse);
    }

    public static List<ExecutionDegree> getAllByExecutionYearAndDegreeType(ExecutionYear executionYear, DegreeType ... typeOfCourse) {
        if (executionYear == null || typeOfCourse == null) {
            return Collections.emptyList();
        }
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
            boolean match = false;
            for (DegreeType type : typeOfCourse) {
                match |= type.equals(executionDegree.getDegreeType());
            }
            if (!match) continue;
            result.add(executionDegree);
        }
        Collections.sort(result, COMPARATOR_BY_DEGREE_CURRICULAR_PLAN_ID_INTERNAL_DESC);
        return result;
    }

    public static List<ExecutionDegree> getAllByDegreeAndExecutionYear(Degree degree, String year) {
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        if (degree == null || year == null) {
            return result;
        }
        ExecutionYear executionYear = ExecutionYear.readExecutionYearByName(year);
        if (executionYear == null) {
            return result;
        }
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
            if (!degree.equals(executionDegree.getDegreeCurricularPlan().getDegree())) continue;
            result.add(executionDegree);
        }
        return result;
    }

    public static List<ExecutionDegree> getAllByDegree(Degree degree) {
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        for (ExecutionDegree executionDegree : Bennu.getInstance().getExecutionDegreesSet()) {
            if (executionDegree.getDegree() != degree) continue;
            result.add(executionDegree);
        }
        return result;
    }

    public static List<ExecutionDegree> getAllByDegreeAndCurricularStage(Degree degree, CurricularStage stage) {
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        if (degree == null) {
            return result;
        }
        if (stage == null) {
            return result;
        }
        for (ExecutionDegree executionDegree : Bennu.getInstance().getExecutionDegreesSet()) {
            if (!degree.equals(executionDegree.getDegreeCurricularPlan().getDegree()) || !stage.equals((Object)executionDegree.getDegreeCurricularPlan().getCurricularStage())) continue;
            result.add(executionDegree);
        }
        return result;
    }

    public static ExecutionDegree getByDegreeCurricularPlanAndExecutionYear(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        if (degreeCurricularPlan == null || executionYear == null) {
            return null;
        }
        for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
            if (executionYear != executionDegree.getExecutionYear()) continue;
            return executionDegree;
        }
        return null;
    }

    public static ExecutionDegree getByDegreeCurricularPlanAndExecutionYear(DegreeCurricularPlan degreeCurricularPlan, String executionYear) {
        if (degreeCurricularPlan == null) {
            return null;
        }
        if (executionYear == null) {
            return null;
        }
        for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
            if (!executionYear.equalsIgnoreCase(executionDegree.getExecutionYear().getYear())) continue;
            return executionDegree;
        }
        return null;
    }

    public static ExecutionDegree getByDegreeCurricularPlanNameAndExecutionYear(String degreeName, ExecutionYear executionYear) {
        if (degreeName == null) {
            return null;
        }
        if (executionYear == null) {
            return null;
        }
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
            if (!degreeName.equalsIgnoreCase(executionDegree.getDegreeCurricularPlan().getName())) continue;
            return executionDegree;
        }
        return null;
    }

    public static ExecutionDegree readByDegreeCodeAndExecutionYearAndCampus(String degreeCode, ExecutionYear executionYear, Space campus) {
        for (Degree degree : Degree.readAllByDegreeCode(degreeCode)) {
            ExecutionDegree executionDegree = degree.getMostRecentDegreeCurricularPlan().getExecutionDegreeByYear(executionYear);
            if (executionDegree.getCampus() != campus) continue;
            return executionDegree;
        }
        return null;
    }

    public List<Coordinator> getResponsibleCoordinators() {
        ArrayList<Coordinator> result = new ArrayList<Coordinator>();
        for (Coordinator coordinator : this.getCoordinatorsListSet()) {
            if (!coordinator.getResponsible().booleanValue()) continue;
            result.add(coordinator);
        }
        return result;
    }

    public boolean hasAnyResponsibleCoordinators() {
        return !this.getResponsibleCoordinators().isEmpty();
    }

    public boolean isCoordinationTeamFormed() {
        return !this.getCoordinatorsListSet().isEmpty();
    }

    public boolean isCoordinationResponsibleChosen() {
        return this.hasAnyResponsibleCoordinators();
    }

    public final String getPresentationName() {
        return this.getDegreeCurricularPlan().getPresentationName(this.getExecutionYear());
    }

    public String getDegreeName() {
        return this.getDegree().getNameFor(this.getExecutionYear()).getContent();
    }

    public Degree getDegree() {
        return this.getDegreeCurricularPlan().getDegree();
    }

    public DegreeType getDegreeType() {
        return this.getDegree().getDegreeType();
    }

    public Set<DFACandidacy> getDfaCandidacies() {
        return this.getDFACandidacies();
    }

    public Set<DegreeCandidacy> getDegreeCandidacies() {
        HashSet<DegreeCandidacy> result = new HashSet<DegreeCandidacy>();
        for (StudentCandidacy studentCandidacy : this.getStudentCandidaciesSet()) {
            if (!(studentCandidacy instanceof DegreeCandidacy)) continue;
            result.add((DegreeCandidacy)((Object)studentCandidacy));
        }
        return result;
    }

    public Set<StudentCandidacy> getFirstCycleCandidacies() {
        HashSet<StudentCandidacy> result = new HashSet<StudentCandidacy>();
        for (StudentCandidacy studentCandidacy : this.getStudentCandidaciesSet()) {
            if (!studentCandidacy.isFirstCycleCandidacy()) continue;
            result.add(studentCandidacy);
        }
        return result;
    }

    public Collection<StudentCandidacy> getFirstCycleCandidacies(CandidacySituationType candidacySituationType) {
        HashSet<StudentCandidacy> result = new HashSet<StudentCandidacy>();
        for (StudentCandidacy studentCandidacy : this.getStudentCandidaciesSet()) {
            if (!(studentCandidacy instanceof DegreeCandidacy) && !(studentCandidacy instanceof IMDCandidacy) || studentCandidacy.getActiveCandidacySituationType() != candidacySituationType) continue;
            result.add(studentCandidacy);
        }
        return result;
    }

    public List<Registration> getRegistrationsForDegreeCandidacies() {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (DegreeCandidacy degreeCandidacy : this.getDegreeCandidacies()) {
            if (degreeCandidacy.getRegistration() == null) continue;
            result.add(degreeCandidacy.getRegistration());
        }
        return result;
    }

    public List<Registration> getRegistrationsForFirstCycleCandidacies() {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (StudentCandidacy studentCandidacy : this.getFirstCycleCandidacies()) {
            if (studentCandidacy.getRegistration() == null) continue;
            result.add(studentCandidacy.getRegistration());
        }
        return result;
    }

    public Set<DFACandidacy> getDFACandidacies() {
        HashSet<DFACandidacy> result = new HashSet<DFACandidacy>();
        for (StudentCandidacy studentCandidacy : this.getStudentCandidaciesSet()) {
            if (!(studentCandidacy instanceof DFACandidacy)) continue;
            result.add((DFACandidacy)((Object)studentCandidacy));
        }
        return result;
    }

    public List<ShiftDistributionEntry> getNextFreeShiftDistributions() {
        ArrayList entries = new ArrayList(this.getShiftDistributionEntriesSet());
        Collections.sort(entries, ShiftDistributionEntry.NUMBER_COMPARATOR);
        for (ShiftDistributionEntry shiftDistributionEntry : entries) {
            if (shiftDistributionEntry.getDistributed().booleanValue()) continue;
            return ShiftDistributionEntry.readByAbstractNumber(shiftDistributionEntry.getAbstractStudentNumber(), this.getExecutionYear());
        }
        return Collections.emptyList();
    }

    public Integer getStudentNumberForShiftDistributionBasedOn(Integer studentNumberPosition) {
        ArrayList<Integer> abstractStudentNumbers = new ArrayList<Integer>();
        for (ShiftDistributionEntry shiftDistributionEntry : this.getShiftDistributionEntriesSet()) {
            if (abstractStudentNumbers.contains(shiftDistributionEntry.getAbstractStudentNumber())) continue;
            abstractStudentNumbers.add(shiftDistributionEntry.getAbstractStudentNumber());
        }
        Collections.sort(abstractStudentNumbers);
        return !abstractStudentNumbers.isEmpty() ? (Integer)abstractStudentNumbers.get(studentNumberPosition) : null;
    }

    public List<ShiftDistributionEntry> getDistributedShiftsFor(Integer studentNumber) {
        return this.getShiftsFor(studentNumber, true);
    }

    private List<ShiftDistributionEntry> getShiftsFor(Integer studentNumber, boolean alreadyDistributed) {
        ArrayList<ShiftDistributionEntry> result = new ArrayList<ShiftDistributionEntry>();
        for (ShiftDistributionEntry shiftDistributionEntry : this.getShiftDistributionEntriesSet()) {
            if (shiftDistributionEntry.getDistributed() != alreadyDistributed || !shiftDistributionEntry.getAbstractStudentNumber().equals(studentNumber)) continue;
            result.add(shiftDistributionEntry);
        }
        return result;
    }

    public List<DegreeCandidacy> getDegreeCandidaciesBy(CandidacySituationType candidacySituationType) {
        ArrayList<DegreeCandidacy> result = new ArrayList<DegreeCandidacy>();
        for (DegreeCandidacy candidacy : this.getDegreeCandidacies()) {
            if (candidacy.getActiveCandidacySituation().getCandidacySituationType() != candidacySituationType) continue;
            result.add(candidacy);
        }
        return result;
    }

    public List<StudentCandidacy> getFirstCycleCandidaciesBy(CandidacySituationType candidacySituationType) {
        ArrayList<StudentCandidacy> result = new ArrayList<StudentCandidacy>();
        for (StudentCandidacy candidacy : this.getFirstCycleCandidacies()) {
            if (candidacy.getActiveCandidacySituation() == null || candidacy.getActiveCandidacySituation().getCandidacySituationType() != candidacySituationType) continue;
            result.add(candidacy);
        }
        return result;
    }

    public List<DegreeCandidacy> getNotConcludedDegreeCandidacies() {
        ArrayList<DegreeCandidacy> result = new ArrayList<DegreeCandidacy>();
        for (DegreeCandidacy degreeCandidacy : this.getDegreeCandidacies()) {
            if (degreeCandidacy.isConcluded()) continue;
            result.add(degreeCandidacy);
        }
        return result;
    }

    public boolean isPersonInScientificCommission(Person person) {
        for (ScientificCommission commission : this.getScientificCommissionMembersSet()) {
            if (commission.getPerson() != person) continue;
            return true;
        }
        return false;
    }

    public boolean isScientificCommissionMember() {
        Person person = AccessControl.getPerson();
        return this.isScientificCommissionMember(person);
    }

    public boolean isScientificCommissionMember(Person person) {
        for (ScientificCommission scientificCommission : this.getScientificCommissionMembersSet()) {
            if (person != scientificCommission.getPerson()) continue;
            return true;
        }
        return false;
    }

    public static List<ExecutionDegree> filterByAcademicInterval(AcademicInterval academicInterval) {
        AcademicCalendarEntry academicCalendarEntry = academicInterval.getAcademicCalendarEntry();
        while (!(academicCalendarEntry instanceof AcademicCalendarRootEntry)) {
            if (academicCalendarEntry instanceof AcademicYearCE) {
                ExecutionYear year = ExecutionYear.getExecutionYear((AcademicYearCE)((Object)academicCalendarEntry));
                ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
                result.addAll(year.getExecutionDegreesSet());
                return result;
            }
            academicCalendarEntry = academicCalendarEntry.getParentEntry();
        }
        return Collections.emptyList();
    }

    public AcademicInterval getAcademicInterval() {
        return this.getExecutionYear().getAcademicInterval();
    }

    public OccupationPeriod getPeriodLessons(ExecutionSemester executionSemester) {
        return this.getOnePeriod(OccupationPeriodType.LESSONS, executionSemester.getSemester());
    }

    @Deprecated
    public OccupationPeriod getPeriodLessonsFirstSemester() {
        return this.getOnePeriod(OccupationPeriodType.LESSONS, 1);
    }

    @Deprecated
    public OccupationPeriod getPeriodLessonsSecondSemester() {
        return this.getOnePeriod(OccupationPeriodType.LESSONS, 2);
    }

    @Deprecated
    public OccupationPeriod getPeriodExamsFirstSemester() {
        return this.getOnePeriod(OccupationPeriodType.EXAMS, 1);
    }

    @Deprecated
    public OccupationPeriod getPeriodExamsSecondSemester() {
        return this.getOnePeriod(OccupationPeriodType.EXAMS, 2);
    }

    @Deprecated
    public OccupationPeriod getPeriodExamsSpecialSeason() {
        return this.getOnePeriod(OccupationPeriodType.EXAMS_SPECIAL_SEASON, null);
    }

    private OccupationPeriod getOnePeriod(OccupationPeriodType type, Integer semester) {
        return this.getPeriods(type, semester).findAny().orElse(null);
    }

    public Stream<OccupationPeriod> getPeriods(OccupationPeriodType type, Integer semester, List<Integer> years) {
        return this.getPeriodReferences(type, semester, years).map(OccupationPeriodReference_Base::getOccupationPeriod);
    }

    public Stream<OccupationPeriodReference> getPeriodReferences(OccupationPeriodType type, Integer semester, List<Integer> years) {
        Stream<OccupationPeriodReference> stream = this.getOccupationPeriodReferencesSet().stream();
        if (type != null) {
            stream = stream.filter(r -> r.getPeriodType() == type);
        }
        if (semester != null) {
            stream = stream.filter(r -> r.getSemester() == null || r.getSemester() == semester);
        }
        if (years != null) {
            stream = stream.filter(r -> r.getCurricularYears().getYears().containsAll(years));
        }
        return stream;
    }

    public Stream<OccupationPeriod> getPeriods(OccupationPeriodType type) {
        return this.getPeriods(type, null, null);
    }

    public Stream<OccupationPeriod> getPeriods(OccupationPeriodType type, Integer semester) {
        return this.getPeriods(type, semester, null);
    }

    public Stream<OccupationPeriod> getPeriodsByCurricularYear(Integer year) {
        return this.getPeriods(null, null, Collections.singletonList(year));
    }

    public Stream<OccupationPeriod> getPeriodsByCurricularYears(List<Integer> years) {
        return this.getPeriods(null, null, years);
    }

    public boolean isDateInPeriodOfType(DateTime date, OccupationPeriodType type, Integer semester) {
        return this.getPeriods(type, semester).anyMatch(o -> o.getPeriodInterval().contains((ReadableInstant)date));
    }

    public boolean isPublishedExam(ExecutionSemester executionSemester) {
        return this.getPublishedExamMapsSet().contains(executionSemester);
    }

    public SortedSet<SchoolClass> getSortedSchoolClasses() {
        TreeSet<SchoolClass> result = new TreeSet<SchoolClass>(SchoolClass.COMPARATOR_BY_NAME);
        result.addAll(this.getSchoolClassesSet());
        return result;
    }
}

