/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import java.util.Locale;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeInfoCandidacy;
import org.fenixedu.academic.domain.DegreeInfoFuture;
import org.fenixedu.academic.domain.DegreeInfo_Base;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.DomainObject;

public class DegreeInfo
extends DegreeInfo_Base {
    private static final Logger logger = LoggerFactory.getLogger(DegreeInfo.class);
    public static final String DEGREE_INFO_CREATION_EVENT = "DEGREE_INFO_CREATION_EVENT";
    public static Comparator<DegreeInfo> COMPARATOR_BY_EXECUTION_YEAR = new Comparator<DegreeInfo>(){

        @Override
        public int compare(DegreeInfo info1, DegreeInfo info2) {
            int result = ExecutionYear.COMPARATOR_BY_YEAR.compare(info1.getExecutionYear(), info2.getExecutionYear());
            if (result != 0) {
                return result;
            }
            return DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)info1, (DomainObject)info2);
        }
    };

    public DegreeInfo(Degree degree, ExecutionYear executionYear) {
        this.setRootDomainObject(Bennu.getInstance());
        DegreeInfo degreeInfo = degree.getMostRecentDegreeInfo(executionYear);
        if (degreeInfo != null && degreeInfo.getExecutionYear() == executionYear) {
            throw new DomainException("error.net.sourceforge.fenixdu.domain.cannot.create.degreeInfo.already.exists.one.for.that.degree.and.executionYear", new String[0]);
        }
        super.setExecutionYear(executionYear);
        super.setName(degree.getNameFor(executionYear));
        super.setDegree(degree);
        new DegreeInfoCandidacy(this);
        new DegreeInfoFuture(this);
        Signal.emit((String)DEGREE_INFO_CREATION_EVENT, (Object)new DomainObjectEvent((DomainObject)this));
    }

    protected DegreeInfo() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public ExecutionInterval getExecutionInterval() {
        return this.getExecutionYear();
    }

    public void setExecutionInterval(ExecutionInterval input) {
        if (input == null) {
            throw new DomainException("error.DegreeInfo.required.ExecutionInterval", new String[0]);
        }
        super.setExecutionYear(ExecutionInterval.assertExecutionIntervalType(ExecutionYear.class, input));
    }

    public void setName(MultiLanguageString name) {
        if (this.hasSameName(name)) {
            return;
        }
        if (this.hasName() && !DegreeInfo.isEditable(this)) {
            throw new DomainException("error.org.fenixedu.academic.domain.DegreeInfo.can.only.change.name.for.future.execution.years", new String[0]);
        }
        super.setName(name);
    }

    private boolean hasName() {
        return this.getName() != null && !this.getName().isEmpty();
    }

    private boolean hasSameName(MultiLanguageString name) {
        return this.hasName() && this.getName().equals(name);
    }

    public DegreeInfo(DegreeInfo degreeInfo, ExecutionYear executionYear) {
        this(degreeInfo.getDegree(), executionYear);
        this.setName(degreeInfo.getName());
        this.setDescription(degreeInfo.getDescription());
        this.setHistory(degreeInfo.getHistory());
        this.setObjectives(degreeInfo.getObjectives());
        this.setDesignedFor(degreeInfo.getDesignedFor());
        this.setProfessionalExits(degreeInfo.getProfessionalExits());
        this.setOperationalRegime(degreeInfo.getOperationalRegime());
        this.setGratuity(degreeInfo.getGratuity());
        this.setAdditionalInfo(degreeInfo.getAdditionalInfo());
        this.setLinks(degreeInfo.getLinks());
        this.setTestIngression(degreeInfo.getTestIngression());
        this.setClassifications(degreeInfo.getClassifications());
        this.setAccessRequisites(degreeInfo.getAccessRequisites());
        this.setCandidacyDocuments(degreeInfo.getCandidacyDocuments());
        this.setDriftsInitial(degreeInfo.getDriftsInitial());
        this.setDriftsFirst(degreeInfo.getDriftsFirst());
        this.setDriftsSecond(degreeInfo.getDriftsSecond());
        this.setMarkMin(degreeInfo.getMarkMin());
        this.setMarkMax(degreeInfo.getMarkMax());
        this.setMarkAverage(degreeInfo.getMarkAverage());
        this.setQualificationLevel(degreeInfo.getQualificationLevel());
        this.setRecognitions(degreeInfo.getRecognitions());
    }

    public void delete() {
        this.getDegreeInfoCandidacy().delete();
        this.getDegreeInfoFuture().delete();
        this.setRootDomainObject(null);
        this.setDegree(null);
        this.setExecutionYear(null);
        this.deleteDomainObject();
    }

    public MultiLanguageString getAccessRequisites() {
        return this.getDegreeInfoCandidacy().getAccessRequisites();
    }

    public MultiLanguageString getCandidacyDocuments() {
        return this.getDegreeInfoCandidacy().getCandidacyDocuments();
    }

    public MultiLanguageString getCandidacyPeriod() {
        return this.getDegreeInfoCandidacy().getCandidacyPeriod();
    }

    public MultiLanguageString getClassifications() {
        return this.getDegreeInfoFuture().getClassifications();
    }

    public MultiLanguageString getDesignedFor() {
        return this.getDegreeInfoFuture().getDesignedFor();
    }

    public String getDesignedFor(Locale language) {
        return this.hasDesignedFor(language) ? this.getDesignedFor().getContent(language) : "";
    }

    public boolean hasDesignedFor(Locale language) {
        return this.getDesignedFor() != null && this.getDesignedFor().hasContent(language);
    }

    public MultiLanguageString getEnrolmentPeriod() {
        return this.getDegreeInfoCandidacy().getEnrolmentPeriod();
    }

    public MultiLanguageString getObjectives() {
        return this.getDegreeInfoFuture().getObjectives();
    }

    public boolean hasObjectives(Locale language) {
        return this.getObjectives() != null && this.getObjectives().hasContent(language);
    }

    public String getObjectives(Locale language) {
        return this.hasObjectives(language) ? this.getObjectives().getContent(language) : "";
    }

    public MultiLanguageString getProfessionalExits() {
        return this.getDegreeInfoFuture().getProfessionalExits();
    }

    public boolean hasProfessionalExits(Locale language) {
        return this.getProfessionalExits() != null && this.getProfessionalExits().hasContent(language);
    }

    public String getProfessionalExits(Locale language) {
        return this.hasProfessionalExits(language) ? this.getProfessionalExits().getContent(language) : "";
    }

    public MultiLanguageString getQualificationLevel() {
        return this.getDegreeInfoFuture().getQualificationLevel();
    }

    public MultiLanguageString getRecognitions() {
        return this.getDegreeInfoFuture().getRecognitions();
    }

    public MultiLanguageString getSelectionResultDeadline() {
        return this.getDegreeInfoCandidacy().getSelectionResultDeadline();
    }

    public MultiLanguageString getTestIngression() {
        return this.getDegreeInfoCandidacy().getTestIngression();
    }

    public void setAccessRequisites(MultiLanguageString accessRequisites) {
        this.getDegreeInfoCandidacy().setAccessRequisites(accessRequisites);
    }

    public void setCandidacyDocuments(MultiLanguageString candidacyDocuments) {
        this.getDegreeInfoCandidacy().setCandidacyDocuments(candidacyDocuments);
    }

    public void setCandidacyPeriod(MultiLanguageString candidacyPeriod) {
        this.getDegreeInfoCandidacy().setCandidacyPeriod(candidacyPeriod);
    }

    public void setClassifications(MultiLanguageString classifications) {
        this.getDegreeInfoFuture().setClassifications(classifications);
    }

    public void setDesignedFor(MultiLanguageString designedFor) {
        this.getDegreeInfoFuture().setDesignedFor(designedFor);
    }

    public void setEnrolmentPeriod(MultiLanguageString enrolmentPeriod) {
        this.getDegreeInfoCandidacy().setEnrolmentPeriod(enrolmentPeriod);
    }

    public void setObjectives(MultiLanguageString objectives) {
        this.getDegreeInfoFuture().setObjectives(objectives);
    }

    public void setProfessionalExits(MultiLanguageString professionalExits) {
        this.getDegreeInfoFuture().setProfessionalExits(professionalExits);
    }

    public void setQualificationLevel(MultiLanguageString qualificationLevel) {
        this.getDegreeInfoFuture().setQualificationLevel(qualificationLevel);
    }

    public void setRecognitions(MultiLanguageString recognitions) {
        this.getDegreeInfoFuture().setRecognitions(recognitions);
    }

    public void setSelectionResultDeadline(MultiLanguageString selectionResultDeadline) {
        this.getDegreeInfoCandidacy().setSelectionResultDeadline(selectionResultDeadline);
    }

    public void setTestIngression(MultiLanguageString testIngression) {
        this.getDegreeInfoCandidacy().setTestIngression(testIngression);
    }

    public boolean hasOperationalRegime(Locale language) {
        return this.getOperationalRegime() != null && this.getOperationalRegime().hasContent(language);
    }

    public String getOperationalRegime(Locale language) {
        return this.hasOperationalRegime(language) ? this.getOperationalRegime().getContent(language) : "";
    }

    public boolean hasAdditionalInfo(Locale language) {
        return this.getAdditionalInfo() != null && this.getAdditionalInfo().hasContent(language);
    }

    public String getAdditionalInfo(Locale language) {
        return this.hasAdditionalInfo(language) ? this.getAdditionalInfo().getContent(language) : "";
    }

    public AcademicInterval getAcademicInterval() {
        return this.getExecutionYear().getAcademicInterval();
    }

    public static boolean isEditable(DegreeInfo dinfo) {
        return true;
    }
}

