<%--

    Copyright © 2002 Instituto Superior Técnico

    This file is part of FenixEdu Academic.

    FenixEdu Academic is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FenixEdu Academic is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with FenixEdu Academic.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>

<%@page import="org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType"%>
<%@page import="org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement"%>
<%@page import="org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean"%>
<%@page import="org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean"%><html:xhtml/>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://fenix-ashes.ist.utl.pt/fenix-renderers" prefix="fr" %>


<bean:define id="processId" name="process" property="externalId" />
<bean:define id="individualProcessId" name="process" property="individualProgramProcess.externalId" />


<%-- ### Title #### --%>
<h2><bean:message key="label.phd.remind.jury.reviews" bundle="PHD_RESOURCES" /></h2>
<%-- ### End of Title ### --%>


<%--  ###  Return Links / Steps Information(for multistep forms)  ### --%>
<html:link action="<%= "/phdIndividualProgramProcess.do?method=viewProcess&amp;processId=" + individualProcessId.toString() %>">
	<bean:message bundle="PHD_RESOURCES" key="label.back"/>
</html:link>
<br/><br/>
<%--  ### Return Links / Steps Information (for multistep forms)  ### --%>

<%--  ### Error Messages  ### --%>
<jsp:include page="/phd/errorsAndMessages.jsp" />
<%--  ### End of Error Messages  ### --%>


<%--  ### Context Information (e.g. Person Information, Registration Information)  ### --%>
<strong><bean:message  key="label.phd.process" bundle="PHD_RESOURCES"/></strong>
<fr:view schema="AcademicAdminOffice.PhdIndividualProgramProcess.view" name="process" property="individualProgramProcess">
	<fr:layout name="tabular">
		<fr:property name="classes" value="tstyle2 thlight mtop15" />
	</fr:layout>
</fr:view>

<br/>
<strong><bean:message key="label.phd.jury.reporters" bundle="PHD_RESOURCES" /></trong>
<fr:view name="process" property="reportThesisJuryElements">

	<fr:schema bundle="PHD_RESOURCES" type="<%= ThesisJuryElement.class.getName() %>">
		<fr:slot name="nameWithTitle" />
		<fr:slot name="email" />
		<fr:slot name="documentValidated" layout="boolean-icon">
			<fr:property name="falseIconPath" value="/images/incorrect.gif" />
		</fr:slot>
		<fr:slot name="lastFeedbackDocument" layout="null-as-label">
			<fr:property name="subLayout" value="link" />
		</fr:slot>
	</fr:schema>

	<fr:layout name="tabular">
		<fr:property name="classes" value="tstyle2 thlight mtop15" />
		<fr:property name="columnClasses" value="acenter" />
	</fr:layout>
</fr:view>

<%--  ### End Of Context Information  ### --%>


<%--  ### Operation Area (e.g. Create Candidacy)  ### --%>

<bean:define id="anyDocumentToValidate" name="process" property="anyDocumentToValidate" />

<logic:equal name="anyDocumentToValidate" value="true">

<br/>
<strong><bean:message key="label.phd.jury.reporters" bundle="PHD_RESOURCES" /></strong>
<fr:form action="<%= "/phdThesisProcess.do?processId=" + processId.toString() %>">
	<input type="hidden" name="method" />
	<fr:edit id="remindJuryReviewsBean" name="remindJuryReviewsBean">
		<fr:schema bundle="PHD_RESOURCES" type="<%= PhdThesisProcessBean.class.getName() %>">
			<fr:slot name="toNotify" layout="radio">
				<fr:property name="classes" value="liinline nobullet"/>
			</fr:slot>
			<fr:slot name="remarks" layout="longText">
				<fr:property name="columns" value="80"/>
				<fr:property name="rows" value="8"/>
			</fr:slot>
		</fr:schema>
	
		<fr:layout name="tabular">
			<fr:property name="classes" value="tstyle5 thlight thright mtop05" />
			<fr:property name="columnClasses" value=",,tdclear tderror1" />
		</fr:layout>
	</fr:edit>


	<html:submit bundle="HTMLALT_RESOURCES" altKey="submit.submit" onclick="this.form.method.value='remindJuryReviews';"><bean:message bundle="PHD_RESOURCES" key="label.submit"/></html:submit>
	<html:cancel bundle="HTMLALT_RESOURCES" altKey="cancel.cancel" onclick="this.form.method.value='viewIndividualProgramProcess';"><bean:message bundle="PHD_RESOURCES" key="label.cancel"/></html:cancel>	
</fr:form>

</logic:equal>

<logic:equal name="anyDocumentToValidate" value="false">
	<br/>
	<em>Todos os pareceres foram submetidos.</em>
</logic:equal>

<%--  ### End of Operation Area  ### --%>

<%--  ### Buttons (e.g. Submit)  ### --%>

<%--  ### End of Buttons (e.g. Submit)  ### --%>
