/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.fenixedu.commons.StringNormalizer;

public class StringFormatter {
    private static String specialChars = "/:-,.()'+";
    private static Set<String> allLowerSet = new HashSet<String>();
    protected static Set<String> allCapSet = new HashSet<String>();

    public static String prettyPrint(String uglyDuckling) {
        if (StringUtils.isEmpty((String)uglyDuckling)) {
            return uglyDuckling;
        }
        uglyDuckling = StringFormatter.removeDuplicateSpaces(uglyDuckling.trim());
        String[] lowerCaseName = uglyDuckling.toLowerCase().split(" ");
        StringBuilder capitalizedName = new StringBuilder();
        for (int i = 0; i < lowerCaseName.length; ++i) {
            if (!StringFormatter.containsNoneSpecialChars(lowerCaseName[i]) && !allCapSet.contains(lowerCaseName[i])) {
                capitalizedName.append(StringFormatter.capitalizeWordWithSpecChars(lowerCaseName[i]));
            } else if (i == 0) {
                capitalizedName.append(WordUtils.capitalize((String)lowerCaseName[i]));
            } else if (i == lowerCaseName.length - 1 & lowerCaseName[i].equals("a")) {
                capitalizedName.append(lowerCaseName[i].toUpperCase());
            } else {
                capitalizedName.append(StringFormatter.capitalizeWord(lowerCaseName[i], false));
            }
            capitalizedName.append(" ");
        }
        return capitalizedName.toString().substring(0, capitalizedName.length() - 1);
    }

    protected static String capitalizeWordWithSpecChars(String uglyWord) {
        StringBuilder prettyWord = new StringBuilder();
        int startPos = 0;
        int index = StringFormatter.indexOfAnySpecChar(uglyWord, 0);
        while (index >= 0) {
            prettyWord.append(StringFormatter.capitalizeWord(uglyWord.substring(startPos, startPos + index), index > 0));
            prettyWord.append(uglyWord.substring(startPos + index, startPos + index + 1));
            if (StringFormatter.containsNoneSpecialChars(uglyWord.substring(startPos += index + 1))) {
                prettyWord.append(StringFormatter.capitalizeWord(uglyWord.substring(startPos), false));
            }
            index = StringFormatter.indexOfAnySpecChar(uglyWord, startPos);
        }
        return prettyWord.toString();
    }

    public static String capitalizeWord(String uglyWord, boolean originalWordEndsWithSpecialChar) {
        StringBuilder prettyWord = new StringBuilder();
        if (allCapSet.contains(uglyWord)) {
            prettyWord.append(uglyWord.toUpperCase());
        } else if (!originalWordEndsWithSpecialChar && allLowerSet.contains(uglyWord)) {
            prettyWord.append(uglyWord);
        } else {
            prettyWord.append(WordUtils.capitalize((String)uglyWord));
        }
        return prettyWord.toString();
    }

    protected static boolean containsNoneSpecialChars(String string) {
        return StringUtils.containsNone((String)string, (String)specialChars);
    }

    private static int indexOfAnySpecChar(String string, int startPos) {
        return StringUtils.indexOfAny((String)string.substring(startPos), (String)specialChars);
    }

    public static String normalize(String string) {
        String result = null;
        if (StringUtils.isNotBlank((String)string)) {
            String spacesReplacedString = StringFormatter.removeDuplicateSpaces(string.trim());
            result = StringNormalizer.normalize((String)spacesReplacedString);
        }
        return result;
    }

    protected static String removeDuplicateSpaces(String string) {
        Pattern pattern = Pattern.compile("\\s+");
        Matcher matcher = pattern.matcher(string);
        return matcher.replaceAll(" ");
    }

    public static String splitCamelCaseString(String string) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (char c : string.toCharArray()) {
            if (first) {
                first = false;
            } else if (Character.isUpperCase(c)) {
                result.append(' ');
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String convertToDBStyle(String string) {
        return StringFormatter.splitCamelCaseString(string).replace(' ', '_').toUpperCase();
    }

    static {
        allLowerSet.add("a");
        allLowerSet.add("as");
        allLowerSet.add("o");
        allLowerSet.add("os");
        allLowerSet.add("um");
        allLowerSet.add("uns");
        allLowerSet.add("uma");
        allLowerSet.add("umas");
        allLowerSet.add("com");
        allLowerSet.add("de");
        allLowerSet.add("em");
        allLowerSet.add("para");
        allLowerSet.add("por");
        allLowerSet.add("sobre");
        allLowerSet.add("ao");
        allLowerSet.add("aos");
        allLowerSet.add("\u00e0");
        allLowerSet.add("\u00e0s");
        allLowerSet.add("do");
        allLowerSet.add("dos");
        allLowerSet.add("da");
        allLowerSet.add("das");
        allLowerSet.add("no");
        allLowerSet.add("nos");
        allLowerSet.add("na");
        allLowerSet.add("nas");
        allLowerSet.add("num");
        allLowerSet.add("e");
        allLowerSet.add("and");
        allLowerSet.add("at");
        allLowerSet.add("by");
        allLowerSet.add("for");
        allLowerSet.add("in");
        allLowerSet.add("of");
        allLowerSet.add("on");
        allLowerSet.add("the");
        allLowerSet.add("to");
        allLowerSet.add("with");
        allLowerSet.add("au");
        allLowerSet.add("dans");
        allLowerSet.add("des");
        allLowerSet.add("du");
        allLowerSet.add("en");
        allLowerSet.add("et");
        allLowerSet.add("la");
        allLowerSet.add("le");
        allLowerSet.add("un");
        allLowerSet.add("une");
        allLowerSet.add("par");
        allLowerSet.add("d");
        allLowerSet.add("l");
        allLowerSet.add("der");
        allLowerSet.add("und");
        allLowerSet.add("dei");
        allLowerSet.add("degli");
        allLowerSet.add("dell");
        allLowerSet.add("delle");
        allLowerSet.add("di");
        allLowerSet.add("ed");
        allLowerSet.add("nei");
        allLowerSet.add("nel");
        allLowerSet.add("y");
        allCapSet.add("i");
        allCapSet.add("i");
        allCapSet.add("ii");
        allCapSet.add("iii");
        allCapSet.add("iv");
        allCapSet.add("v");
        allCapSet.add("vi");
        allCapSet.add("vii");
        allCapSet.add("viii");
        allCapSet.add("ix");
        allCapSet.add("x");
        allCapSet.add("b");
        allCapSet.add("c");
        allCapSet.add("a)");
        allCapSet.add("b)");
        allCapSet.add("c)");
        allCapSet.add("d)");
        allCapSet.add("e)");
        allCapSet.add("3b");
        allCapSet.add("3d");
        allCapSet.add("4a");
        allCapSet.add("m");
        allCapSet.add("d");
        allCapSet.add("(m)");
        allCapSet.add("(d)");
        allCapSet.add("lm");
        allCapSet.add("ml");
        allCapSet.add("md");
        allCapSet.add("dm");
        allCapSet.add("l/m");
        allCapSet.add("m/l");
        allCapSet.add("m/d");
        allCapSet.add("d/m");
        allCapSet.add("(lm)");
        allCapSet.add("(ml)");
        allCapSet.add("(md)");
        allCapSet.add("(dm)");
        allCapSet.add("(l/m)");
        allCapSet.add("(m/l)");
        allCapSet.add("(m/d)");
        allCapSet.add("(d/m)");
        allCapSet.add("(a)");
        allCapSet.add("(p)");
        allCapSet.add("(sie)");
        allCapSet.add("(sm)");
        allCapSet.add("(cad)");
        allCapSet.add("cad/cam");
        allCapSet.add("ic");
    }
}

