/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher.executionCourse;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Curriculum;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Input;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.DateTime;

@Mapping(path="/manageObjectives", module="teacher", functionality=ManageExecutionCourseDA.class, formBean="objectivesForm")
@Forwards(value={@Forward(name="objectives", path="/teacher/executionCourse/objectives.jsp"), @Forward(name="createObjectives", path="/teacher/executionCourse/createObjectives.jsp"), @Forward(name="editObjectives", path="/teacher/executionCourse/editObjectives.jsp")})
public class ExecutionCourseObjectivesDA
extends ManageExecutionCourseDA {
    @Input
    public ActionForward objectives(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("objectives");
    }

    public ActionForward prepareCreateObjectives(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareCurricularCourse(request);
        return mapping.findForward("createObjectives");
    }

    public ActionForward createObjectives(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException, FenixActionException {
        this.executeFactoryMethod();
        return mapping.findForward("objectives");
    }

    public ActionForward prepareEditObjectives(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        Teacher teacher = ExecutionCourseObjectivesDA.getUserView(request).getPerson().getTeacher();
        if (teacher.isResponsibleFor(executionCourse) == null) {
            ActionMessages messages = new ActionMessages();
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.teacherNotResponsibleOrNotCoordinator"));
            this.saveErrors(request, messages);
            return mapping.findForward("objectives");
        }
        String curriculumIDString = request.getParameter("curriculumID");
        if (executionCourse != null && curriculumIDString != null && curriculumIDString.length() > 0) {
            Curriculum curriculum = this.findCurriculum(executionCourse, curriculumIDString);
            if (curriculum != null) {
                DynaActionForm dynaActionForm = (DynaActionForm)form;
                dynaActionForm.set("generalObjectives", (Object)curriculum.getGeneralObjectives());
                dynaActionForm.set("generalObjectivesEn", (Object)curriculum.getGeneralObjectivesEn());
                dynaActionForm.set("operacionalObjectives", (Object)curriculum.getOperacionalObjectives());
                dynaActionForm.set("operacionalObjectivesEn", (Object)curriculum.getOperacionalObjectivesEn());
            }
            request.setAttribute("curriculum", (Object)curriculum);
        }
        return mapping.findForward("objectives");
    }

    public ActionForward editObjectives(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.executeFactoryMethod();
        return mapping.findForward("objectives");
    }

    public static class CurriculumFactoryInsertCurriculum
    extends CurricularCourse.CurriculumFactory
    implements FactoryExecutor {
        public CurriculumFactoryInsertCurriculum(CurricularCourse curricularCourse, ExecutionCourse executionCourse) {
            super(curricularCourse);
            this.setLastModification(executionCourse.getExecutionPeriod().getBeginDateYearMonthDay().toDateTimeAtMidnight());
        }

        public Curriculum execute() {
            CurricularCourse curricularCourse = this.getCurricularCourse();
            return curricularCourse == null ? null : curricularCourse.insertCurriculum(this.getProgram(), this.getProgramEn(), this.getGeneralObjectives(), this.getGeneralObjectivesEn(), this.getOperacionalObjectives(), this.getOperacionalObjectivesEn(), this.getLastModification());
        }
    }

    public static class CurriculumFactoryEditCurriculum
    extends CurricularCourse.CurriculumFactory
    implements FactoryExecutor {
        private Curriculum curriculum;

        public CurriculumFactoryEditCurriculum(CurricularCourse curricularCourse) {
            super(curricularCourse);
            this.setLastModification(new DateTime());
            this.curriculum = null;
        }

        public CurriculumFactoryEditCurriculum(Curriculum curriculum) {
            super(curriculum.getCurricularCourse());
            this.curriculum = curriculum;
        }

        public Curriculum getCurriculum() {
            return this.curriculum;
        }

        public void setCurriculum(Curriculum curriculum) {
            this.curriculum = curriculum;
            if (curriculum != null) {
                this.setGeneralObjectives(curriculum.getGeneralObjectives());
                this.setGeneralObjectivesEn(curriculum.getGeneralObjectivesEn());
                this.setOperacionalObjectives(curriculum.getOperacionalObjectives());
                this.setOperacionalObjectivesEn(curriculum.getOperacionalObjectivesEn());
                this.setProgram(curriculum.getProgram());
                this.setProgramEn(curriculum.getProgramEn());
            }
        }

        public Curriculum execute() {
            Curriculum curriculum = this.getCurriculum();
            if (curriculum == null) {
                CurricularCourse curricularCourse = this.getCurricularCourse();
                return curricularCourse == null ? null : curricularCourse.editCurriculum(this.getProgram(), this.getProgramEn(), this.getGeneralObjectives(), this.getGeneralObjectivesEn(), this.getOperacionalObjectives(), this.getOperacionalObjectivesEn(), this.getLastModification());
            }
            DateTime dt = curriculum.getLastModificationDateDateTime();
            curriculum.edit(this.getGeneralObjectives(), this.getOperacionalObjectives(), this.getProgram(), this.getGeneralObjectivesEn(), this.getOperacionalObjectivesEn(), this.getProgramEn());
            curriculum.setLastModificationDateDateTime(dt);
            return curriculum;
        }
    }
}

