/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.scientificCouncil.curricularPlans;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeOfficialPublication;
import org.fenixedu.academic.domain.DegreeSpecializationArea;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.commons.FenixActionForward;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.ScientificCouncilApplication;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.curricularPlans.OfficialPublicationBean;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/curricularPlans/editOfficialPublication", module="scientificCouncil", formBeanClass=FenixActionForm.class, functionality=ScientificCouncilApplication.ScientificCurricularPlansManagement.class)
@Forwards(value={@Forward(name="prepare", path="/scientificCouncil/curricularPlans/editOfficialPublication.jsp"), @Forward(name="prepareSpecializationArea", path="/scientificCouncil/curricularPlans/editDegreeSpecializationArea.jsp"), @Forward(name="editDegree", path="/scientificCouncil/curricularPlans/editDegree.jsp"), @Forward(name="deletePublication", path="/scientificCouncil/curricularPlans/deleteDegreeOfficialPublication.jsp")})
public class EditDegreeOfficialPublicationDA
extends FenixDispatchAction {
    public ActionForward preparePubs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeOfficialPublication degreeOfficialPublication = (DegreeOfficialPublication)((Object)request.getAttribute("officialPub"));
        if (degreeOfficialPublication == null) {
            degreeOfficialPublication = (DegreeOfficialPublication)FenixFramework.getDomainObject((String)request.getParameter("officialPubId"));
        }
        if (degreeOfficialPublication == null) {
            degreeOfficialPublication = (DegreeOfficialPublication)((Object)this.getRenderedObject("officialPub"));
        }
        OfficialPublicationBean officialPublicationBean = new OfficialPublicationBean(degreeOfficialPublication);
        request.setAttribute("officialPub", (Object)degreeOfficialPublication);
        request.setAttribute("pubBean", (Object)officialPublicationBean);
        request.setAttribute("referenceBean", (Object)officialPublicationBean);
        return mapping.findForward("prepare");
    }

    public ActionForward updateOfficialPub(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        boolean error = false;
        OfficialPublicationBean bean = (OfficialPublicationBean)this.getRenderedObject("referenceBean");
        if (bean.getNewReference().compareTo("") == 0) {
            this.addErrorMessage(request, "error", "confirm.error.edit.name.specializationArea", new Object[0]);
            error = true;
        }
        if (!error) {
            bean.getDegreeOfficialPublication().changeOfficialreference(bean.getNewReference(), bean.getPublication());
            this.addActionMessage("success", request, "confirm.success.edit.reference.officialPublication");
        }
        request.setAttribute("officialPub", (Object)bean.getDegreeOfficialPublication());
        return this.preparePubs(mapping, form, request, response);
    }

    public ActionForward updatePubs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState((String)"pubBean");
        return mapping.findForward("prepare");
    }

    public ActionForward updateArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        OfficialPublicationBean.SpecializationName name = (OfficialPublicationBean.SpecializationName)this.getRenderedObject("specializationArea");
        if (name.getEnName().compareTo("") == 0 || name.getPtName().compareTo("") == 0) {
            this.addErrorMessage(request, "error", "confirm.error.edit.name.specializationArea", new Object[0]);
        } else {
            name.update();
        }
        request.setAttribute("officialPub", (Object)name.getSpecializationArea().getOfficialPublication());
        return this.preparePubs(mapping, form, request, response);
    }

    public ActionForward removeSpecializationArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeSpecializationArea specializationArea = (DegreeSpecializationArea)FenixFramework.getDomainObject((String)request.getParameter("specializationId"));
        DegreeOfficialPublication degreeOfficialPublication = specializationArea.getOfficialPublication();
        OfficialPublicationBean bean = new OfficialPublicationBean(degreeOfficialPublication);
        bean.removeSpecializationArea(specializationArea);
        request.setAttribute("officialPub", (Object)degreeOfficialPublication);
        return this.preparePubs(mapping, form, request, response);
    }

    public ActionForward editSpecializationArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeSpecializationArea area = (DegreeSpecializationArea)FenixFramework.getDomainObject((String)request.getParameter("specializationId"));
        OfficialPublicationBean officialPublicationBean = new OfficialPublicationBean(area.getOfficialPublication());
        officialPublicationBean.getClass();
        request.setAttribute("specializationArea", (Object)new OfficialPublicationBean.SpecializationName(officialPublicationBean, area));
        return mapping.findForward("prepareSpecializationArea");
    }

    public ActionForward createNewSpecializationArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        OfficialPublicationBean bean = (OfficialPublicationBean)this.getRenderedObject("pubBean");
        DegreeOfficialPublication degreeOfficialPublication = bean.getDegreeOfficialPublication();
        if (bean.getNewNameEn().compareTo("") == 0 || bean.getNewNamePt().compareTo("") == 0) {
            this.addErrorMessage(request, "error", "confirm.error.edit.name.specializationArea", new Object[0]);
            request.setAttribute("officialPub", (Object)degreeOfficialPublication);
            return this.preparePubs(mapping, form, request, response);
        }
        degreeOfficialPublication.createSpecializationArea(bean.getNewNameEn(), bean.getNewNamePt());
        request.setAttribute("officialPub", (Object)degreeOfficialPublication);
        return this.preparePubs(mapping, form, request, response);
    }

    public ActionForward prepareDeleteDegreeOfficialPublication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String degreeId = request.getParameter("degreeId");
        String officialPubId = request.getParameter("officialPubId");
        DegreeOfficialPublication publication = (DegreeOfficialPublication)FenixFramework.getDomainObject((String)officialPubId);
        request.setAttribute("publication", (Object)publication);
        request.setAttribute("degreeId", (Object)degreeId);
        return mapping.findForward("deletePublication");
    }

    public ActionForward goToEditDegree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String degreeId = request.getParameter("degreeId");
        return new FenixActionForward(request, new ActionForward("/curricularPlans/editDegree.faces?degreeId=" + degreeId, false));
    }

    public ActionForward deleteDegreeOfficialPublication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String degreeId = request.getParameter("degreeId");
        String officialPubId = request.getParameter("officialPubId");
        DegreeOfficialPublication publication = (DegreeOfficialPublication)FenixFramework.getDomainObject((String)officialPubId);
        publication.delete();
        return new FenixActionForward(request, new ActionForward("/curricularPlans/editDegree.faces?degreeId=" + degreeId, false));
    }
}

