/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd;

import java.util.function.Predicate;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.util.predicates.InlinePredicate;
import org.fenixedu.academic.util.predicates.OrPredicate;
import org.fenixedu.academic.util.predicates.PredicateContainer;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public enum PhdInactivePredicateContainer implements PredicateContainer<PhdIndividualProgramProcess>
{
    SUSPENDED{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            return new PhdInactivePredicate(PhdIndividualProgramProcessState.SUSPENDED);
        }
    }
    ,
    CONCLUDED{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            return new PhdInactivePredicate(PhdIndividualProgramProcessState.CONCLUDED);
        }
    }
    ,
    CONCLUDED_THIS_YEAR{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            return new PhdInactivePredicate(PhdIndividualProgramProcessState.CONCLUDED){

                @Override
                public boolean test(PhdIndividualProgramProcess process2) {
                    return super.test(process2) && process2.getConclusionYear().equals(ExecutionYear.readCurrentExecutionYear());
                }
            };
        }
    }
    ,
    ABOLISHED{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            final PhdInactivePredicate cancelledPredicate = new PhdInactivePredicate(PhdIndividualProgramProcessState.CANCELLED);
            final PhdInactivePredicate flunkedPredicate = new PhdInactivePredicate(PhdIndividualProgramProcessState.FLUNKED);
            final PhdInactivePredicate notAdmittedPredicate = new PhdInactivePredicate(PhdIndividualProgramProcessState.NOT_ADMITTED);
            return new OrPredicate<PhdIndividualProgramProcess>(){
                {
                    this.add((Predicate)cancelledPredicate);
                    this.add((Predicate)flunkedPredicate);
                    this.add((Predicate)notAdmittedPredicate);
                }
            };
        }
    };


    @Override
    public String getLocalizedName() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)(PhdInactivePredicateContainer.class.getName() + "." + this.name()), (String[])new String[0]);
    }

    private static class PhdInactivePredicate
    extends InlinePredicate<PhdIndividualProgramProcess, PhdIndividualProgramProcessState> {
        public PhdInactivePredicate(PhdIndividualProgramProcessState processState) {
            super(processState);
        }

        @Override
        public boolean test(PhdIndividualProgramProcess process2) {
            return this.checkState(process2) && this.checkValue(process2);
        }

        private boolean checkState(PhdIndividualProgramProcess process2) {
            return !process2.getActiveState().isPhdActive();
        }

        private boolean checkValue(PhdIndividualProgramProcess process2) {
            return process2.getActiveState().equals(this.getValue());
        }
    }
}

