/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.operator;

import com.google.common.io.ByteStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PhotoType;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.person.PhotographUploadBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.operator.OperatorApplication;
import org.fenixedu.academic.ui.struts.action.operator.SubmitPhotoAction$callable$updatePersonPhoto;
import org.fenixedu.academic.util.ContentType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=OperatorApplication.class, path="submit-photo", titleKey="link.operator.submitPhoto")
@Mapping(module="operator", path="/submitPhoto")
@Forwards(value={@Forward(name="chooseFile", path="/operator/photo/submitPhoto_bd.jsp")})
public class SubmitPhotoAction
extends FenixDispatchAction {
    private static final int MAX_RAW_SIZE = 1000000;
    public static final Advice advice$updatePersonPhoto = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward preparePhotoUpload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("photo", (Object)new PhotographUploadBean());
        request.setAttribute("phroperCaption", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"phroper.caption", (String[])new String[0]));
        request.setAttribute("phroperSubCaption", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"phroper.subCaption", (String[])new String[0]));
        request.setAttribute("phroperButtonCaption", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"phroper.buttonCaption", (String[])new String[0]));
        request.setAttribute("phroperLoadingCaption", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"phroper.loadingCaption", (String[])new String[0]));
        request.setAttribute("buttonClean", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"button.clean", (String[])new String[0]));
        request.setAttribute("buttonRevert", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"button.phroper.revert", (String[])new String[0]));
        return mapping.findForward("chooseFile");
    }

    public ActionForward photoUpload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PhotographUploadBean photo = (PhotographUploadBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        String base64Thumbnail = request.getParameter("encodedThumbnail");
        String base64Image = request.getParameter("encodedPicture");
        if (base64Image != null && base64Thumbnail != null) {
            DateTime now = new DateTime();
            photo.setFilename("mylovelypic_" + now.getYear() + now.getMonthOfYear() + now.getDayOfMonth() + now.getHourOfDay() + now.getMinuteOfDay() + now.getSecondOfMinute() + ".png");
            photo.setBase64RawContent(base64Image.split(",")[1]);
            photo.setBase64RawThumbnail(base64Thumbnail.split(",")[1]);
            photo.setContentType(base64Image.split(",")[0].split(":")[1].split(";")[0]);
        }
        ActionMessages actionMessages = new ActionMessages();
        try (InputStream stream = photo.getFileInputStream();){
            if (stream == null) {
                actionMessages.add("error", new ActionMessage("errors.fileRequired"));
                this.saveMessages(request, actionMessages);
                ActionForward actionForward = this.preparePhotoUpload(mapping, actionForm, request, response);
                return actionForward;
            }
        }
        if (ContentType.getContentType(photo.getContentType()) == null) {
            actionMessages.add("error", new ActionMessage("errors.unsupportedFile"));
            this.saveMessages(request, actionMessages);
            return this.preparePhotoUpload(mapping, actionForm, request, response);
        }
        if (photo.getRawSize() > 1000000) {
            actionMessages.add("error", new ActionMessage("errors.fileTooLarge"));
            this.saveMessages(request, actionMessages);
            photo.deleteTemporaryFiles();
            return this.preparePhotoUpload(mapping, actionForm, request, response);
        }
        try {
            photo.processImage();
        }
        catch (PhotographUploadBean.UnableToProcessTheImage e) {
            actionMessages.add("error", new ActionMessage("errors.unableToProcessImage"));
            this.saveMessages(request, actionMessages);
            photo.deleteTemporaryFiles();
            return this.preparePhotoUpload(mapping, actionForm, request, response);
        }
        try {
            this.updatePersonPhoto(photo);
        }
        catch (Exception e) {
            actionMessages.add("error", new ActionMessage("errors.unableToSaveImage"));
            this.saveMessages(request, actionMessages);
            photo.deleteTemporaryFiles();
            return this.preparePhotoUpload(mapping, actionForm, request, response);
        }
        actionMessages.add("success", new ActionMessage("label.operator.submit.ok", (Object)""));
        this.saveMessages(request, actionMessages);
        return this.preparePhotoUpload(mapping, actionForm, request, response);
    }

    private void updatePersonPhoto(PhotographUploadBean photographUploadBean) throws FileNotFoundException, IOException {
        Object object = advice$updatePersonPhoto.perform((Callable)new SubmitPhotoAction$callable$updatePersonPhoto(this, photographUploadBean));
    }

    static /* synthetic */ void advised$updatePersonPhoto(SubmitPhotoAction this_, PhotographUploadBean photo) throws FileNotFoundException, IOException {
        if (photo.getUsername() == null) {
            throw new DomainException("error.operatorPhotoUpload.null.username", new String[0]);
        }
        Person person = Person.readPersonByUsername(photo.getUsername());
        if (person == null) {
            throw new DomainException("error.operatorPhotoUpload.invalid.username", new String[0]);
        }
        try (InputStream stream = photo.getFileInputStream();){
            person.setPersonalPhoto(new Photograph(PhotoType.INSTITUTIONAL, ContentType.getContentType(photo.getContentType()), ByteStreams.toByteArray((InputStream)stream)));
        }
    }
}

