/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.lists;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestYear;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.dto.academicAdministration.DegreeByExecutionYearBean;
import org.fenixedu.academic.dto.academicAdministration.DocumentRequestSearchBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.StyledExcelSpreadsheet;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminServicesApp.class, path="requests-by-degree", titleKey="lists.serviceRequestsByDegree", accessGroup="academic(SERVICE_REQUESTS)")
@Mapping(path="/requestListByDegree", module="academicAdministration")
@Forwards(value={@Forward(name="searchRequests", path="/academicAdminOffice/lists/searchRequestsByDegree.jsp")})
public class RequestListByDegreeDA
extends FenixDispatchAction {
    private static final String DATETIME_FORMAT = "dd-MM-yyyy HH:mm";

    @EntryPoint
    public ActionForward prepareSearch(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("degreeByExecutionYearBean", (Object)this.getOrCreateDegreeSearchBean());
        request.setAttribute("documentRequestSearchBean", (Object)this.getOrCreateRequestSearchBean());
        return mapping.findForward("searchRequests");
    }

    public ActionForward postBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DegreeByExecutionYearBean degreeSearchBean = this.getOrCreateDegreeSearchBean();
        DocumentRequestSearchBean requestSearchBean = this.getOrCreateRequestSearchBean();
        RenderUtils.invalidateViewState();
        request.setAttribute("degreeByExecutionYearBean", (Object)degreeSearchBean);
        request.setAttribute("documentRequestSearchBean", (Object)requestSearchBean);
        return mapping.findForward("searchRequests");
    }

    private DegreeByExecutionYearBean getOrCreateDegreeSearchBean() {
        DegreeByExecutionYearBean bean = (DegreeByExecutionYearBean)this.getRenderedObject("degreeByExecutionYearBean");
        return bean != null ? bean : new DegreeByExecutionYearBean(AcademicAccessRule.getDegreeTypesAccessibleToFunction(AcademicOperationType.SERVICE_REQUESTS, Authenticate.getUser()).collect(Collectors.toSet()), AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.SERVICE_REQUESTS, Authenticate.getUser()).collect(Collectors.toSet()));
    }

    private DocumentRequestSearchBean getOrCreateRequestSearchBean() {
        DocumentRequestSearchBean bean = (DocumentRequestSearchBean)this.getRenderedObject("documentRequestSearchBean");
        return bean != null ? bean : new DocumentRequestSearchBean();
    }

    public ActionForward runSearchAndShowResults(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DegreeByExecutionYearBean degreeSearchBean = this.getOrCreateDegreeSearchBean();
        DocumentRequestSearchBean requestSearchBean = this.getOrCreateRequestSearchBean();
        Set<RegistrationAcademicServiceRequest> requestList = this.search(degreeSearchBean, requestSearchBean);
        request.setAttribute("degreeByExecutionYearBean", (Object)degreeSearchBean);
        request.setAttribute("documentRequestSearchBean", (Object)requestSearchBean);
        request.setAttribute("registrationAcademicServiceRequestList", requestList);
        return mapping.findForward("searchRequests");
    }

    private Set<RegistrationAcademicServiceRequest> search(DegreeByExecutionYearBean degreeSearchBean, DocumentRequestSearchBean requestSearchBean) {
        ExecutionYear chosenExecutionYear = degreeSearchBean.getExecutionYear();
        TreeSet<RegistrationAcademicServiceRequest> resultList = new TreeSet<RegistrationAcademicServiceRequest>(RegistrationAcademicServiceRequest.COMPARATOR_BY_SERVICE_REQUEST_NUMBER_AND_ID);
        ArrayList<AcademicServiceRequest> requestList = new ArrayList<AcademicServiceRequest>();
        requestList.addAll(AcademicServiceRequestYear.getAcademicServiceRequests(chosenExecutionYear.getBeginCivilYear()));
        requestList.addAll(AcademicServiceRequestYear.getAcademicServiceRequests(chosenExecutionYear.getEndCivilYear()));
        return this.filterResults(degreeSearchBean, requestSearchBean, resultList, requestList);
    }

    private Set<RegistrationAcademicServiceRequest> filterResults(DegreeByExecutionYearBean degreeSearchBean, DocumentRequestSearchBean requestSearchBean, Set<RegistrationAcademicServiceRequest> resultList, ArrayList<AcademicServiceRequest> requestList) {
        Set accessiblePrograms = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.SERVICE_REQUESTS, Authenticate.getUser()).collect(Collectors.toSet());
        Set accessibleDegreeTypes = AcademicAccessRule.getDegreeTypesAccessibleToFunction(AcademicOperationType.SERVICE_REQUESTS, Authenticate.getUser()).collect(Collectors.toSet());
        Degree chosenDegree = degreeSearchBean.getDegree();
        DegreeType chosenDegreeType = degreeSearchBean.getDegreeType();
        ExecutionYear chosenExecutionYear = degreeSearchBean.getExecutionYear();
        AcademicServiceRequestType chosenServiceRequestType = requestSearchBean.getAcademicServiceRequestType();
        DocumentRequestType chosenDocumentRequestType = requestSearchBean.getChosenDocumentRequestType();
        AcademicServiceRequestSituationType chosenRequestSituation = requestSearchBean.getAcademicServiceRequestSituationType();
        for (AcademicServiceRequest academicServiceRequest : requestList) {
            if (!academicServiceRequest.isRequestForRegistration()) continue;
            RegistrationAcademicServiceRequest request = (RegistrationAcademicServiceRequest)((Object)academicServiceRequest);
            DegreeCurricularPlan degreeCurricularPlan = this.getMostRecentDegreeCurricularPlanForYear(request.getRegistration().getDegree(), chosenExecutionYear);
            if (chosenDegreeType != null && (degreeCurricularPlan == null || chosenDegreeType != degreeCurricularPlan.getDegreeType()) || degreeCurricularPlan != null && !degreeCurricularPlan.getDegreeType().isEmpty() && !accessibleDegreeTypes.contains(degreeCurricularPlan.getDegreeType()) || chosenDegree != null && chosenDegree != request.getRegistration().getDegree() || !accessiblePrograms.contains((Object)request.getAcademicProgram()) || chosenServiceRequestType != null && chosenServiceRequestType != request.getAcademicServiceRequestType()) continue;
            if (request.getAcademicServiceRequestType() == AcademicServiceRequestType.DOCUMENT) {
                DocumentRequestType documentType = ((DocumentRequest)((Object)request)).getDocumentRequestType();
                if (chosenDocumentRequestType != null && chosenDocumentRequestType != documentType) continue;
            }
            if (chosenRequestSituation != null && chosenRequestSituation != request.getActiveSituation().getAcademicServiceRequestSituationType() || requestSearchBean.isUrgentRequest() && !request.isUrgentRequest()) continue;
            resultList.add(request);
        }
        return resultList;
    }

    private DegreeCurricularPlan getMostRecentDegreeCurricularPlanForYear(Degree degree, ExecutionYear executionYear) {
        DegreeCurricularPlan degreeCurricularPlan = null;
        for (DegreeCurricularPlan plan : degree.getDegreeCurricularPlansForYear(executionYear)) {
            if (degreeCurricularPlan != null && !degreeCurricularPlan.getMostRecentExecutionDegree().isBefore(plan.getMostRecentExecutionDegree())) continue;
            degreeCurricularPlan = plan;
        }
        if (degreeCurricularPlan == null) {
            degreeCurricularPlan = degree.getMostRecentDegreeCurricularPlan();
        }
        return degreeCurricularPlan;
    }

    public ActionForward exportInfoToExcel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DegreeByExecutionYearBean degreeSearchBean = this.getOrCreateDegreeSearchBean();
        DocumentRequestSearchBean requestSearchBean = this.getOrCreateRequestSearchBean();
        if (degreeSearchBean == null || requestSearchBean == null) {
            return null;
        }
        Set<RegistrationAcademicServiceRequest> requestList = this.search(degreeSearchBean, requestSearchBean);
        try {
            String filename = RequestListByDegreeDA.getResourceMessage("label.requests");
            Degree degree = degreeSearchBean.getDegree();
            DegreeType degreeType = degreeSearchBean.getDegreeType();
            ExecutionYear executionYear = degreeSearchBean.getExecutionYear();
            if (degree != null) {
                filename = filename + "_" + degree.getNameFor(executionYear).getContent().replace(' ', '_');
            } else if (degreeType != null) {
                filename = filename + "_" + degreeType.getName().getContent().replace(' ', '_');
            }
            filename = filename + "_" + executionYear.getYear();
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment; filename=" + filename + ".xls");
            ServletOutputStream writer = response.getOutputStream();
            this.exportToXls(requestList, (OutputStream)writer, degreeSearchBean, requestSearchBean);
            writer.flush();
            response.flushBuffer();
            return null;
        }
        catch (IOException e) {
            throw new FenixServiceException();
        }
    }

    private void exportToXls(Set<RegistrationAcademicServiceRequest> requestList, OutputStream outputStream, DegreeByExecutionYearBean degreeSearchBean, DocumentRequestSearchBean requestSearchBean) throws IOException {
        StyledExcelSpreadsheet spreadsheet = new StyledExcelSpreadsheet(RequestListByDegreeDA.getResourceMessage("label.requestByDegree.unspaced"));
        this.fillSpreadSheetFilters(degreeSearchBean, requestSearchBean, spreadsheet);
        this.fillSpreadSheetResults(requestList, spreadsheet);
        spreadsheet.getWorkbook().write(outputStream);
    }

    private void fillSpreadSheetFilters(DegreeByExecutionYearBean degreeSearchBean, DocumentRequestSearchBean requestSearchBean, StyledExcelSpreadsheet spreadsheet) {
        AcademicServiceRequestType requestType = requestSearchBean.getAcademicServiceRequestType();
        DocumentRequestType documentType = requestSearchBean.getChosenDocumentRequestType();
        AcademicServiceRequestSituationType situationType = requestSearchBean.getAcademicServiceRequestSituationType();
        spreadsheet.newHeaderRow();
        if (requestType != null) {
            spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("label.type") + ": " + requestType.getLocalizedName());
        }
        if (documentType != null) {
            spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("label.documentRequestsManagement.searchDocumentRequests.documentRequestType") + ": " + documentType.getQualifiedName());
        }
        spreadsheet.newHeaderRow();
        if (situationType != null) {
            spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("label.state") + ": " + situationType.getLocalizedName());
        }
        spreadsheet.newHeaderRow();
        if (requestSearchBean.isUrgentRequest()) {
            spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("label.urgent.plural"));
        }
    }

    private void fillSpreadSheetResults(Set<RegistrationAcademicServiceRequest> requestList, StyledExcelSpreadsheet spreadsheet) {
        spreadsheet.newRow();
        spreadsheet.newRow();
        spreadsheet.addCell((Object)(requestList.size() + " " + RequestListByDegreeDA.getResourceMessage("label.requests")));
        this.setHeaders(spreadsheet);
        for (RegistrationAcademicServiceRequest request : requestList) {
            spreadsheet.newRow();
            spreadsheet.addCell((Object)request.getServiceRequestNumber());
            spreadsheet.addCell((Object)request.getRequestDate().toString(DATETIME_FORMAT));
            spreadsheet.addCell((Object)request.getDescription());
            spreadsheet.addCell((Object)request.getStudent().getNumber());
            spreadsheet.addCell((Object)request.getStudent().getName());
            spreadsheet.addCell((Object)request.getRegistration().getDegree().getPresentationName());
            spreadsheet.addCell((Object)"-");
        }
    }

    private void setHeaders(StyledExcelSpreadsheet spreadsheet) {
        spreadsheet.newHeaderRow();
        spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("label.serviceRequestNumber"));
        spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("label.requestDate"));
        spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("label.org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest.description"));
        spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("label.studentNumber"));
        spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("label.student.name"));
        spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("degree.concluded"));
        spreadsheet.addHeader(RequestListByDegreeDA.getResourceMessage("conclusion.date"));
    }

    private static String getResourceMessage(String key) {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)key, (String[])new String[0]);
    }
}

