/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.validator.DynaValidatorForm;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.InfoCurricularCourse;
import org.fenixedu.academic.dto.InfoDegree;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.comparators.ComparatorByNameForInfoExecutionDegree;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.AssociateCurricularCoursesToExecutionCourse;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.DissociateCurricularCourseByExecutionCourseId;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.ReadExecutionDegreesByExecutionPeriodId;
import org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement.EditExecutionCourseDA;
import org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement.ExecutionCourseBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.utils.RequestUtils;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="academicAdministration", path="/editExecutionCourseManageCurricularCourses", input="/editExecutionCourse.do?method=prepareEditExecutionCourse&page=0", formBean="executionCourseForm", functionality=EditExecutionCourseDA.class)
@Forwards(value={@Forward(name="editExecutionCourse", path="/academicAdministration/editExecutionCourse.do?method=editExecutionCourse&page=0"), @Forward(name="listExecutionCourseActions", path="/academicAdministration/executionCourseManagement/listExecutionCourseActions.jsp"), @Forward(name="manageCurricularSeparation", path="/academicAdministration/seperateExecutionCourse.do?method=manageCurricularSeparation"), @Forward(name="associateCurricularCourse", path="/academicAdministration/executionCourseManagement/associateCurricularCourse.jsp"), @Forward(name="prepareAssociateCurricularCourseChooseDegreeCurricularPlan", path="/academicAdministration/executionCourseManagement/prepareAssociateCurricularCourseChooseDegreeCurricularPlan.jsp")})
public class EditExecutionCourseManageCurricularCoursesDispatchAction
extends FenixDispatchAction {
    public ActionForward dissociateCurricularCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        String executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        String curricularCourseId = RequestUtils.getAndSetStringToRequest(request, "curricularCourseId");
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
        String executionCourseName = executionCourse.getName() + " [" + executionCourse.getDegreePresentationString() + "]";
        try {
            DissociateCurricularCourseByExecutionCourseId.run(executionCourseId, curricularCourseId);
            CurricularCourse curricularCourse = (CurricularCourse)FenixFramework.getDomainObject((String)curricularCourseId);
            this.addActionMessage("success", request, "message.manager.executionCourseManagement.dissociate.success", curricularCourse.getName(), curricularCourse.getDegreeCurricularPlan().getName());
        }
        catch (FenixServiceException e) {
            throw new FenixActionException(e);
        }
        SortedSet<Degree> degrees = executionCourse.getDegreesSortedByDegreeName();
        String originExecutionDegreeId = RequestUtils.getAndSetStringToRequest(request, "originExecutionDegreeId");
        ExecutionDegree originExecutionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)originExecutionDegreeId);
        request.setAttribute("originExecutionDegreeName", (Object)originExecutionDegree.getPresentationName());
        Boolean chooseNotLinked = Boolean.valueOf(RequestUtils.getAndSetStringToRequest(request, "executionCoursesNotLinked"));
        String curricularYearId = RequestUtils.getAndSetStringToRequest(request, "curricularYearId");
        if (!degrees.contains(originExecutionDegree.getDegree())) {
            ExecutionCourseBean sessionBean = new ExecutionCourseBean();
            sessionBean.setSourceExecutionCourse(executionCourse);
            sessionBean.setExecutionSemester(executionCourse.getExecutionPeriod());
            sessionBean.setChooseNotLinked(chooseNotLinked);
            CurricularYear curYear = (CurricularYear)FenixFramework.getDomainObject((String)curricularYearId);
            sessionBean.setExecutionDegree(originExecutionDegree);
            sessionBean.setCurricularYear(curYear);
            request.setAttribute("sessionBean", (Object)sessionBean);
            this.addActionMessage("info", request, "message.manager.executionCourseManagement.dissociate.success.switchContext", executionCourseName);
            return mapping.findForward("listExecutionCourseActions");
        }
        return mapping.findForward("manageCurricularSeparation");
    }

    public ActionForward prepareAssociateCurricularCourseChooseDegreeCurricularPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        String executionPeriodId = RequestUtils.getAndSetStringToRequest(request, "executionPeriodId");
        ArrayList<InfoExecutionDegree> executionDegreeList = new ArrayList();
        try {
            executionDegreeList = ReadExecutionDegreesByExecutionPeriodId.runForAcademicAdmin(executionPeriodId);
        }
        catch (FenixServiceException e) {
            throw new FenixActionException(e);
        }
        ArrayList<LabelValueBean> degrees = new ArrayList<LabelValueBean>();
        degrees.add(new LabelValueBean(BundleUtil.getString((String)"resources.AcademicRendererResources", (String)"renderers.menu.default.title", (String[])new String[0]), ""));
        Collections.sort(executionDegreeList, new ComparatorByNameForInfoExecutionDegree());
        this.buildExecutionDegreeLabelValueBean(executionDegreeList, degrees);
        request.setAttribute("licenciaturas", degrees);
        String executionCoursesNotLinked = RequestUtils.getAndSetStringToRequest(request, "executionCoursesNotLinked");
        if (StringUtils.isEmpty((String)executionCoursesNotLinked) || !Boolean.valueOf(executionCoursesNotLinked).booleanValue()) {
            String curricularYearId = RequestUtils.getAndSetStringToRequest(request, "curricularYearId");
            CurricularYear curYear = (CurricularYear)FenixFramework.getDomainObject((String)curricularYearId);
            request.setAttribute("curYear", (Object)curYear.getYear().toString());
            String originExecutionDegreeId = RequestUtils.getAndSetStringToRequest(request, "originExecutionDegreeId");
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)originExecutionDegreeId);
            request.setAttribute("originExecutionDegreeName", (Object)executionDegree.getPresentationName());
        }
        RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        RequestUtils.getAndSetStringToRequest(request, "executionCourseName");
        ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodId);
        request.setAttribute("executionPeriodName", (Object)executionSemester.getQualifiedName());
        return mapping.findForward("prepareAssociateCurricularCourseChooseDegreeCurricularPlan");
    }

    public ActionForward prepareAssociateCurricularCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        String executionCoursesNotLinked = RequestUtils.getAndSetStringToRequest(request, "executionCoursesNotLinked");
        if (StringUtils.isEmpty((String)executionCoursesNotLinked) || !Boolean.valueOf(executionCoursesNotLinked).booleanValue()) {
            String curricularYearId = RequestUtils.getAndSetStringToRequest(request, "curricularYearId");
            CurricularYear curYear = (CurricularYear)FenixFramework.getDomainObject((String)curricularYearId);
            request.setAttribute("curYear", (Object)curYear.getYear().toString());
            String originExecutionDegreeId = RequestUtils.getAndSetStringToRequest(request, "originExecutionDegreeId");
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)originExecutionDegreeId);
            request.setAttribute("originExecutionDegreeName", (Object)executionDegree.getPresentationName());
        }
        String executionPeriodId = RequestUtils.getAndSetStringToRequest(request, "executionPeriodId");
        ExecutionSemester executionPeriod = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodId);
        request.setAttribute("executionPeriodName", (Object)executionPeriod.getQualifiedName());
        RequestUtils.getAndSetStringToRequest(request, "executionCourseName");
        String degreeCurricularPlanId = RequestUtils.getAndSetStringToRequest(request, "degreeCurricularPlanId");
        DegreeCurricularPlan degreeCurricularPlan = null;
        if (!StringUtils.isEmpty((String)degreeCurricularPlanId)) {
            degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanId);
        }
        try {
            if (degreeCurricularPlan == null) {
                throw new DomainException("error.selection.noDegree", new String[0]);
            }
            request.setAttribute("degreeCurricularPlanName", (Object)degreeCurricularPlan.getPresentationName(executionPeriod.getExecutionYear()));
            request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
            String executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
            ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
            ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
            ArrayList<InfoCurricularCourse> infoCurricularCourses = new ArrayList<InfoCurricularCourse>();
            for (DegreeModule degreeModule : rootDomainObject.getDegreeModulesSet()) {
                if (!(degreeModule instanceof CurricularCourse)) continue;
                CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModule);
                if (executionCourse.getAssociatedCurricularCoursesSet().contains((Object)curricularCourse) || curricularCourse.hasAnyExecutionCourseIn(executionSemester) || !curricularCourse.hasScopeInGivenSemesterAndCurricularYearInDCP(null, degreeCurricularPlan, executionSemester)) continue;
                infoCurricularCourses.add(InfoCurricularCourse.newInfoFromDomain(curricularCourse));
            }
            Collections.sort(infoCurricularCourses, new BeanComparator("name"));
            request.setAttribute("infoCurricularCourses", infoCurricularCourses);
            return mapping.findForward("associateCurricularCourse");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            return this.prepareAssociateCurricularCourseChooseDegreeCurricularPlan(mapping, form, request, response);
        }
    }

    public ActionForward associateCurricularCourses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        DynaValidatorForm executionCourseForm = (DynaValidatorForm)form;
        RequestUtils.getAndSetStringToRequest(request, "executionPeriodId");
        RequestUtils.getAndSetStringToRequest(request, "executionPeriodName");
        String executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        Integer curricularCoursesListSize = (Integer)executionCourseForm.get("curricularCoursesListSize");
        List<String> curricularCourseIds = this.getInformationToDissociate(request, curricularCoursesListSize, "curricularCourse", "externalId", "chosen");
        try {
            AssociateCurricularCoursesToExecutionCourse.run(executionCourseId, curricularCourseIds);
            String degreeCurricularPlanId = RequestUtils.getAndSetStringToRequest(request, "degreeCurricularPlanId");
            DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanId);
            this.addActionMessage("success", request, "message.manager.executionCourseManagement.associateCourse.success", degreeCurricularPlan.getName());
            for (String curricularCourseId : curricularCourseIds) {
                CurricularCourse curricularCourse = (CurricularCourse)FenixFramework.getDomainObject((String)curricularCourseId);
                this.addActionMessage("successCourse", request, "message.manager.executionCourseManagement.associateCourse.success.line", curricularCourse.getName());
            }
        }
        catch (FenixServiceException e) {
            throw new FenixActionException(e);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
            return this.prepareAssociateCurricularCourse(mapping, (ActionForm)executionCourseForm, request, response);
        }
        RequestUtils.getAndSetStringToRequest(request, "originExecutionDegreeId");
        RequestUtils.getAndSetStringToRequest(request, "curricularYearId");
        return mapping.findForward("manageCurricularSeparation");
    }

    protected void buildExecutionDegreeLabelValueBean(List<InfoExecutionDegree> executionDegreeList, List<LabelValueBean> courses) {
        for (InfoExecutionDegree infoExecutionDegree : executionDegreeList) {
            String name = infoExecutionDegree.getInfoDegreeCurricularPlan().getDegreeCurricularPlan().getPresentationName(infoExecutionDegree.getInfoExecutionYear().getExecutionYear());
            courses.add(new LabelValueBean(name, infoExecutionDegree.getInfoDegreeCurricularPlan().getExternalId()));
        }
    }

    private List<String> getInformationToDissociate(HttpServletRequest request, Integer curricularCoursesListSize, String what, String property, String formProperty) {
        ArrayList<String> informationToDeleteList = new ArrayList<String>();
        for (int i = 0; i < curricularCoursesListSize; ++i) {
            String informationToDelete = this.dataToDelete(request, i, what, property, formProperty);
            if (informationToDelete == null) continue;
            informationToDeleteList.add(informationToDelete);
        }
        return informationToDeleteList;
    }

    private String dataToDelete(HttpServletRequest request, int index, String what, String property, String formProperty) {
        String itemToDelete = null;
        String checkbox = request.getParameter(what + "[" + index + "]." + formProperty);
        String toDelete = null;
        if (checkbox != null && (checkbox.equals("on") || checkbox.equals("yes") || checkbox.equals("true"))) {
            toDelete = request.getParameter(what + "[" + index + "]." + property);
        }
        if (toDelete != null) {
            itemToDelete = toDelete;
        }
        return itemToDelete;
    }

    private boolean duplicateInfoDegree(List executionDegreeList, InfoExecutionDegree infoExecutionDegree) {
        InfoDegree infoDegree = infoExecutionDegree.getInfoDegreeCurricularPlan().getInfoDegree();
        for (InfoExecutionDegree infoExecutionDegree2 : executionDegreeList) {
            if (!infoDegree.equals(infoExecutionDegree2.getInfoDegreeCurricularPlan().getInfoDegree()) || infoExecutionDegree.equals(infoExecutionDegree2)) continue;
            return true;
        }
        return false;
    }
}

