/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.degreeStructure;

import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.ui.renderers.degreeStructure.DegreeCurricularPlanLayout;
import org.fenixedu.academic.ui.renderers.degreeStructure.DegreeCurricularPlanRenderer;
import org.fenixedu.academic.util.CurricularPeriodLabelFormatter;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;

public class DegreeCurricularPlanGroupsLayout
extends DegreeCurricularPlanLayout {
    public DegreeCurricularPlanGroupsLayout(DegreeCurricularPlanRenderer degreeCurricularPlanRenderer) {
        super(degreeCurricularPlanRenderer);
    }

    @Override
    protected void draw(DegreeCurricularPlan degreeCurricularPlan, HtmlTable main) {
        this.drawCourseGroupRow((CourseGroup)((Object)degreeCurricularPlan.getRoot()), null, main, 0);
    }

    private void drawCourseGroupRow(CourseGroup courseGroup, Context previous, HtmlTable main, int level) {
        this.drawCourseGroupName(courseGroup, main, level);
        this.drawCurricularRulesRows((DegreeModule)((Object)courseGroup), previous, main, level + 1);
        this.drawCurricularCourseRows(courseGroup, main, level + 1);
        this.drawCourseGroupRows(courseGroup, main, level + 1);
    }

    private void drawCourseGroupRows(CourseGroup courseGroup, HtmlTable main, int level) {
        for (Context context : courseGroup.getSortedOpenChildContextsWithCourseGroups(this.getExecutionInterval())) {
            this.drawCourseGroupRow((CourseGroup)((Object)context.getChildDegreeModule()), context, main, level);
        }
    }

    private void drawCourseGroupName(CourseGroup courseGroup, HtmlTable mainTable, int level) {
        HtmlTableRow groupRow = mainTable.createRow();
        groupRow.setClasses(this.getCourseGroupRowClass());
        this.addTabsToRow(groupRow, level);
        HtmlTableCell cell = groupRow.createCell();
        cell.setClasses(this.getLabelCellClass());
        cell.setBody((HtmlComponent)new HtmlText(courseGroup.getNameI18N().getContent()));
        if (this.showCourses() && courseGroup.hasAnyChildContextWithCurricularCourse()) {
            cell.setColspan(Integer.valueOf(this.getMaxColSpanForTextOnGroupsWithChilds() - level));
            this.drawCurricularPeriodHeader(groupRow);
            this.drawCourseLoadHeader(groupRow);
            this.drawEctsCreditsHeader(groupRow);
        } else {
            cell.setColspan(Integer.valueOf(this.getMaxLineSize() - level));
        }
    }

    private void drawCurricularPeriodHeader(HtmlTableRow row) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getCourseLoadCellClass());
        cell.setColspan(Integer.valueOf(2));
        cell.setText(this.getLabel("label.degreeCurricularPlan.renderer.curricular.period"));
    }

    private void drawCourseLoadHeader(HtmlTableRow row) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getCourseLoadCellClass());
        cell.setText(this.getLabel("label.degreeCurricularPlan.renderer.course.load"));
    }

    private void drawEctsCreditsHeader(HtmlTableRow row) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getEctsCreditsCellClass());
        cell.setText(this.getLabel("label.degreeCurricularPlan.renderer.ects"));
    }

    private void drawCurricularCourseRows(CourseGroup courseGroup, HtmlTable main, int level) {
        if (this.showCourses()) {
            for (Context context : courseGroup.getSortedOpenChildContextsWithCurricularCourses(this.getExecutionInterval())) {
                this.drawCurricularCourseRow(context, main, level);
            }
        }
    }

    private void drawCurricularCourseRow(Context context, HtmlTable main, int level) {
        HtmlTableRow row = main.createRow();
        this.addTabsToRow(row, level);
        row.setClasses(this.getCurricularCourseRowClass());
        CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
        if (curricularCourse.isOptionalCurricularCourse()) {
            this.drawCurricularCourseName(curricularCourse, row, false, level);
            this.drawContextInformation(context.getCurricularPeriod(), row);
            this.drawOptionalCellInformation(row);
        } else if (curricularCourse.isSemestrial(this.getExecutionInterval())) {
            this.drawCurricularCourseName(curricularCourse, row, this.isCurricularCourseLinkable(), level);
            this.drawContextInformation(context.getCurricularPeriod(), row);
            this.drawRegime(curricularCourse, row);
            this.drawCourseLoad(curricularCourse, context.getCurricularPeriod(), row);
            this.drawEctsCredits(curricularCourse, context.getCurricularPeriod(), row);
        } else {
            this.drawAnualCurricularCourseRow(context, row, level);
        }
        this.drawCurricularRulesRows((DegreeModule)((Object)curricularCourse), context, main, level);
    }

    private void drawAnualCurricularCourseRow(Context context, HtmlTableRow row, int level) {
        CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
        if (curricularCourse.getCompetenceCourse() != null) {
            if (curricularCourse.getCompetenceCourse().hasOneCourseLoad(this.getExecutionInterval())) {
                this.drawCurricularCourseName(curricularCourse, row, this.isCurricularCourseLinkable(), level);
                this.drawContextInformation(context.getCurricularPeriod(), row);
                this.drawRegime(curricularCourse, row);
                this.drawCourseLoad(curricularCourse, context.getCurricularPeriod(), row);
                this.drawEctsCredits(curricularCourse, context.getCurricularPeriod(), row);
            } else {
                CurricularPeriod firstCP = context.getCurricularPeriod();
                ExecutionSemester firstES = this.getExecutionInterval().getExecutionSemesterFor(firstCP.getChildOrder());
                this.drawCurricularCourseName(curricularCourse, row, this.isCurricularCourseLinkable(), level);
                this.drawContextInformation(firstCP, row);
                this.drawRegime(curricularCourse, row);
                this.drawCourseLoad(curricularCourse, firstCP, firstES, row);
                this.drawEctsCredits(curricularCourse, firstCP, firstES, row);
                CurricularPeriod secondCP = context.getCurricularPeriod().getNext();
                ExecutionSemester secondES = this.getExecutionInterval().getExecutionSemesterFor(secondCP.getChildOrder());
                this.drawCurricularCourseName(curricularCourse, row, false, level);
                this.drawContextInformation(secondCP, row);
                this.drawRegime(curricularCourse, row);
                this.drawCourseLoad(curricularCourse, secondCP, secondES, row);
                this.drawEctsCredits(curricularCourse, secondCP, secondES, row);
            }
        } else {
            this.drawCurricularCourseName(curricularCourse, row, this.isCurricularCourseLinkable(), level);
            this.drawContextInformation(context.getCurricularPeriod(), row);
            this.drawRegime(curricularCourse, row);
            this.drawCourseLoad(curricularCourse, context.getCurricularPeriod(), row);
            this.drawEctsCredits(curricularCourse, context.getCurricularPeriod(), row);
        }
    }

    private void drawContextInformation(CurricularPeriod period, HtmlTableRow row) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getCurricularPeriodCellClass());
        cell.setText(CurricularPeriodLabelFormatter.getFullLabel(period, true));
    }

    private void drawCourseLoad(CurricularCourse course, CurricularPeriod period, ExecutionSemester interval, HtmlTableRow row) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getCourseLoadCellClass());
        if (course.isOptionalCurricularCourse()) {
            cell.setText("-");
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getLabel("label.degreeCurricularPlan.renderer.acronym.contact.load")).append("-");
            builder.append(this.roundValue(course.getContactLoad(period, interval))).append(" ");
            builder.append(this.getLabel("label.degreeCurricularPlan.renderer.acronym.autonomous.work")).append("-");
            builder.append(course.getAutonomousWorkHours(period, interval).toString()).append(" ");
            builder.append(this.getLabel("label.degreeCurricularPlan.renderer.acronym.total.load")).append("-");
            builder.append(course.getTotalLoad(period, interval));
            cell.setText(builder.toString());
        }
        cell.setTitle(this.getLabel("label.degreeCurricularPlan.renderer.title.course.load"));
    }

    private void drawEctsCredits(CurricularCourse course, CurricularPeriod period, ExecutionSemester interval, HtmlTableRow row) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getEctsCreditsCellClass());
        cell.setText(course.isOptionalCurricularCourse() ? "-" : course.getEctsCredits(period, interval).toString());
    }
}

