/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.fenixedu.academic.util.Money;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class MoneyRenderer
extends OutputRenderer {
    private String format;
    private static final String DEFAULT_FORMAT = "######0.00";

    public MoneyRenderer() {
        this.setFormat(DEFAULT_FORMAT);
    }

    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            public HtmlComponent createComponent(Object object, Class type) {
                if (object != null) {
                    BigDecimal number = ((Money)object).getAmount();
                    return new HtmlText(new DecimalFormat(MoneyRenderer.this.getFormat()).format(number));
                }
                return new HtmlText("");
            }
        };
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

