/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import org.fenixedu.academic.util.Money;
import pt.ist.fenixWebFramework.renderers.NumberInputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class MoneyInputRenderer
extends NumberInputRenderer {
    protected Converter getConverter() {
        return new MoneyConverter();
    }

    public HtmlComponent render(Object targetObject, Class type) {
        Money money = (Money)targetObject;
        return super.render((Object)(money != null ? money.getAmount() : null), type);
    }

    private static class MoneyConverter
    extends Converter {
        private MoneyConverter() {
        }

        public Object convert(Class type, Object value) {
            String numberText = ((String)value).trim();
            try {
                return numberText.length() == 0 ? null : new Money(numberText);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("renderers.converter.money", (Throwable)e, true, new Object[]{value});
            }
        }
    }
}

