/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.student.enrolment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.commons.ReadCurrentExecutionPeriod;
import org.fenixedu.academic.service.services.commons.ReadNotClosedExecutionPeriods;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.student.enrolment.ReadStudentByUsername;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixframework.FenixFramework;

public class DisplayEvaluationsForStudentToEnrol
extends FenixBackingBean {
    private static final ComparatorChain comparatorChain = new ComparatorChain();
    protected static final Integer ALL;
    protected static final Integer EXAMS;
    protected static final Integer WRITTENTESTS;
    private String executionPeriodID;
    protected Integer evaluationType;
    private ExecutionSemester executionSemester;
    private List<SelectItem> executionPeriodsLabels;
    private List<SelectItem> evaluationTypes;
    private Registration student;
    private List<Evaluation> allNotEnroledEvaluations;
    private List<Evaluation> notEnroledEvaluations;
    private List<Evaluation> enroledEvaluations;
    private List<Evaluation> evaluationsWithoutEnrolmentPeriod;
    private Map<String, List<ExecutionCourse>> executionCourses;

    public List<SelectItem> getExecutionPeriodsLabels() {
        if (this.executionPeriodsLabels == null) {
            this.executionPeriodsLabels = new ArrayList<SelectItem>();
            List<InfoExecutionPeriod> infoExecutionPeriods = this.getExecutionPeriods();
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator((Comparator)new ReverseComparator((Comparator)new BeanComparator("infoExecutionYear.year")));
            comparatorChain.addComparator((Comparator)new ReverseComparator((Comparator)new BeanComparator("semester")));
            Collections.sort(infoExecutionPeriods, comparatorChain);
            for (InfoExecutionPeriod infoExecutionPeriod : infoExecutionPeriods) {
                SelectItem selectItem = new SelectItem();
                selectItem.setValue((Object)infoExecutionPeriod.getExternalId());
                selectItem.setLabel(infoExecutionPeriod.getName() + " - " + infoExecutionPeriod.getInfoExecutionYear().getYear());
                this.executionPeriodsLabels.add(selectItem);
            }
        }
        return this.executionPeriodsLabels;
    }

    public List<SelectItem> getEvaluationTypes() {
        if (this.evaluationTypes == null) {
            this.evaluationTypes = new ArrayList<SelectItem>(4);
            String allEvaluations = BundleUtil.getString((String)"resources.StudentResources", (String)"link.all", (String[])new String[0]);
            this.evaluationTypes.add(new SelectItem((Object)ALL, allEvaluations));
            String exams = BundleUtil.getString((String)"resources.StudentResources", (String)"link.exams.enrolment", (String[])new String[0]);
            this.evaluationTypes.add(new SelectItem((Object)EXAMS, exams));
            String writtenTests = BundleUtil.getString((String)"resources.StudentResources", (String)"link.writtenTests.enrolment", (String[])new String[0]);
            this.evaluationTypes.add(new SelectItem((Object)WRITTENTESTS, writtenTests));
        }
        return this.evaluationTypes;
    }

    public List<Evaluation> getAllNotEnroledEvaluations() {
        if (this.allNotEnroledEvaluations == null) {
            this.allNotEnroledEvaluations = new ArrayList<Evaluation>();
            this.processAllEvaluations();
        }
        return this.allNotEnroledEvaluations;
    }

    public List<Evaluation> getNotEnroledEvaluations() {
        if (this.notEnroledEvaluations == null) {
            this.notEnroledEvaluations = new ArrayList<Evaluation>();
            this.processNotEnroledEvaluations();
        }
        return this.notEnroledEvaluations;
    }

    public void setNotEnroledEvaluations(List<Evaluation> notEnroledEvaluations) {
        this.notEnroledEvaluations = notEnroledEvaluations;
    }

    public List<Evaluation> getEnroledEvaluations() {
        if (this.enroledEvaluations == null) {
            this.enroledEvaluations = new ArrayList<Evaluation>();
            this.processEnroledEvaluations();
        }
        return this.enroledEvaluations;
    }

    public void setEnroledEvaluations(List<Evaluation> enroledEvaluations) {
        this.enroledEvaluations = enroledEvaluations;
    }

    public List<Evaluation> getEvaluationsWithoutEnrolmentPeriod() {
        if (this.evaluationsWithoutEnrolmentPeriod == null) {
            this.evaluationsWithoutEnrolmentPeriod = new ArrayList<Evaluation>();
        }
        return this.evaluationsWithoutEnrolmentPeriod;
    }

    public void setEvaluationsWithoutEnrolmentPeriod(List<Evaluation> evaluationsWithoutEnrolmentPeriod) {
        this.evaluationsWithoutEnrolmentPeriod = evaluationsWithoutEnrolmentPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEnroledEvaluations() {
        if (this.getEvaluationType().equals(ALL) || this.getEvaluationType().equals(EXAMS)) {
            for (Registration registration : this.getStudent().getStudent().getRegistrationsSet()) {
                for (Exam exam : registration.getEnroledExams(this.getExecutionPeriod())) {
                    try {
                        exam.isInEnrolmentPeriod();
                        this.enroledEvaluations.add((Evaluation)((Object)exam));
                    }
                    catch (DomainException e) {
                        this.getEvaluationsWithoutEnrolmentPeriod().add((Evaluation)((Object)exam));
                    }
                    finally {
                        this.getExecutionCourses().put(exam.getExternalId(), exam.getAttendingExecutionCoursesFor(registration));
                    }
                }
            }
        }
        if (this.getEvaluationType().equals(ALL) || this.getEvaluationType().equals(WRITTENTESTS)) {
            for (Registration registration : this.getStudent().getStudent().getRegistrationsSet()) {
                for (WrittenTest writtenTest : registration.getEnroledWrittenTests(this.getExecutionPeriod())) {
                    try {
                        writtenTest.isInEnrolmentPeriod();
                        this.enroledEvaluations.add((Evaluation)((Object)writtenTest));
                    }
                    catch (DomainException e) {
                        this.getEvaluationsWithoutEnrolmentPeriod().add((Evaluation)((Object)writtenTest));
                    }
                    finally {
                        this.getExecutionCourses().put(writtenTest.getExternalId(), writtenTest.getAttendingExecutionCoursesFor(registration));
                    }
                }
            }
        }
        Collections.sort(this.enroledEvaluations, comparatorChain);
    }

    private void processAllEvaluations() {
        if (this.getEvaluationType().equals(ALL) || this.getEvaluationType().equals(EXAMS)) {
            for (Registration registration : this.getStudent().getStudent().getRegistrationsSet()) {
                for (Exam exam : registration.getUnenroledExams(this.getExecutionPeriod())) {
                    if (!exam.isExamsMapPublished()) continue;
                    this.allNotEnroledEvaluations.add((Evaluation)((Object)exam));
                    this.getExecutionCourses().put(exam.getExternalId(), exam.getAttendingExecutionCoursesFor(registration));
                }
            }
        }
        if (this.getEvaluationType().equals(ALL) || this.getEvaluationType().equals(WRITTENTESTS)) {
            for (Registration registration : this.getStudent().getStudent().getRegistrationsSet()) {
                for (WrittenTest writtenTest : registration.getUnenroledWrittenTests(this.getExecutionPeriod())) {
                    this.allNotEnroledEvaluations.add((Evaluation)((Object)writtenTest));
                    this.getExecutionCourses().put(writtenTest.getExternalId(), writtenTest.getAttendingExecutionCoursesFor(registration));
                }
            }
        }
        Collections.sort(this.allNotEnroledEvaluations, comparatorChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotEnroledEvaluations() {
        if (this.getEvaluationType().equals(ALL) || this.getEvaluationType().equals(EXAMS)) {
            for (Registration registration : this.getStudent().getStudent().getRegistrationsSet()) {
                for (Exam exam : registration.getUnenroledExams(this.getExecutionPeriod())) {
                    if (!exam.isExamsMapPublished()) continue;
                    try {
                        exam.isInEnrolmentPeriod();
                        this.notEnroledEvaluations.add((Evaluation)((Object)exam));
                    }
                    catch (DomainException e) {
                        this.getEvaluationsWithoutEnrolmentPeriod().add((Evaluation)((Object)exam));
                    }
                    finally {
                        this.getExecutionCourses().put(exam.getExternalId(), exam.getAttendingExecutionCoursesFor(registration));
                    }
                }
            }
        }
        if (this.getEvaluationType().equals(ALL) || this.getEvaluationType().equals(WRITTENTESTS)) {
            for (Registration registration : this.getStudent().getStudent().getRegistrationsSet()) {
                for (WrittenTest writtenTest : registration.getUnenroledWrittenTests(this.getExecutionPeriod())) {
                    try {
                        writtenTest.isInEnrolmentPeriod();
                        this.notEnroledEvaluations.add((Evaluation)((Object)writtenTest));
                    }
                    catch (DomainException e) {
                        this.getEvaluationsWithoutEnrolmentPeriod().add((Evaluation)((Object)writtenTest));
                    }
                    finally {
                        this.getExecutionCourses().put(writtenTest.getExternalId(), writtenTest.getAttendingExecutionCoursesFor(registration));
                    }
                }
            }
        }
        Collections.sort(this.notEnroledEvaluations, comparatorChain);
    }

    public void changeExecutionPeriod(ValueChangeEvent event) {
        this.clearAttributes();
    }

    public void changeEvaluationType(ValueChangeEvent event) {
        this.clearAttributes();
    }

    protected void clearAttributes() {
        this.setNotEnroledEvaluations(null);
        this.setEnroledEvaluations(null);
        this.setEvaluationsWithoutEnrolmentPeriod(null);
        this.setExecutionCourses(null);
    }

    private List<InfoExecutionPeriod> getExecutionPeriods() {
        try {
            return ReadNotClosedExecutionPeriods.run();
        }
        catch (FenixServiceException fenixServiceException) {
            return new ArrayList<InfoExecutionPeriod>();
        }
    }

    private InfoExecutionPeriod getCurrentExecutionPeriod() {
        return ReadCurrentExecutionPeriod.run();
    }

    protected ExecutionSemester getExecutionPeriod() {
        return this.executionSemester == null && this.getExecutionPeriodID() != null ? (ExecutionSemester)FenixFramework.getDomainObject((String)this.getExecutionPeriodID()) : this.executionSemester;
    }

    protected Registration getStudent() {
        if (this.student == null) {
            try {
                this.student = ReadStudentByUsername.run(this.getUserView().getUsername());
            }
            catch (IllegalDataAccessException illegalDataAccessException) {
            }
            catch (FenixServiceException fenixServiceException) {
                // empty catch block
            }
        }
        return this.student;
    }

    public String getExecutionPeriodID() {
        if (this.getRequestParameter("executionPeriodID") != null) {
            this.executionPeriodID = this.getRequestParameter("executionPeriodID");
        }
        if (this.executionPeriodID == null) {
            this.executionPeriodID = this.getCurrentExecutionPeriod().getExternalId();
        }
        return this.executionPeriodID;
    }

    public void setExecutionPeriodID(String executionPeriodID) {
        this.executionPeriodID = executionPeriodID;
    }

    public Integer getEvaluationType() {
        if (this.evaluationType == null) {
            this.evaluationType = ALL;
        }
        return this.evaluationType;
    }

    public String getEvaluationTypeString() {
        Integer type = this.getEvaluationType();
        if (type != null && type.equals(EXAMS)) {
            return "org.fenixedu.academic.domain.Exam";
        }
        if (type != null && type.equals(WRITTENTESTS)) {
            return "org.fenixedu.academic.domain.WrittenTest";
        }
        return "";
    }

    public void setEvaluationType(Integer evaluationType) {
        this.evaluationType = evaluationType;
    }

    public Map<String, List<ExecutionCourse>> getExecutionCourses() {
        if (this.executionCourses == null) {
            this.executionCourses = new HashMap<String, List<ExecutionCourse>>();
        }
        return this.executionCourses;
    }

    public void setExecutionCourses(Map<String, List<ExecutionCourse>> executionCourses) {
        this.executionCourses = executionCourses;
    }

    static {
        comparatorChain.addComparator((Comparator)new ReverseComparator((Comparator)new BeanComparator("isInEnrolmentPeriod")));
        comparatorChain.addComparator((Comparator)new BeanComparator("dayDate"));
        ALL = 0;
        EXAMS = 1;
        WRITTENTESTS = 2;
    }
}

