/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.teacher;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenEvaluationEnrolment;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.service.filter.ExecutionCourseAndExamLecturingTeacherAuthorizationFilter;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.teacher.WrittenEvaluationRoomDistribution$callable$runWrittenEvaluationRoomDistribution;
import org.fenixedu.spaces.domain.Space;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class WrittenEvaluationRoomDistribution {
    private static final WrittenEvaluationRoomDistribution serviceInstance;
    public static final Advice advice$runWrittenEvaluationRoomDistribution;

    protected void run(String executionCourseID, String evaluationID, List<String> roomIDs, Boolean distributeOnlyEnroledStudents) throws FenixServiceException {
        WrittenEvaluation writtenEvaluation = (WrittenEvaluation)FenixFramework.getDomainObject((String)evaluationID);
        if (writtenEvaluation == null) {
            throw new FenixServiceException("error.noWrittenEvaluation");
        }
        List<Registration> studentsToDistribute = distributeOnlyEnroledStudents != false ? this.readEnroledStudentsInWrittenEvaluation(writtenEvaluation) : this.readAllStudentsAttendingExecutionCourses(writtenEvaluation);
        List<Space> selectedRooms = this.readRooms(writtenEvaluation, roomIDs);
        if (!selectedRooms.containsAll(writtenEvaluation.getAssociatedRooms())) {
            throw new FenixServiceException("error.repeated.rooms");
        }
        writtenEvaluation.distributeStudentsByRooms(studentsToDistribute, selectedRooms);
    }

    private List<Space> readRooms(WrittenEvaluation writtenEvaluation, List<String> roomIDs) {
        List<String> selectedRoomIDs = this.removeDuplicatedEntries(roomIDs);
        List<Space> writtenEvaluationRooms = writtenEvaluation.getAssociatedRooms();
        ArrayList<Space> selectedRooms = new ArrayList<Space>(selectedRoomIDs.size());
        block0: for (String roomID : selectedRoomIDs) {
            for (Space room : writtenEvaluationRooms) {
                if (!room.getExternalId().equals(roomID)) continue;
                selectedRooms.add(room);
                continue block0;
            }
        }
        return selectedRooms;
    }

    private List<String> removeDuplicatedEntries(List<String> roomIDs) {
        ArrayList<String> result = new ArrayList<String>();
        for (String roomID : roomIDs) {
            if (result.contains(roomID)) continue;
            result.add(roomID);
        }
        return result;
    }

    private List<Registration> readEnroledStudentsInWrittenEvaluation(WrittenEvaluation writtenEvaluation) {
        ArrayList<Registration> result = new ArrayList<Registration>(writtenEvaluation.getWrittenEvaluationEnrolmentsSet().size());
        for (WrittenEvaluationEnrolment writtenEvaluationEnrolment : writtenEvaluation.getWrittenEvaluationEnrolmentsSet()) {
            result.add(writtenEvaluationEnrolment.getStudent());
        }
        return result;
    }

    private List<Registration> readAllStudentsAttendingExecutionCourses(WrittenEvaluation writtenEvaluation) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (ExecutionCourse executionCourse : writtenEvaluation.getAssociatedExecutionCoursesSet()) {
            for (Attends attend : executionCourse.getAttendsSet()) {
                if (result.contains((Object)attend.getRegistration())) continue;
                result.add(attend.getRegistration());
            }
        }
        return result;
    }

    public static void runWrittenEvaluationRoomDistribution(String string, String string2, List<String> list, Boolean bl) throws FenixServiceException, NotAuthorizedException {
        Object object = advice$runWrittenEvaluationRoomDistribution.perform((Callable)new WrittenEvaluationRoomDistribution$callable$runWrittenEvaluationRoomDistribution(string, string2, list, bl));
    }

    static /* synthetic */ void advised$runWrittenEvaluationRoomDistribution(String executionCourseID, String evaluationID, List<String> roomIDs, Boolean distributeOnlyEnroledStudents) throws FenixServiceException, NotAuthorizedException {
        ExecutionCourseAndExamLecturingTeacherAuthorizationFilter.instance.execute(executionCourseID, evaluationID);
        serviceInstance.run(executionCourseID, evaluationID, roomIDs, distributeOnlyEnroledStudents);
    }

    static {
        advice$runWrittenEvaluationRoomDistribution = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new WrittenEvaluationRoomDistribution();
    }
}

