/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.service.filter.Filtro;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixframework.FenixFramework;

public class ReadShiftsByExecutionCourseIDAuthorizationFilter
extends Filtro {
    public static final ReadShiftsByExecutionCourseIDAuthorizationFilter instance = new ReadShiftsByExecutionCourseIDAuthorizationFilter();

    public void execute(String executionCourseID) throws NotAuthorizedException {
        User id = Authenticate.getUser();
        if ((id != null && !this.containsRoleType(id) || id != null && !this.hasPrivilege(id, executionCourseID) || id == null) && !this.lecturesExecutionCourse(id, executionCourseID)) {
            throw new NotAuthorizedException();
        }
    }

    @Override
    protected Collection<RoleType> getNeededRoleTypes() {
        ArrayList<RoleType> roles = new ArrayList<RoleType>();
        roles.add(RoleType.RESOURCE_ALLOCATION_MANAGER);
        roles.add(RoleType.COORDINATOR);
        return roles;
    }

    private boolean hasPrivilege(User id, String executionCourseID) {
        if (RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(id.getPerson().getUser())) {
            return true;
        }
        if (RoleType.COORDINATOR.isMember(id.getPerson().getUser())) {
            Person person = id.getPerson();
            ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
            for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
                Set executionDegrees = curricularCourse.getDegreeCurricularPlan().getExecutionDegreesSet();
                for (ExecutionDegree executionDegree : executionDegrees) {
                    Coordinator coordinator = executionDegree.getCoordinatorByTeacher(person);
                    if (coordinator == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean lecturesExecutionCourse(User id, String executionCourseID) {
        if (executionCourseID == null) {
            return false;
        }
        try {
            Teacher teacher = Teacher.readTeacherByUsername(id.getUsername());
            Object professorship = null;
            if (teacher != null) {
                ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
                teacher.getProfessorshipByExecutionCourse(executionCourse);
            }
            return professorship != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

