/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.commons.curriculumHistoric;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.EvaluationSeason_Base;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.commons.curriculumHistoric.InfoEnrolmentHistoricReport;
import org.fenixedu.commons.i18n.LocalizedString;

public class InfoCurriculumHistoricReport
implements Serializable {
    int evaluated = 0;
    int approved = 0;
    Collection<InfoEnrolmentHistoricReport> enrolments;
    CurricularCourse curricularCourse;
    AcademicInterval academicInterval;

    public Integer getApproved() {
        return this.approved;
    }

    public Integer getEvaluated() {
        return this.evaluated;
    }

    public Collection<InfoEnrolmentHistoricReport> getEnrolments() {
        return this.enrolments;
    }

    public Integer getEnroled() {
        return this.getEnrolments().size();
    }

    public Integer getRatioApprovedEnroled() {
        return Math.round((float)this.getApproved().intValue() / (float)this.getEnroled().intValue() * 100.0f);
    }

    public Integer getRatioApprovedEvaluated() {
        return Math.round((float)this.getApproved().intValue() / (float)this.getEvaluated().intValue() * 100.0f);
    }

    public CurricularCourse getCurricularCourse() {
        return this.curricularCourse;
    }

    private void setCurricularCourse(CurricularCourse curricularCourse) {
        this.curricularCourse = curricularCourse;
    }

    public InfoCurriculumHistoricReport(AcademicInterval academicInterval, CurricularCourse curricularCourse) {
        this.setAcademicInterval(academicInterval);
        this.setCurricularCourse(curricularCourse);
        this.init();
    }

    private void init() {
        this.enrolments = new TreeSet<InfoEnrolmentHistoricReport>((Comparator<InfoEnrolmentHistoricReport>)new BeanComparator("enrolment.studentCurricularPlan.registration.number"));
        for (Enrolment enrolment : this.getCurricularCourse().getEnrolmentsByAcademicInterval(this.academicInterval)) {
            if (enrolment.isAnnulled()) continue;
            this.enrolments.add(new InfoEnrolmentHistoricReport(enrolment));
            if (!enrolment.isEvaluated()) continue;
            ++this.evaluated;
            if (!enrolment.isEnrolmentStateApproved()) continue;
            ++this.approved;
        }
    }

    public AcademicInterval getAcademicInterval() {
        return this.academicInterval;
    }

    public void setAcademicInterval(AcademicInterval academicInterval) {
        this.academicInterval = academicInterval;
    }

    public List<String> getEvaluationSeasons() {
        return EvaluationSeason.all().sorted().map(EvaluationSeason_Base::getName).map(LocalizedString::getContent).collect(Collectors.toList());
    }
}

