/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftGroupingProperties;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.dto.InfoClass;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.NumberUtils;

public class InfoShift
extends InfoObject {
    public static final Comparator<InfoShift> SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS = new Comparator<InfoShift>(){

        @Override
        public int compare(InfoShift o1, InfoShift o2) {
            int c1 = o1.getShift().getExecutionCourse().getNome().compareTo(o2.getShift().getExecutionCourse().getNome());
            if (c1 != 0) {
                return c1;
            }
            int c2 = o1.getShiftTypesIntegerComparator().compareTo(o2.getShiftTypesIntegerComparator());
            if (c2 != 0) {
                return c2;
            }
            int c3 = o1.getLessonsStringComparator().compareTo(o2.getLessonsStringComparator());
            return c3 == 0 ? o1.getShift().getExternalId().compareTo(o2.getShift().getExternalId()) : c3;
        }
    };
    private final Shift shift;
    private Integer capacity;

    public InfoShift(Shift shift) {
        this.shift = shift;
        ShiftGroupingProperties groupingProperties = this.getShift().getShiftGroupingProperties();
        this.capacity = groupingProperties != null ? groupingProperties.getCapacity() : Integer.valueOf(0);
    }

    public Integer getSize() {
        return this.getShift().getAssociatedClassesSet().size();
    }

    public String getNome() {
        return this.getShift().getNome();
    }

    public InfoExecutionCourse getInfoDisciplinaExecucao() {
        return InfoExecutionCourse.newInfoFromDomain(this.getShift().getExecutionCourse());
    }

    public Set<ShiftType> getSortedTypes() {
        return this.getShift().getSortedTypes();
    }

    public Integer getShiftTypesIntegerComparator() {
        return this.getShift().getShiftTypesIntegerComparator();
    }

    public String getLessonsStringComparator() {
        return this.getShift().getLessonsStringComparator();
    }

    public String getShiftTypesPrettyPrint() {
        return this.getShift().getShiftTypesPrettyPrint();
    }

    public String getShiftTypesCodePrettyPrint() {
        return this.getShift().getShiftTypesCodePrettyPrint();
    }

    public Integer getLotacao() {
        return this.getShift().getLotacao();
    }

    public Integer getOcupation() {
        return this.getShift().getStudentsSet().size();
    }

    public Integer getGroupCapacity() {
        return this.capacity;
    }

    public void setGroupCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public Double getPercentage() {
        return NumberUtils.formatNumber(Double.valueOf(this.getOcupation().floatValue() * 100.0f / this.getLotacao().floatValue()), 1);
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getShift() == ((InfoShift)obj).getShift();
    }

    public String toString() {
        return this.getShift().toString();
    }

    public String getLessons() {
        StringBuilder stringBuilder = new StringBuilder();
        List<InfoLesson> infoLessonsList = this.getInfoLessons();
        if (infoLessonsList != null) {
            int index = 0;
            for (InfoLesson infoLesson : infoLessonsList) {
                int last;
                ++index;
                stringBuilder.append(infoLesson.getDiaSemana().toString());
                stringBuilder.append(" (");
                stringBuilder.append(DateFormatUtil.format("HH:mm", infoLesson.getInicio().getTime()));
                stringBuilder.append("-");
                stringBuilder.append(DateFormatUtil.format("HH:mm", infoLesson.getFim().getTime()));
                stringBuilder.append(") ");
                if (infoLesson.getInfoSala() != null) {
                    stringBuilder.append(infoLesson.getInfoSala().getNome().toString());
                }
                if (index != (last = infoLessonsList.size()) || index != 1 && index != last) {
                    stringBuilder.append(" , ");
                    continue;
                }
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }

    public List<InfoLesson> getInfoLessons() {
        ArrayList<InfoLesson> infoLessons = new ArrayList<InfoLesson>();
        for (Lesson lesson : this.getShift().getLessonsOrderedByWeekDayAndStartTime()) {
            infoLessons.add(InfoLesson.newInfoFromDomain(lesson));
        }
        return infoLessons;
    }

    public List<InfoClass> getInfoClasses() {
        ArrayList<InfoClass> infoClasses = new ArrayList<InfoClass>();
        for (SchoolClass schoolClass : this.getShift().getAssociatedClassesSet()) {
            infoClasses.add(InfoClass.newInfoFromDomain(schoolClass));
        }
        return infoClasses;
    }

    @Override
    public String getExternalId() {
        return this.getShift().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }

    public static InfoShift newInfoFromDomain(Shift shift) {
        return shift == null ? null : new InfoShift(shift);
    }

    public Shift getShift() {
        return this.shift;
    }

    public boolean containsType(ShiftType shiftType) {
        return this.getShift().containsType(shiftType);
    }

    public String getComment() {
        return this.getShift().getComment();
    }

    @Override
    public int hashCode() {
        if (this.getExternalId() != null) {
            return this.getExternalId().hashCode();
        }
        return 0;
    }

    public static List<InfoShift> getInfoShiftsByType(ExecutionCourse executionCourse, ShiftType shiftType) {
        SortedSet<Shift> shifts = executionCourse.getShiftsOrderedByLessons();
        ArrayList<InfoShift> shiftsList = new ArrayList<InfoShift>();
        if (shifts.size() != 0) {
            for (Shift shift : shifts) {
                if (!shift.containsType(shiftType)) continue;
                InfoShift infoShift = new InfoShift(shift);
                shiftsList.add(infoShift);
            }
            return shiftsList;
        }
        return null;
    }
}

