/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.treasury;

import java.math.BigDecimal;
import java.util.List;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEventPayment;
import org.fenixedu.academic.domain.treasury.IPaymentReferenceCode;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.LocalDate;

public interface IAcademicTreasuryEvent {
    public LocalizedString getDescription();

    public String getDebtAccountURL();

    public boolean isTuitionEvent();

    public boolean isAcademicServiceRequestEvent();

    public boolean isAcademicTax();

    public boolean isImprovementTax();

    public boolean isCharged();

    public boolean isExempted();

    default public boolean isPayed() {
        return this.isCharged() && this.getRemainingAmountToPay().compareTo(BigDecimal.ZERO) <= 0;
    }

    default public boolean isInDebt() {
        return this.isCharged() && this.getRemainingAmountToPay().compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean isDueDateExpired(LocalDate var1);

    public boolean isBlockingAcademicalActs(LocalDate var1);

    public BigDecimal getAmountToPay();

    public BigDecimal getInterestsAmountToPay();

    public BigDecimal getRemainingAmountToPay();

    public BigDecimal getExemptedAmount();

    public LocalDate getDueDate();

    public String getExemptionReason();

    public List<IAcademicTreasuryEventPayment> getPaymentsList();

    public String formatMoney(BigDecimal var1);

    public List<IPaymentReferenceCode> getPaymentReferenceCodesList();

    public boolean isOnlinePaymentsActive();

    public void annulDebts(String var1);
}

