/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.time.calendarStructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry_Base;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.domain.time.chronologies.AcademicChronology;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class AcademicCalendarRootEntry
extends AcademicCalendarRootEntry_Base {
    private volatile transient AcademicChronology academicChronology;

    public AcademicCalendarRootEntry(MultiLanguageString title, MultiLanguageString description, AcademicCalendarEntry templateCalendar) {
        this.setRootDomainObjectForRootEntries(Bennu.getInstance());
        this.setTitle(title);
        this.setDescription(description);
        this.setTemplateEntry(templateCalendar);
    }

    public AcademicCalendarEntry edit(MultiLanguageString title, MultiLanguageString description, DateTime begin, DateTime end, AcademicCalendarRootEntry rootEntryDestination, AcademicCalendarEntry templateEntry) {
        this.setTitle(title);
        this.setDescription(description);
        this.setTemplateEntry(templateEntry);
        return this;
    }

    public void delete(AcademicCalendarRootEntry rootEntry) {
        super.setRootDomainObjectForRootEntries(null);
        super.delete(rootEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AcademicChronology getAcademicChronology() {
        if (this.academicChronology != null) return this.academicChronology;
        Class<AcademicCalendarRootEntry> clazz = AcademicCalendarRootEntry.class;
        synchronized (AcademicCalendarRootEntry.class) {
            if (this.academicChronology != null) return this.academicChronology;
            this.academicChronology = new AcademicChronology(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.academicChronology;
        }
    }

    public void setTemplateEntry(AcademicCalendarEntry templateEntry) {
        if (!(templateEntry == null || this.getChildEntriesSet().isEmpty() || this.getTemplateEntry() != null && this.getTemplateEntry().equals(templateEntry))) {
            throw new DomainException("error.RootEntry.invalid.templateEntry", new String[0]);
        }
        super.setTemplateEntry(templateEntry);
    }

    public void setRootDomainObjectForRootEntries(Bennu rootDomainObjectForRootEntries) {
        if (rootDomainObjectForRootEntries == null) {
            throw new DomainException("error.RootEntry.empty.rootDomainObject.to.academic.calendars", new String[0]);
        }
        super.setRootDomainObjectForRootEntries(rootDomainObjectForRootEntries);
    }

    public DateTime getBegin() {
        DateTime begin = null;
        Collection result = null;
        result = this.getTemplateEntry() == null ? this.getChildEntriesSet() : this.getChildEntriesWithTemplateEntries();
        for (AcademicCalendarEntry entry : result) {
            if (begin != null && !entry.getBegin().isBefore((ReadableInstant)begin)) continue;
            begin = entry.getBegin();
        }
        return begin;
    }

    public AcademicCalendarEntry getEntryByInstant(long instant, Class<? extends AcademicCalendarEntry> entryClass, Class<? extends AcademicCalendarEntry> parentEntryClass) {
        AcademicCalendarEntry entryResult = null;
        for (AcademicCalendarEntry entry : this.getChildEntriesWithTemplateEntries(instant, entryClass, parentEntryClass)) {
            entryResult = entryResult == null || entry.getBegin().isAfter((ReadableInstant)entryResult.getBegin()) ? entry : entryResult;
        }
        return entryResult;
    }

    public Integer getEntryIndexByInstant(long instant, Class<? extends AcademicCalendarEntry> entryClass, Class<? extends AcademicCalendarEntry> parentEntryClass) {
        Integer counter = null;
        for (AcademicCalendarEntry entry : this.getChildEntriesWithTemplateEntries(entryClass, parentEntryClass)) {
            if (!entry.containsInstant(instant) && !entry.getEnd().isBefore(instant)) continue;
            counter = counter == null ? 1 : counter + 1;
        }
        return counter;
    }

    public AcademicCalendarEntry getEntryByIndex(int index, Class<? extends AcademicCalendarEntry> entryClass, Class<? extends AcademicCalendarEntry> parentEntryClass) {
        List<AcademicCalendarEntry> allChildEntries = this.getChildEntriesWithTemplateEntries(entryClass, parentEntryClass);
        Collections.sort(allChildEntries, COMPARATOR_BY_BEGIN_DATE);
        return index > 0 && index <= allChildEntries.size() ? allChildEntries.get(index - 1) : null;
    }

    public static AcademicCalendarRootEntry getAcademicCalendarByTitle(String title) {
        for (AcademicCalendarRootEntry rootEntry : Bennu.getInstance().getAcademicCalendarsSet()) {
            if (!rootEntry.getTitle().getContent().equals(title)) continue;
            return rootEntry;
        }
        return null;
    }

    public List<AcademicCalendarEntry> getChildEntriesWithTemplateEntries(Class<? extends AcademicCalendarEntry> subEntryClass, Class<? extends AcademicCalendarEntry> parentEntryClass) {
        return this.getChildEntriesWithTemplateEntries(null, subEntryClass, parentEntryClass);
    }

    public List<AcademicCalendarEntry> getChildEntriesWithTemplateEntries(Long instant, Class<? extends AcademicCalendarEntry> subEntryClass, Class<? extends AcademicCalendarEntry> parentEntryClass) {
        if (subEntryClass == null || parentEntryClass == null) {
            return Collections.emptyList();
        }
        ArrayList<AcademicCalendarEntry> allChildEntries = new ArrayList<AcademicCalendarEntry>();
        this.getFirstChildEntriesWithTemplateEntries(instant, subEntryClass, parentEntryClass, allChildEntries);
        return allChildEntries;
    }

    public DateTime getEnd() {
        return null;
    }

    public void setBegin(DateTime begin) {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    public void setEnd(DateTime end) {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    public void setParentEntry(AcademicCalendarEntry parentEntry) {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    protected AcademicCalendarEntry createVirtualEntry(AcademicCalendarEntry parentEntry) {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    protected boolean areIntersectionsPossible(AcademicCalendarEntry entryToAdd) {
        return entryToAdd.isAcademicYear();
    }

    protected boolean isPossibleToChangeTimeInterval() {
        return false;
    }

    protected boolean exceededNumberOfChildEntries(AcademicCalendarEntry childEntry) {
        return false;
    }

    protected boolean isParentEntryInvalid(AcademicCalendarEntry parentEntry) {
        return true;
    }

    public boolean isOfType(AcademicPeriod period) {
        return false;
    }

    public boolean isRoot() {
        return true;
    }

    public boolean containsInstant(long instant) {
        return true;
    }

    protected boolean associatedWithDomainEntities() {
        return false;
    }
}

