/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.curriculum.ExtraCurricularActivity$callable$delete;
import org.fenixedu.academic.domain.student.curriculum.ExtraCurricularActivityType;
import org.fenixedu.academic.domain.student.curriculum.ExtraCurricularActivity_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Interval;
import org.joda.time.Partial;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ExtraCurricularActivity
extends ExtraCurricularActivity_Base {
    private static final int MAX_ACTIVITIES = 5;
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public ExtraCurricularActivity(Student student, ExtraCurricularActivityType type, Interval interval) {
        this.checkParameters(student, type, interval);
        this.setRootDomainObject(Bennu.getInstance());
        this.setStudent(student);
        this.setType(type);
        this.setActivityInterval(interval);
    }

    public ExtraCurricularActivity(Student student, ExtraCurricularActivityType type, Partial start, Partial end) {
        this(student, type, new Interval((ReadableInstant)start.toDateTime((ReadableInstant)new DateTime(0L)), (ReadableInstant)end.toDateTime((ReadableInstant)new DateTime(0L))));
    }

    private void checkParameters(Student student, ExtraCurricularActivityType type, Interval interval) {
        HashSet<ExtraCurricularActivityType> existing = new HashSet<ExtraCurricularActivityType>();
        for (ExtraCurricularActivity activity : student.getExtraCurricularActivitySet()) {
            existing.add(activity.getType());
            if (!activity.getType().equals((Object)type) || !activity.getActivityInterval().overlaps((ReadableInterval)interval)) continue;
            throw new DomainException("error.extraCurricularActivity.overlaping", new String[0]);
        }
        if (existing.size() == 5) {
            throw new DomainException("error.extraCurricularActivity.maxActivitiesLimitReached", Integer.toString(5));
        }
    }

    public boolean getIsDeletable() {
        return this.getFeaturedDiploma() == null;
    }

    public void setStudent(Student student) {
        if (!this.getIsDeletable()) {
            throw new DomainException("information.already.featured.in.official.document", new String[0]);
        }
        super.setStudent(student);
    }

    public void setType(ExtraCurricularActivityType type) {
        if (!this.getIsDeletable()) {
            throw new DomainException("information.already.featured.in.official.document", new String[0]);
        }
        super.setType(type);
    }

    public void setActivityInterval(Interval interval) {
        if (!this.getIsDeletable()) {
            throw new DomainException("information.already.featured.in.official.document", new String[0]);
        }
        super.setActivityInterval(interval);
    }

    public Partial getStart() {
        DateTime start = this.getActivityInterval().getStart();
        return new Partial().with(DateTimeFieldType.year(), start.getYear()).with(DateTimeFieldType.monthOfYear(), start.getMonthOfYear());
    }

    public void setStart(Partial start) {
        this.setActivityInterval(new Interval((ReadableInstant)start.toDateTime((ReadableInstant)new DateTime(0L)), (ReadableInstant)this.getActivityInterval().getEnd()));
    }

    public Partial getEnd() {
        DateTime end = this.getActivityInterval().getEnd();
        return new Partial().with(DateTimeFieldType.year(), end.getYear()).with(DateTimeFieldType.monthOfYear(), end.getMonthOfYear());
    }

    public void setEnd(Partial end) {
        this.setActivityInterval(new Interval((ReadableInstant)this.getActivityInterval().getStart(), (ReadableInstant)end.toDateTime((ReadableInstant)new DateTime(0L))));
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ExtraCurricularActivity$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ExtraCurricularActivity this_) {
        if (!this_.getIsDeletable()) {
            throw new DomainException("information.already.featured.in.official.document", new String[0]);
        }
        this_.setType(null);
        this_.setStudent(null);
        this_.setRootDomainObject(null);
        this_.deleteDomainObject();
    }
}

