/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.residence;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.QueueJobResult;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.residence.StudentsPerformanceReport$callable$launchJob;
import org.fenixedu.academic.domain.residence.StudentsPerformanceReport_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class StudentsPerformanceReport
extends StudentsPerformanceReport_Base {
    private static final Logger logger;
    public static final Comparator<StudentsPerformanceReport> COMPARE_BY_REQUEST_DATE;
    public static final Advice advice$launchJob;

    private StudentsPerformanceReport() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setRootDomainObjectQueueUndone(Bennu.getInstance());
    }

    private StudentsPerformanceReport(ExecutionSemester executionSemester, List<Student> studentList) {
        this();
        if (executionSemester == null) {
            throw new DomainException("error.students.performance.report.execution.semester.is.null", new String[0]);
        }
        if (studentList == null || studentList.isEmpty()) {
            throw new DomainException("error.students.performance.report.is.null.or.empty", new String[0]);
        }
        this.setExecutionSemester(executionSemester);
        this.getStudentsSet().addAll(studentList);
    }

    public QueueJobResult execute() throws Exception {
        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
        Spreadsheet spreadsheet = this.createSpreadsheet();
        for (Student student : this.getStudentsSet()) {
            this.addInformation(spreadsheet, student);
        }
        spreadsheet.exportToXLSSheet((OutputStream)byteArrayOS);
        QueueJobResult queueJobResult = new QueueJobResult();
        queueJobResult.setContentType("application/txt");
        queueJobResult.setContent(byteArrayOS.toByteArray());
        logger.info("Job " + this.getFilename() + " completed");
        return queueJobResult;
    }

    public String getFilename() {
        return "Candidatos_Residencia_" + this.getExecutionSemester().getName() + new DateTime().toString("dd_MM_yyyy") + ".txt";
    }

    public static List<StudentsPerformanceReport> readGeneratedReports(ExecutionSemester executionSemester) {
        ArrayList<StudentsPerformanceReport> generatedReports = new ArrayList<StudentsPerformanceReport>();
        CollectionUtils.select((Collection)executionSemester.getStudentsPerformanceReportsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((StudentsPerformanceReport)((Object)arg0)).getDone();
            }
        }, generatedReports);
        return generatedReports;
    }

    public static List<StudentsPerformanceReport> readNotGeneratedReports(ExecutionSemester executionSemester) {
        ArrayList<StudentsPerformanceReport> generatedReports = new ArrayList<StudentsPerformanceReport>();
        CollectionUtils.select((Collection)executionSemester.getStudentsPerformanceReportsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((StudentsPerformanceReport)((Object)arg0)).getDone() == false;
            }
        }, generatedReports);
        return generatedReports;
    }

    public static StudentsPerformanceReport readPendingReport(ExecutionSemester executionSemester) {
        ArrayList pendingReports = new ArrayList();
        CollectionUtils.select((Collection)executionSemester.getStudentsPerformanceReportsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((StudentsPerformanceReport)((Object)arg0)).getIsNotDoneAndNotCancelled();
            }
        }, pendingReports);
        if (pendingReports.isEmpty()) {
            return null;
        }
        Collections.sort(pendingReports, Collections.reverseOrder(COMPARE_BY_REQUEST_DATE));
        return (StudentsPerformanceReport)((Object)pendingReports.iterator().next());
    }

    public static boolean hasPendingReports(ExecutionSemester executionSemester) {
        return StudentsPerformanceReport.readPendingReport(executionSemester) != null;
    }

    public static StudentsPerformanceReport launchJob(ExecutionSemester executionSemester, List<Student> list) {
        return (StudentsPerformanceReport)((Object)advice$launchJob.perform((Callable)new StudentsPerformanceReport$callable$launchJob(executionSemester, list)));
    }

    static /* synthetic */ StudentsPerformanceReport advised$launchJob(ExecutionSemester executionSemester, List<Student> students) {
        return new StudentsPerformanceReport(executionSemester, students);
    }

    private BigDecimal getApprovedECTS(Student student) {
        return student.getLastActiveRegistration().getCurriculum(this.getExecutionSemester().getEndDateYearMonthDay().toDateTimeAtCurrentTime(), this.getExecutionSemester().getExecutionYear(), null).getSumEctsCredits();
    }

    private BigDecimal getEnrolledECTS(Student student) {
        StudentCurricularPlan scp = StudentsPerformanceReport.getStudentCurricularPlan(student, this.getExecutionSemester());
        BigDecimal totalECTS = new BigDecimal(0.0);
        for (CurriculumLine curriculumLine : scp.getAllCurriculumLines()) {
            if (curriculumLine.isExtraCurricular() || curriculumLine.getExecutionPeriod().isAfter(this.getExecutionSemester())) continue;
            if (curriculumLine.isEnrolment()) {
                Enrolment enrolment = (Enrolment)((Object)curriculumLine);
                totalECTS = totalECTS.add(enrolment.getEctsCreditsForCurriculum());
                continue;
            }
            if (curriculumLine.isDismissal()) {
                Dismissal dismissal = (Dismissal)((Object)curriculumLine);
                if (dismissal.getCredits().isSubstitution()) {
                    for (IEnrolment enrolment : dismissal.getSourceIEnrolments()) {
                        totalECTS = totalECTS.add(enrolment.getEctsCreditsForCurriculum());
                    }
                    continue;
                }
                if (!dismissal.getCredits().isEquivalence()) continue;
                totalECTS = totalECTS.add(dismissal.getEctsCreditsForCurriculum());
                continue;
            }
            throw new RuntimeException("error.unknown.curriculumLine");
        }
        return totalECTS;
    }

    private int getApprovedGradeValuesSum(Student student) {
        Collection<ICurriculumEntry> entries = student.getLastActiveRegistration().getCurriculum(this.getExecutionSemester().getEndDateYearMonthDay().toDateTimeAtCurrentTime(), this.getExecutionSemester().getExecutionYear(), null).getCurriculumEntries();
        BigDecimal sum = new BigDecimal(0.0);
        for (ICurriculumEntry entry : entries) {
            if (!entry.getGrade().isNumeric()) continue;
            BigDecimal weigth = entry.getWeigthForCurriculum();
            if (!GradeScale.TYPE20.equals((Object)entry.getGrade().getGradeScale())) continue;
            sum = sum.add(entry.getGrade().getNumericValue());
        }
        return sum.intValue();
    }

    private int getNumberOfApprovedCourses(Student student) {
        Collection<ICurriculumEntry> entries = student.getLastActiveRegistration().getCurriculum(this.getExecutionSemester().getEndDateYearMonthDay().toDateTimeAtCurrentTime(), this.getExecutionSemester().getExecutionYear(), null).getCurriculumEntries();
        return entries.size() * 20;
    }

    private BigDecimal getA(Student student) {
        return BigDecimal.ZERO.equals(this.getEnrolledECTS(student)) ? BigDecimal.ZERO : this.getApprovedECTS(student).divide(this.getEnrolledECTS(student), 2, RoundingMode.HALF_EVEN);
    }

    private BigDecimal getB(Student student) {
        return this.getNumberOfApprovedCourses(student) == 0 ? BigDecimal.ZERO : new BigDecimal(this.getApprovedGradeValuesSum(student)).divide(new BigDecimal(this.getNumberOfApprovedCourses(student)), 2, RoundingMode.HALF_EVEN);
    }

    private static StudentCurricularPlan getStudentCurricularPlan(Student student, ExecutionSemester semester) {
        List<Registration> registrations = student.getActiveRegistrationsIn(semester);
        if (registrations.size() != 1) {
            throw new DomainException("student.has.more.than.one.active.registration", new String[0]);
        }
        Registration registration = registrations.iterator().next();
        StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
        if (!studentCurricularPlan.isBolonhaDegree()) {
            throw new DomainException("student.curricular.plan.is.not.bolonha", new String[0]);
        }
        return studentCurricularPlan;
    }

    private Spreadsheet createSpreadsheet() {
        Spreadsheet spreadsheet = new Spreadsheet("students");
        spreadsheet.setHeaders(new String[]{"Num Aluno", "Nome", "Tipo Curso", "Curso", "Ciclo", "Ects Aprovados", "Ects Total", "Soma classificacoes", "Num Aprovadas * 20", "A", "B", "100 * (A + B)"});
        return spreadsheet;
    }

    private void addInformation(Spreadsheet spreadsheet, Student student) {
        StudentCurricularPlan studentCurricularPlan = StudentsPerformanceReport.getStudentCurricularPlan(student, this.getExecutionSemester());
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(student.getNumber());
        row.setCell(student.getPerson().getName());
        row.setCell(studentCurricularPlan.getDegreeType().getName().getContent());
        row.setCell(studentCurricularPlan.getName());
        row.setCell(studentCurricularPlan.getRegistration().getCycleType(this.getExecutionSemester().getExecutionYear()).getDescription());
        row.setCell(this.getApprovedECTS(student).toPlainString());
        row.setCell(this.getEnrolledECTS(student).toPlainString());
        row.setCell(Integer.valueOf(this.getApprovedGradeValuesSum(student)));
        row.setCell(Integer.valueOf(this.getNumberOfApprovedCourses(student)));
        row.setCell(this.getA(student).toPlainString());
        row.setCell(this.getB(student).toPlainString());
        row.setCell(Integer.valueOf(this.getA(student).add(this.getB(student)).multiply(BigDecimal.valueOf(100L)).intValue()));
    }

    static {
        advice$launchJob = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(StudentsPerformanceReport.class);
        COMPARE_BY_REQUEST_DATE = new Comparator<StudentsPerformanceReport>(){

            @Override
            public int compare(StudentsPerformanceReport o1, StudentsPerformanceReport o2) {
                return o1.getRequestDate().compareTo((ReadableInstant)o2.getRequestDate());
            }
        };
    }
}

