/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.LocalDate;

public class SetFinalGrade
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (!process2.isJuryValidated()) {
            throw new PreConditionNotValidException();
        }
        if (process2.getActiveState() != PhdThesisProcessStateType.WAITING_FOR_FINAL_GRADE) {
            throw new PreConditionNotValidException();
        }
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        for (PhdProgramDocumentUploadBean each : bean.getDocuments()) {
            if (!each.hasAnyInformation()) continue;
            process2.addDocument(each, userView.getPerson());
        }
        this.checkParameters(bean);
        LocalDate conclusionDate = bean.getConclusionDate();
        process2.setConclusionDate(conclusionDate);
        process2.setFinalGrade(bean.getFinalGrade());
        if (!process2.hasState(PhdThesisProcessStateType.CONCLUDED)) {
            process2.createState(PhdThesisProcessStateType.CONCLUDED, userView.getPerson(), bean.getRemarks());
        }
        return process2;
    }

    private void checkParameters(PhdThesisProcessBean bean) {
        if (bean.getFinalGrade() == null) {
            throw new DomainException("error.SetFinalGrade.invalid.grade", new String[0]);
        }
        if (bean.getConclusionDate() == null) {
            throw new DomainException("error.SetFinalGrade.invalid.conclusion.date", new String[0]);
        }
    }
}

