/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.serviceRequests;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdDocumentRequestCreateBean$callable$createNewRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDiplomaRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDocumentRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdRegistryDiplomaRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.certificates.PhdFinalizationCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdDocumentRequestCreateBean
extends PhdAcademicServiceRequestCreateBean {
    private static final long serialVersionUID = 1L;
    private String givenNames;
    private String familyNames;
    private DocumentRequestType documentRequestType;
    public static final Advice advice$createNewRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createNewRequest$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PhdDocumentRequestCreateBean(PhdIndividualProgramProcess phdIndividualProgramProcess) {
        super(phdIndividualProgramProcess);
        this.setRequestType(AcademicServiceRequestType.DOCUMENT);
        this.setGivenAndFamilyNames();
    }

    private void setGivenAndFamilyNames() {
        Person person = this.getPhdIndividualProgramProcess().getPerson();
        if (StringUtils.isEmpty((String)person.getGivenNames())) {
            String[] parts = person.getName().split("\\s+");
            int split = parts.length > 3 ? 2 : 1;
            this.setGivenNames(StringUtils.join((Object[])Arrays.copyOfRange(parts, 0, split), (String)" "));
            this.setFamilyNames(StringUtils.join((Object[])Arrays.copyOfRange(parts, split, parts.length), (String)" "));
        } else {
            this.setGivenNames(person.getGivenNames());
            this.setFamilyNames(person.getFamilyNames());
        }
    }

    public String getGivenNames() {
        return this.givenNames;
    }

    public void setGivenNames(String givenNames) {
        this.givenNames = givenNames;
    }

    public String getFamilyNames() {
        return this.familyNames;
    }

    public void setFamilyNames(String familyNames) {
        this.familyNames = familyNames;
    }

    public DocumentRequestType getDocumentRequestType() {
        return this.documentRequestType;
    }

    public void setDocumentRequestType(DocumentRequestType documentRequestType) {
        this.documentRequestType = documentRequestType;
    }

    public PhdDocumentRequest createNewRequest() {
        return (PhdDocumentRequest)advice$createNewRequest.perform((Callable)new PhdDocumentRequestCreateBean$callable$createNewRequest(this));
    }

    static /* synthetic */ PhdDocumentRequest advised$createNewRequest(PhdDocumentRequestCreateBean this_) {
        switch (this_.getDocumentRequestType()) {
            case DIPLOMA_REQUEST: {
                return PhdDiplomaRequest.create(this_);
            }
            case REGISTRY_DIPLOMA_REQUEST: {
                return PhdRegistryDiplomaRequest.create(this_);
            }
            case PHD_FINALIZATION_CERTIFICATE: {
                return PhdFinalizationCertificateRequest.create(this_);
            }
        }
        throw new DomainException("error.PhdAcademicServiceRequest.create.document.request.type.unknown", new String[0]);
    }

    static /* bridge */ /* synthetic */ PhdAcademicServiceRequest advised$createNewRequest(PhdDocumentRequestCreateBean this_) {
        return this_.createNewRequest();
    }
}

