/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.migration;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.phd.migration.common.ConversionUtilities;
import org.fenixedu.academic.domain.phd.migration.common.NationalityTranslator;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.IncompleteFieldsException;
import org.fenixedu.academic.util.StringFormatter;
import org.joda.time.LocalDate;

public class PhdMigrationIndividualPersonalDataBean
implements Serializable {
    private static final long serialVersionUID = 1863846900977920325L;
    private String data;
    private Person chosenPersonManually;
    private Integer phdStudentNumber;
    private String identificationNumber;
    private String socialSecurityNumber;
    private String fullName;
    private String familyName;
    private LocalDate dateOfBirth;
    private Gender gender;
    private Country nationality;
    private String parishOfResidence;
    private String districtSubdivisionOfResidence;
    private String districtOfResidence;
    private String fatherName;
    private String motherName;
    private String address;
    private String areaCode;
    private String area;
    private String areaOfAreaCode;
    private String contactNumber;
    private String otherContactNumber;
    private String profession;
    private String workPlace;
    private String email;

    public PhdMigrationIndividualPersonalDataBean(String data) {
        this.setData(data);
        this.parse();
    }

    public void parse() {
        String[] fields = this.getData().split("\t");
        try {
            try {
                this.phdStudentNumber = Integer.valueOf(fields[0].trim());
            }
            catch (NumberFormatException e) {
                throw new IncompleteFieldsException("processNumber");
            }
            this.identificationNumber = fields[1].trim();
            this.socialSecurityNumber = this.parseSocialSecurityNumber(fields[2].trim());
            this.fullName = StringFormatter.prettyPrint(fields[3].trim());
            this.familyName = StringFormatter.prettyPrint(fields[4].trim());
            this.dateOfBirth = ConversionUtilities.parseDate(fields[5].trim());
            this.gender = ConversionUtilities.parseGender(fields[6].trim());
            this.nationality = NationalityTranslator.translate(fields[7].trim());
            this.parishOfResidence = fields[8].trim();
            this.districtSubdivisionOfResidence = fields[9].trim();
            this.districtOfResidence = fields[10].trim();
            this.fatherName = fields[11].trim();
            this.motherName = fields[12].trim();
            this.address = fields[13].trim();
            this.areaCode = fields[14].trim();
            this.areaOfAreaCode = this.area = fields[15].trim();
            this.contactNumber = fields[16].trim();
            this.otherContactNumber = fields[17].trim();
            this.profession = fields[18].trim();
            this.workPlace = fields[19].trim();
            this.email = fields[20].trim();
        }
        catch (NoSuchElementException e) {
            throw new IncompleteFieldsException("Not enough fields");
        }
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Integer getPhdStudentNumber() {
        return this.phdStudentNumber;
    }

    public void setPhdStudentNumber(Integer phdStudentNumber) {
        this.phdStudentNumber = phdStudentNumber;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Country getNationality() {
        return this.nationality;
    }

    public void setNationality(Country nationality) {
        this.nationality = nationality;
    }

    public String getParishOfResidence() {
        return this.parishOfResidence;
    }

    public void setParishOfResidence(String parishOfResidence) {
        this.parishOfResidence = parishOfResidence;
    }

    public String getDistrictSubdivisionOfResidence() {
        return this.districtSubdivisionOfResidence;
    }

    public void setDistrictSubdivisionOfResidence(String districtSubdivisionOfResidence) {
        this.districtSubdivisionOfResidence = districtSubdivisionOfResidence;
    }

    public String getDistrictOfResidence() {
        return this.districtOfResidence;
    }

    public void setDistrictOfResidence(String districtOfResidence) {
        this.districtOfResidence = districtOfResidence;
    }

    public String getFatherName() {
        return this.fatherName;
    }

    public void setFatherName(String fatherName) {
        this.fatherName = fatherName;
    }

    public String getMotherName() {
        return this.motherName;
    }

    public void setMotherName(String motherName) {
        this.motherName = motherName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaOfAreaCode() {
        return this.areaOfAreaCode;
    }

    public void setAreaOfAreaCode(String areaOfAreaCode) {
        this.areaOfAreaCode = areaOfAreaCode;
    }

    public String getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    public String getOtherContactNumber() {
        return this.otherContactNumber;
    }

    public void setOtherContactNumber(String otherContactNumber) {
        this.otherContactNumber = otherContactNumber;
    }

    public String getProfession() {
        return this.profession;
    }

    public void setProfession(String profession) {
        this.profession = profession;
    }

    public String getWorkPlace() {
        return this.workPlace;
    }

    public void setWorkPlace(String workPlace) {
        this.workPlace = workPlace;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Person getChosenPersonManually() {
        return this.chosenPersonManually;
    }

    public void setChosenPersonManually(Person chosenPersonManually) {
        this.chosenPersonManually = chosenPersonManually;
    }

    public boolean hasChosenPersonManually() {
        return this.chosenPersonManually != null;
    }

    private String parseSocialSecurityNumber(String socialSecurityNumber) {
        if (socialSecurityNumber.matches("/--+|0+/")) {
            return null;
        }
        return socialSecurityNumber;
    }
}

