/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage;
import org.fenixedu.academic.domain.phd.alert.PhdPublicPresentationSeminarAlert_Base;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.User_Base;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class PhdPublicPresentationSeminarAlert
extends PhdPublicPresentationSeminarAlert_Base {
    private static final int FIRST_WARNING_DAYS = 30;
    private static int MAX_DAYS = 720;
    private static int MAX_DAYS_AFTER_LIMIT_REACHED = 90;

    private PhdPublicPresentationSeminarAlert() {
    }

    public PhdPublicPresentationSeminarAlert(PhdIndividualProgramProcess process2) {
        this();
        super.init(process2, this.buildSubject(process2), this.buildBody(process2));
    }

    private MultiLanguageString buildSubject(PhdIndividualProgramProcess process2) {
        return new MultiLanguageString(Locale.getDefault(), AlertService.getSubjectPrefixed(process2, AlertService.AlertMessage.create("message.phd.alert.public.presentation.seminar.subject", new Object[0])));
    }

    private MultiLanguageString buildBody(PhdIndividualProgramProcess process2) {
        int days = this.getDaysUntilNow(process2.getWhenStartedStudies());
        return new MultiLanguageString(Locale.getDefault(), AlertService.getBodyText(process2, AlertService.AlertMessage.create("message.phd.alert.public.presentation.seminar.body", process2.getWhenStartedStudies().toString("dd/MM/yyyy"), String.valueOf(days < 1 ? 1 : days), this.getGuidersNames(process2))));
    }

    private int getDaysUntilNow(LocalDate begin) {
        return Days.daysBetween((ReadablePartial)begin, (ReadablePartial)new LocalDate()).getDays();
    }

    private String getGuidersNames(PhdIndividualProgramProcess process2) {
        StringBuilder builder = new StringBuilder();
        Iterator values = process2.getGuidingsSet().iterator();
        while (values.hasNext()) {
            builder.append(((PhdParticipant)((Object)values.next())).getName()).append(values.hasNext() ? ", " : "");
        }
        if (!process2.getGuidingsSet().isEmpty()) {
            builder.insert(0, "(").insert(builder.length(), ")");
        }
        return builder.toString();
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.alert.public.presentation.seminar.description", (String[])new String[0]);
    }

    protected boolean isToDiscard() {
        return !this.getProcess().getActiveState().isActive() || this.getProcess().getSeminarProcess() != null;
    }

    public boolean isToFire() {
        if (this.hasExceedLimitDate()) {
            if (this.getFireDate() == null) {
                return true;
            }
            if (this.getDaysUntilNow(this.getFireDate().toLocalDate()) > MAX_DAYS_AFTER_LIMIT_REACHED) {
                return true;
            }
        }
        return this.hasExceedFirstAlertDate() && this.getFireDate() == null;
    }

    private boolean hasExceedFirstAlertDate() {
        return !new LocalDate().isBefore((ReadablePartial)this.getFirstAlertDate());
    }

    private LocalDate getFirstAlertDate() {
        return this.getLimitDate().minusDays(30);
    }

    private boolean hasExceedLimitDate() {
        return !new LocalDate().isBefore((ReadablePartial)this.getLimitDate());
    }

    private LocalDate getLimitDate() {
        return this.getProcess().getWhenStartedStudies().plusDays(MAX_DAYS);
    }

    protected void generateMessage() {
        super.init(this.buildSubject(this.getProcess()), this.buildBody(this.getProcess()));
        this.generateMessageForStudent();
        this.generateMessageForCoodinator();
        this.generateMessageForAcademicOffice();
        this.generateMessageForGuiders();
    }

    private void generateMessageForCoodinator() {
        this.generateMessage(UserGroup.of(Person.convertToUsers(this.getProcess().getPhdProgram().getCoordinatorsFor(ExecutionYear.readCurrentExecutionYear()))));
    }

    private void generateMessageForAcademicOffice() {
        this.generateMessage((Group)AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_PHD_PROCESSES, (AcademicProgram)((Object)this.getProcess().getPhdProgram())));
    }

    private void generateMessageForStudent() {
        this.generateMessage(UserGroup.of((User[])new User[]{this.getProcess().getPerson().getUser()}));
    }

    private void generateMessageForGuiders() {
        for (PhdParticipant guiding : this.getProcess().getGuidingsSet()) {
            if (guiding.isInternal()) {
                this.generateMessage(UserGroup.of((User[])new User[]{((InternalPhdParticipant)((Object)guiding)).getPerson().getUser()}));
                continue;
            }
            new Message((Sender)((Object)this.getSender()), Collections.emptyList(), Collections.emptyList(), this.buildMailSubject(), this.buildMailBody(), Collections.singleton(guiding.getEmail()));
        }
    }

    private void generateMessage(Group group) {
        ImmutableSet members = FluentIterable.from((Iterable)group.getMembers()).transform(User_Base::getPerson).toSet();
        new PhdAlertMessage(this.getProcess(), (Collection<Person>)members, this.getFormattedSubject(), this.getFormattedBody());
        new Message((Sender)((Object)this.getSender()), new Recipient("", group), this.buildMailSubject(), this.buildMailBody());
    }

    public boolean isSystemAlert() {
        return true;
    }

    public boolean isToSendMail() {
        return true;
    }
}

