/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.degreeStructure.EctsComparabilityTable;
import org.fenixedu.academic.domain.degreeStructure.EctsConversionTable_Base;
import org.fenixedu.academic.domain.degreeStructure.EctsTableIndex;
import org.fenixedu.academic.domain.degreeStructure.IEctsConversionTable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.bennu.core.domain.Bennu;

public abstract class EctsConversionTable
extends EctsConversionTable_Base
implements IEctsConversionTable {
    protected void init(AcademicInterval year, EctsComparabilityTable table) {
        this.setYear(year);
        this.setEctsTable(table);
        for (EctsTableIndex index : Bennu.getInstance().getEctsTableIndexSet()) {
            if (!index.getYear().equals(year)) continue;
            this.setIndex(index);
            return;
        }
        this.setIndex(new EctsTableIndex(year));
    }

    public Grade convert(Grade grade) {
        switch (grade.getGradeScale()) {
            case TYPE20: {
                return Grade.createGrade(this.getEctsTable().convert(grade.getIntegerValue()), GradeScale.TYPEECTS);
            }
            case TYPEAP: {
                return Grade.createGrade("NA", GradeScale.TYPEECTS);
            }
            case TYPEAPT: {
                return grade;
            }
        }
        throw new DomainException("error.ects.unable.to.convert.grade", new String[0]);
    }

    public void delete() {
        this.setIndex(null);
        this.deleteDomainObject();
    }
}

