/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class EctsComparabilityTable
implements Serializable {
    private static final long serialVersionUID = 4007115993594121554L;
    private final char[] table;

    EctsComparabilityTable(char[] table) {
        this.table = table;
    }

    EctsComparabilityTable(String[] table) {
        char[] converted = new char[table.length];
        for (int i = 0; i < table.length; ++i) {
            if (table[i].trim().length() != 1 || table[i].trim().charAt(0) < 'A' || table[i].trim().charAt(0) > 'E') {
                throw new DomainException("error.ects.invalidTable", StringUtils.join((Object[])table, (String)"<tab>"));
            }
            converted[i] = table[i].trim().charAt(0);
        }
        this.table = converted;
    }

    public String convert(int grade) {
        if (grade < 10 || grade > 20) {
            throw new DomainException("error.degreeStructure.converting.grade.not.in.approval.range", new String[0]);
        }
        return Character.toString(this.table[grade - 10]);
    }

    public String getPrintableFormat() {
        return this.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof EctsComparabilityTable) {
            EctsComparabilityTable table = (EctsComparabilityTable)object;
            return Arrays.equals(this.table, table.table);
        }
        return false;
    }

    public String toString() {
        return new String(this.table);
    }

    public static EctsComparabilityTable fromString(String serialized) {
        return new EctsComparabilityTable(serialized.toCharArray());
    }

    public static EctsComparabilityTable fromStringArray(String[] table) {
        if (EctsComparabilityTable.isEmpty(table)) {
            return null;
        }
        return new EctsComparabilityTable(table);
    }

    private static boolean isEmpty(String[] table) {
        for (String part : table) {
            if (StringUtils.isEmpty((String)part)) continue;
            return false;
        }
        return true;
    }
}

