/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoad_Base;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.bennu.core.domain.Bennu;

public class CompetenceCourseLoad
extends CompetenceCourseLoad_Base
implements Comparable {
    public static int NUMBER_OF_WEEKS = 14;

    protected CompetenceCourseLoad() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public CompetenceCourseLoad(CompetenceCourseLoad existingLoad) {
        this(existingLoad.getTheoreticalHours(), existingLoad.getProblemsHours(), existingLoad.getLaboratorialHours(), existingLoad.getSeminaryHours(), existingLoad.getFieldWorkHours(), existingLoad.getTrainingPeriodHours(), existingLoad.getTutorialOrientationHours(), existingLoad.getAutonomousWorkHours(), existingLoad.getEctsCredits(), existingLoad.getLoadOrder(), existingLoad.getAcademicPeriod());
    }

    public CompetenceCourseLoad(Double theoreticalHours, Double problemsHours, Double laboratorialHours, Double seminaryHours, Double fieldWorkHours, Double trainingPeriodHours, Double tutorialOrientationHours, Double autonomousWorkHours, Double ectsCredits, Integer order, AcademicPeriod academicPeriod) {
        this();
        this.setInformation(theoreticalHours, problemsHours, laboratorialHours, seminaryHours, fieldWorkHours, trainingPeriodHours, tutorialOrientationHours, autonomousWorkHours, ectsCredits, order, academicPeriod);
    }

    public void edit(Double theoreticalHours, Double problemsHours, Double laboratorialHours, Double seminaryHours, Double fieldWorkHours, Double trainingPeriodHours, Double tutorialOrientationHours, Double autonomousWorkHours, Double ectsCredits, Integer order, AcademicPeriod academicPeriod) {
        this.setInformation(theoreticalHours, problemsHours, laboratorialHours, seminaryHours, fieldWorkHours, trainingPeriodHours, tutorialOrientationHours, autonomousWorkHours, ectsCredits, order, academicPeriod);
    }

    private void setInformation(Double theoreticalHours, Double problemsHours, Double laboratorialHours, Double seminaryHours, Double fieldWorkHours, Double trainingPeriodHours, Double tutorialOrientationHours, Double autonomousWorkHours, Double ectsCredits, Integer order, AcademicPeriod academicPeriod) {
        this.setTheoreticalHours(theoreticalHours == null ? Double.valueOf(0.0) : theoreticalHours);
        this.setProblemsHours(problemsHours == null ? Double.valueOf(0.0) : problemsHours);
        this.setLaboratorialHours(laboratorialHours == null ? Double.valueOf(0.0) : laboratorialHours);
        this.setSeminaryHours(seminaryHours == null ? Double.valueOf(0.0) : seminaryHours);
        this.setFieldWorkHours(fieldWorkHours == null ? Double.valueOf(0.0) : fieldWorkHours);
        this.setTrainingPeriodHours(trainingPeriodHours == null ? Double.valueOf(0.0) : trainingPeriodHours);
        this.setTutorialOrientationHours(tutorialOrientationHours == null ? Double.valueOf(0.0) : tutorialOrientationHours);
        this.setAutonomousWorkHours(autonomousWorkHours == null ? Double.valueOf(0.0) : autonomousWorkHours);
        this.setEctsCredits(ectsCredits);
        this.setLoadOrder(order);
        this.setAcademicPeriod(academicPeriod);
    }

    public void delete() {
        this.setCompetenceCourseInformation(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public double getTotalLessonHours() {
        return this.getTheoreticalHours() + this.getProblemsHours() + this.getLaboratorialHours() + this.getSeminaryHours() + this.getFieldWorkHours() + this.getTrainingPeriodHours() + this.getTutorialOrientationHours();
    }

    public Double getContactLoad() {
        return (double)NUMBER_OF_WEEKS * this.getTotalLessonHours();
    }

    public Double getTotalLoad() {
        return this.getAutonomousWorkHours() + this.getContactLoad();
    }

    public int compareTo(Object o) {
        return this.getOrder().compareTo(((CompetenceCourseLoad)o).getOrder());
    }

    @Deprecated
    public Integer getOrder() {
        return super.getLoadOrder();
    }

    @Deprecated
    public void setOrder(Integer order) {
        super.setLoadOrder(order);
    }
}

