/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curriculum;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.curriculum.GradeType;
import org.fenixedu.academic.domain.curriculum.IGrade;
import org.fenixedu.academic.domain.exceptions.DomainException;

class Grade
implements IGrade {
    private Object gradeValue;
    private GradeType gradeType;

    public Grade(int grade) {
        this.initNumeric(grade);
    }

    public Grade(String grade) {
        if (grade == null || grade.equals("") || grade.equals("NA")) {
            this.gradeValue = "NA";
            this.gradeType = GradeType.GRADENA;
        } else if (StringUtils.isNumeric((String)grade)) {
            Integer numericGrade = Integer.parseInt(grade);
            this.initNumeric(numericGrade);
        } else if (grade.equals("AP")) {
            this.gradeValue = grade;
            this.gradeType = GradeType.GRADEAP;
        } else {
            this.gradeValue = "RE";
            this.gradeType = GradeType.GRADERE;
        }
    }

    protected void initNumeric(int grade) {
        this.gradeValue = grade;
        this.gradeType = grade <= 5 ? GradeType.GRADEFIVE : GradeType.GRADETWENTY;
    }

    @Override
    public Object getGradeValue() {
        return this.gradeValue;
    }

    @Override
    public GradeType getGradeType() {
        return this.gradeType;
    }

    @Override
    public int compareTo(IGrade o) {
        if (this.getGradeType() == o.getGradeType()) {
            if (this.getGradeType() == GradeType.GRADEFIVE || this.getGradeType() == GradeType.GRADETWENTY) {
                Integer grade1 = (Integer)this.getGradeValue();
                Integer grade2 = (Integer)o.getGradeValue();
                return grade1.compareTo(grade2);
            }
            return 0;
        }
        if (this.getGradeType() == GradeType.GRADENA || this.getGradeType() == GradeType.GRADERE) {
            return 1;
        }
        if (o.getGradeType() == GradeType.GRADENA || o.getGradeType() == GradeType.GRADERE) {
            return -1;
        }
        throw new DomainException("error.grade.different.grade.types", new String[0]);
    }
}

