/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CompositeRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleNotPersistent;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.studentCurriculum.StandaloneCurriculumGroup;
import org.fenixedu.academic.dto.GenericPair;

public class MaximumNumberOfEctsInStandaloneCurriculumGroup
extends CurricularRuleNotPersistent {
    public static double MAXIMUM_DEFAULT_VALUE = 20.25;
    private StandaloneCurriculumGroup standaloneCurriculumGroup;
    private double maximumEcts;

    public MaximumNumberOfEctsInStandaloneCurriculumGroup(StandaloneCurriculumGroup standaloneCurriculumGroup) {
        this(standaloneCurriculumGroup, MAXIMUM_DEFAULT_VALUE);
    }

    public MaximumNumberOfEctsInStandaloneCurriculumGroup(StandaloneCurriculumGroup standaloneCurriculumGroup, double maximumEcts) {
        this.standaloneCurriculumGroup = standaloneCurriculumGroup;
        this.maximumEcts = maximumEcts;
    }

    @Override
    public CourseGroup getContextCourseGroup() {
        return null;
    }

    @Override
    public CurricularRuleType getCurricularRuleType() {
        return CurricularRuleType.MAXIMUM_NUMBER_OF_ECTS_IN_STANDALONE_CURRICULUM_GROUP;
    }

    @Override
    public DegreeModule getDegreeModuleToApplyRule() {
        return null;
    }

    public StandaloneCurriculumGroup getStandaloneCurriculumGroup() {
        return this.standaloneCurriculumGroup;
    }

    @Override
    public ExecutionSemester getBegin() {
        return ExecutionSemester.readActualExecutionSemester();
    }

    @Override
    public ExecutionSemester getEnd() {
        return null;
    }

    @Override
    public List<GenericPair<Object, Boolean>> getLabel() {
        return Collections.singletonList(new GenericPair<String, Boolean>("label.MaximumNumberOfEctsInStandaloneCurriculumGroup", true));
    }

    @Override
    public CompositeRule getParentCompositeRule() {
        return null;
    }

    @Override
    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }

    public double getMaximumEcts() {
        return this.maximumEcts;
    }

    public boolean allowEcts(double ects) {
        return ects <= this.maximumEcts;
    }

    public static boolean allowEctsCheckingDefaultValue(double ects) {
        return ects <= MAXIMUM_DEFAULT_VALUE;
    }
}

